/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.internal.OnEventResponse;
import com.google.android.gms.drive.internal.ag;
import com.google.android.gms.drive.internal.w;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class DriveEventService
extends Service
implements ChangeListener,
CompletionListener {
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String mName;
    private CountDownLatch Pg;
    a Ph;
    boolean Pi = false;
    int Pj = -1;

    protected DriveEventService(String name) {
        this.mName = name;
    }

    protected DriveEventService() {
        this("DriveEventService");
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.Ph == null && !this.Pi) {
                this.Pi = true;
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                this.Pg = new CountDownLatch(1);
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Looper.prepare();
                            DriveEventService.this.Ph = new a();
                            DriveEventService.this.Pi = false;
                            countDownLatch.countDown();
                            w.m("DriveEventService", "Bound and starting loop");
                            Looper.loop();
                            w.m("DriveEventService", "Finished loop");
                        }
                        finally {
                            if (DriveEventService.this.Pg != null) {
                                DriveEventService.this.Pg.countDown();
                            }
                        }
                    }
                }.start();
                try {
                    boolean bl2 = countDownLatch.await(5000L, TimeUnit.MILLISECONDS);
                    if (!bl2) {
                        w.p("DriveEventService", "Failed to synchronously initialize event handler.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new b().asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        w.m("DriveEventService", "onDestroy");
        if (this.Ph != null) {
            Message message = this.Ph.iE();
            this.Ph.sendMessage(message);
            this.Ph = null;
            try {
                boolean bl2 = this.Pg.await(5000L, TimeUnit.MILLISECONDS);
                if (!bl2) {
                    w.o("DriveEventService", "Failed to synchronously quit event handler. Will quit itself");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.Pg = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent event) {
        w.o(this.mName, "Unhandled change event: " + event);
    }

    @Override
    public void onCompletion(CompletionEvent event) {
        w.o(this.mName, "Unhandled completion event: " + event);
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private void a(OnEventResponse onEventResponse) {
        DriveEvent driveEvent = onEventResponse.iQ();
        w.m("DriveEventService", "handleEventMessage: " + driveEvent);
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    break;
                }
                case 2: {
                    CompletionEvent completionEvent = (CompletionEvent)driveEvent;
                    this.onCompletion(completionEvent);
                    break;
                }
                default: {
                    w.o(this.mName, "Unhandled event: " + driveEvent);
                    break;
                }
            }
        }
        catch (Exception exception) {
            w.a(this.mName, exception, "Error handling event: " + driveEvent);
        }
    }

    private void iD() throws SecurityException {
        int n2 = this.getCallingUid();
        if (n2 == this.Pj) {
            return;
        }
        boolean bl2 = GooglePlayServicesUtil.b(this.getPackageManager(), "com.google.android.gms");
        if (bl2 && this.bh(n2)) {
            this.Pj = n2;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    private boolean bh(int n2) {
        String string2 = "com.google.android.gms";
        PackageManager packageManager = this.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n2);
        if (stringArray != null) {
            for (String string3 : stringArray) {
                if (!string2.equals(string3)) continue;
                return true;
            }
        }
        return false;
    }

    final class b
    extends ag.a {
        b() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void c(OnEventResponse onEventResponse) throws RemoteException {
            DriveEventService driveEventService = DriveEventService.this;
            synchronized (driveEventService) {
                w.m("DriveEventService", "onEvent: " + onEventResponse);
                DriveEventService.this.iD();
                if (DriveEventService.this.Ph != null) {
                    Message message = DriveEventService.this.Ph.b(onEventResponse);
                    DriveEventService.this.Ph.sendMessage(message);
                } else {
                    w.p("DriveEventService", "Receiving event before initialize is completed.");
                }
            }
        }
    }

    final class a
    extends Handler {
        a() {
        }

        private Message b(OnEventResponse onEventResponse) {
            return this.obtainMessage(1, onEventResponse);
        }

        private Message iE() {
            return this.obtainMessage(2);
        }

        public void handleMessage(Message msg) {
            w.m("DriveEventService", "handleMessage message type:" + msg.what);
            switch (msg.what) {
                case 1: {
                    DriveEventService.this.a((OnEventResponse)msg.obj);
                    break;
                }
                case 2: {
                    this.getLooper().quit();
                    break;
                }
                default: {
                    w.o("DriveEventService", "Unexpected message type:" + msg.what);
                }
            }
        }
    }
}

