/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.b;
import com.google.android.gms.drive.internal.ah;
import com.google.android.gms.drive.internal.w;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.lh;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
implements SafeParcelable,
ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new b();
    final int CK;
    final DriveId Oj;
    final String DZ;
    final ParcelFileDescriptor OY;
    final ParcelFileDescriptor OZ;
    final MetadataBundle Pa;
    final List<String> Pb;
    final int FP;
    final IBinder Pc;
    private boolean Pd = false;
    private boolean Pe = false;
    private boolean Pf = false;

    CompletionEvent(int versionCode, DriveId driveId, String accountName, ParcelFileDescriptor baseParcelFileDescriptor, ParcelFileDescriptor modifiedParcelFileDescriptor, MetadataBundle modifiedMetadataBundle, List<String> trackingTags, int status, IBinder releaseCallback) {
        this.CK = versionCode;
        this.Oj = driveId;
        this.DZ = accountName;
        this.OY = baseParcelFileDescriptor;
        this.OZ = modifiedParcelFileDescriptor;
        this.Pa = modifiedMetadataBundle;
        this.Pb = trackingTags;
        this.FP = status;
        this.Pc = releaseCallback;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        b.a(this, dest, flags);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public DriveId getDriveId() {
        this.iC();
        return this.Oj;
    }

    public String getAccountName() {
        this.iC();
        return this.DZ;
    }

    public InputStream getBaseContentsInputStream() {
        this.iC();
        if (this.OY == null) {
            return null;
        }
        if (this.Pd) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.Pd = true;
        return new FileInputStream(this.OY.getFileDescriptor());
    }

    public InputStream getModifiedContentsInputStream() {
        this.iC();
        if (this.OZ == null) {
            return null;
        }
        if (this.Pe) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.Pe = true;
        return new FileInputStream(this.OZ.getFileDescriptor());
    }

    public MetadataChangeSet getModifiedMetadataChangeSet() {
        this.iC();
        return this.Pa != null ? new MetadataChangeSet(this.Pa) : null;
    }

    public List<String> getTrackingTags() {
        this.iC();
        return new ArrayList<String>(this.Pb);
    }

    public int getStatus() {
        this.iC();
        return this.FP;
    }

    public void dismiss() {
        this.M(false);
    }

    public void snooze() {
        this.M(true);
    }

    private void M(boolean bl2) {
        this.iC();
        this.Pf = true;
        lh.a(this.OY);
        lh.a(this.OZ);
        if (this.Pc == null) {
            w.p("CompletionEvent", "No callback on " + (bl2 ? "snooze" : "dismiss"));
            return;
        }
        try {
            ah.a.aa(this.Pc).M(bl2);
        }
        catch (RemoteException remoteException) {
            w.p("CompletionEvent", "RemoteException on " + (bl2 ? "snooze" : "dismiss") + ": " + (Object)((Object)remoteException));
        }
    }

    private void iC() {
        if (this.Pf) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public String toString() {
        String string2 = this.Pb == null ? "<null>" : "'" + TextUtils.join((CharSequence)"','", this.Pb) + "'";
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", this.Oj, this.FP, string2);
    }
}

