/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.jx;
import com.google.android.gms.internal.ln;
import com.google.android.gms.internal.lp;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    public static final MetadataChangeSet OE = new MetadataChangeSet(MetadataBundle.iZ());
    private final MetadataBundle OF;

    public MetadataChangeSet(MetadataBundle bag) {
        this.OF = MetadataBundle.a(bag);
    }

    public Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.OF.a(ln.Rl);
        return appVisibleCustomProperties == null ? Collections.emptyMap() : appVisibleCustomProperties.iV();
    }

    public String getDescription() {
        return this.OF.a(ln.Rm);
    }

    public String getIndexableText() {
        return this.OF.a(ln.Rr);
    }

    public Date getLastViewedByMeDate() {
        return this.OF.a(lp.RR);
    }

    public String getMimeType() {
        return this.OF.a(ln.RA);
    }

    public String getTitle() {
        return this.OF.a(ln.RJ);
    }

    public Boolean isPinned() {
        return this.OF.a(ln.Rv);
    }

    public Boolean isStarred() {
        return this.OF.a(ln.RH);
    }

    public Boolean isViewed() {
        return this.OF.a(ln.Rz);
    }

    public MetadataBundle iz() {
        return this.OF;
    }

    public static class Builder {
        private final MetadataBundle OF = MetadataBundle.iZ();
        private AppVisibleCustomProperties.a OG;

        private AppVisibleCustomProperties.a iA() {
            if (this.OG == null) {
                this.OG = new AppVisibleCustomProperties.a();
            }
            return this.OG;
        }

        private int bk(String string2) {
            return string2 == null ? 0 : string2.getBytes().length;
        }

        private String i(String string2, int n2, int n3) {
            return String.format("%s must be no more than %d bytes, but is %d bytes.", string2, n2, n3);
        }

        private void j(String string2, int n2, int n3) {
            jx.b(n3 <= n2, (Object)this.i(string2, n2, n3));
        }

        public Builder setCustomProperty(CustomPropertyKey key, String value) {
            jx.b(key, (Object)"key");
            jx.b(value, (Object)"value");
            int n2 = this.bk(key.getKey()) + this.bk(value);
            this.j("The total size of key string and value string of a custom property", 124, n2);
            this.iA().a(key, value);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey key) {
            jx.b(key, (Object)"key");
            this.iA().a(key, null);
            return this;
        }

        public Builder setDescription(String description) {
            this.OF.b(ln.Rm, description);
            return this;
        }

        public Builder setIndexableText(String text) {
            int n2 = this.bk(text);
            this.j("Indexable text size", 131072, n2);
            this.OF.b(ln.Rr, text);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.OF.b(lp.RR, date);
            return this;
        }

        public Builder setMimeType(String mimeType) {
            this.OF.b(ln.RA, mimeType);
            return this;
        }

        public Builder setPinned(boolean pinned) {
            this.OF.b(ln.Rv, pinned);
            return this;
        }

        public Builder setStarred(boolean starred) {
            this.OF.b(ln.RH, starred);
            return this;
        }

        public Builder setTitle(String title) {
            this.OF.b(ln.RJ, title);
            return this;
        }

        public Builder setViewed(boolean viewed) {
            this.OF.b(ln.Rz, viewed);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.OG != null) {
                this.OF.b(ln.Rl, this.OG.iW());
            }
            return new MetadataChangeSet(this.OF);
        }
    }
}

