/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.internal.r;
import com.google.android.gms.internal.jv;

public final class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String Oy;
    private final boolean Oz;
    private final int OA;

    public ExecutionOptions(String trackingTag, boolean notifyOnCompletion, int conflictStrategy) {
        this.Oy = trackingTag;
        this.Oz = notifyOnCompletion;
        this.OA = conflictStrategy;
    }

    public String iv() {
        return this.Oy;
    }

    public boolean iw() {
        return this.Oz;
    }

    public int ix() {
        return this.OA;
    }

    public static boolean ba(int n2) {
        switch (n2) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean bb(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean bj(String string2) {
        return string2 != null && !string2.isEmpty() && string2.length() <= 65536;
    }

    public static void a(GoogleApiClient googleApiClient, ExecutionOptions executionOptions) {
        r r2 = googleApiClient.a(Drive.DQ);
        if (executionOptions.iw() && !r2.iJ()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object o2) {
        if (o2 == null || o2.getClass() != this.getClass()) {
            return false;
        }
        if (o2 == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)o2;
        return jv.equal(this.Oy, executionOptions.Oy) && this.OA == executionOptions.OA && this.Oz == executionOptions.Oz;
    }

    public int hashCode() {
        return jv.hashCode(this.Oy, this.OA, this.Oz);
    }

    public static final class Builder {
        private String Oy;
        private boolean Oz;
        private int OA = 0;

        public Builder setTrackingTag(String trackingTag) {
            if (!ExecutionOptions.bj(trackingTag)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.Oy = trackingTag;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean notify) {
            this.Oz = notify;
            return this;
        }

        public Builder setConflictStrategy(int strategy) {
            if (!ExecutionOptions.bb(strategy)) {
                throw new IllegalArgumentException("Unrecognized value for conflict strategy: " + strategy);
            }
            this.OA = strategy;
            return this;
        }

        public ExecutionOptions build() {
            if (this.OA == 1 && !this.Oz) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
            return new ExecutionOptions(this.Oy, this.Oz, this.OA);
        }
    }
}

