/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.internal.in;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.li;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    private final String FT;
    private int FU;
    private String FV;
    private MediaMetadata FW;
    private long FX;
    private List<MediaTrack> FY;
    private TextTrackStyle FZ;
    private JSONObject Ga;

    MediaInfo(String contentId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentId)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.FT = contentId;
        this.FU = -1;
    }

    MediaInfo(JSONObject json) throws JSONException {
        double d2;
        int n2;
        JSONObject jSONObject;
        this.FT = json.getString("contentId");
        String string2 = json.getString("streamType");
        this.FU = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.FV = json.getString("contentType");
        if (json.has("metadata")) {
            jSONObject = json.getJSONObject("metadata");
            n2 = jSONObject.getInt("metadataType");
            this.FW = new MediaMetadata(n2);
            this.FW.c(jSONObject);
        }
        this.FX = -1L;
        if (json.has("duration") && !json.isNull("duration") && !Double.isNaN(d2 = json.optDouble("duration", 0.0)) && !Double.isInfinite(d2)) {
            this.FX = in.b(d2);
        }
        if (json.has("tracks")) {
            this.FY = new ArrayList<MediaTrack>();
            jSONObject = json.getJSONArray("tracks");
            for (n2 = 0; n2 < jSONObject.length(); ++n2) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(n2);
                MediaTrack mediaTrack = new MediaTrack(jSONObject2);
                this.FY.add(mediaTrack);
            }
        } else {
            this.FY = null;
        }
        if (json.has("textTrackStyle")) {
            jSONObject = json.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.c(jSONObject);
            this.FZ = textTrackStyle;
        } else {
            this.FZ = null;
        }
        this.Ga = json.optJSONObject("customData");
    }

    public String getContentId() {
        return this.FT;
    }

    void setStreamType(int streamType) throws IllegalArgumentException {
        if (streamType < -1 || streamType > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.FU = streamType;
    }

    public int getStreamType() {
        return this.FU;
    }

    void setContentType(String contentType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.FV = contentType;
    }

    public String getContentType() {
        return this.FV;
    }

    void a(MediaMetadata mediaMetadata) {
        this.FW = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.FW;
    }

    void m(long l2) throws IllegalArgumentException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Stream duration cannot be negative");
        }
        this.FX = l2;
    }

    public long getStreamDuration() {
        return this.FX;
    }

    void d(List<MediaTrack> list) {
        this.FY = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.FY;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.FZ = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.FZ;
    }

    void setCustomData(JSONObject customData) {
        this.Ga = customData;
    }

    public JSONObject getCustomData() {
        return this.Ga;
    }

    void fQ() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.FT)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.FV)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.FU == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.FT);
            switch (this.FU) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.FV != null) {
                jSONObject.put("contentType", (Object)this.FV);
            }
            if (this.FW != null) {
                jSONObject.put("metadata", (Object)this.FW.toJson());
            }
            jSONObject.put("duration", in.o(this.FX));
            if (this.FY != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.FY) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.FZ != null) {
                jSONObject.put("textTrackStyle", (Object)this.FZ.toJson());
            }
            if (this.Ga != null) {
                jSONObject.put("customData", (Object)this.Ga);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)other;
        if (this.Ga == null != (mediaInfo.Ga == null)) {
            return false;
        }
        if (this.Ga != null && mediaInfo.Ga != null && !li.d(this.Ga, mediaInfo.Ga)) {
            return false;
        }
        return in.a(this.FT, mediaInfo.FT) && this.FU == mediaInfo.FU && in.a(this.FV, mediaInfo.FV) && in.a(this.FW, mediaInfo.FW) && this.FX == mediaInfo.FX;
    }

    public int hashCode() {
        return jv.hashCode(this.FT, this.FU, this.FV, this.FW, this.FX, String.valueOf(this.Ga));
    }

    public static class Builder {
        private final MediaInfo Gb;

        public Builder(String contentId) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)contentId)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.Gb = new MediaInfo(contentId);
        }

        public Builder setStreamType(int streamType) throws IllegalArgumentException {
            this.Gb.setStreamType(streamType);
            return this;
        }

        public Builder setContentType(String contentType) throws IllegalArgumentException {
            this.Gb.setContentType(contentType);
            return this;
        }

        public Builder setMetadata(MediaMetadata metadata) {
            this.Gb.a(metadata);
            return this;
        }

        public Builder setStreamDuration(long duration) throws IllegalArgumentException {
            this.Gb.m(duration);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.Gb.setCustomData(customData);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> mediaTracks) {
            this.Gb.d(mediaTracks);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.Gb.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.Gb.fQ();
            return this.Gb;
        }
    }
}

