/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.b;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.in;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
implements SafeParcelable {
    public static final Parcelable.Creator<CastDevice> CREATOR = new b();
    private final int CK;
    private String FG;
    String FH;
    private Inet4Address FI;
    private String FJ;
    private String FK;
    private String FL;
    private int FM;
    private List<WebImage> FN;
    private int FO;
    private int FP;

    CastDevice(int versionCode, String deviceId, String hostAddress, String friendlyName, String modelName, String deviceVersion, int servicePort, List<WebImage> icons, int capabilities, int status) {
        this.CK = versionCode;
        this.FG = deviceId;
        this.FH = hostAddress;
        if (this.FH != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.FH);
                if (inetAddress instanceof Inet4Address) {
                    this.FI = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.FI = null;
            }
        }
        this.FJ = friendlyName;
        this.FK = modelName;
        this.FL = deviceVersion;
        this.FM = servicePort;
        this.FN = icons;
        this.FO = capabilities;
        this.FP = status;
    }

    private CastDevice() {
        this(3, null, null, null, null, null, -1, new ArrayList<WebImage>(), 0, -1);
    }

    int getVersionCode() {
        return this.CK;
    }

    public String getDeviceId() {
        return this.FG;
    }

    public Inet4Address getIpAddress() {
        return this.FI;
    }

    public String getFriendlyName() {
        return this.FJ;
    }

    public String getModelName() {
        return this.FK;
    }

    public String getDeviceVersion() {
        return this.FL;
    }

    public int getServicePort() {
        return this.FM;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.FN);
    }

    public WebImage getIcon(int preferredWidth, int preferredHeight) {
        if (this.FN.isEmpty()) {
            return null;
        }
        if (preferredWidth <= 0 || preferredHeight <= 0) {
            return this.FN.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.FN) {
            int n2 = webImage3.getWidth();
            int n3 = webImage3.getHeight();
            if (n2 >= preferredWidth && n3 >= preferredHeight) {
                if (webImage != null && (webImage.getWidth() <= n2 || webImage.getHeight() <= n3)) continue;
                webImage = webImage3;
                continue;
            }
            if (n2 >= preferredWidth || n3 >= preferredHeight || webImage2 != null && (webImage2.getWidth() >= n2 || webImage2.getHeight() >= n3)) continue;
            webImage2 = webImage3;
        }
        Object object = null;
        object = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.FN.get(0));
        return object;
    }

    public boolean hasIcons() {
        return !this.FN.isEmpty();
    }

    public int getCapabilities() {
        return this.FO;
    }

    public int getStatus() {
        return this.FP;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.FJ, this.FG);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)obj;
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return in.a(this.FG, castDevice.FG) && in.a(this.FI, castDevice.FI) && in.a(this.FK, castDevice.FK) && in.a(this.FJ, castDevice.FJ) && in.a(this.FL, castDevice.FL) && this.FM == castDevice.FM && in.a(this.FN, castDevice.FN) && this.FO == castDevice.FO && this.FP == castDevice.FP;
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return in.a(this.getDeviceId(), castDevice.getDeviceId());
    }

    public int hashCode() {
        return this.FG == null ? 0 : this.FG.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle extras) {
        if (extras == null) {
            return null;
        }
        extras.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)extras.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.FG.startsWith("__cast_nearby__");
    }
}

