/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appindexing;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.google.android.gms.internal.jx;

public class Thing {
    final Bundle DI;

    Thing(Bundle propertyBundle) {
        this.DI = propertyBundle;
    }

    public Bundle fI() {
        return this.DI;
    }

    public static class Builder {
        final Bundle DJ = new Bundle();

        public Builder setName(String name) {
            jx.i(name);
            this.put("name", name);
            return this;
        }

        public Builder setUrl(Uri url) {
            jx.i(url);
            this.put("url", url.toString());
            return this;
        }

        public Builder setId(String id2) {
            if (id2 != null) {
                this.put("id", id2);
            }
            return this;
        }

        public Builder setType(String type) {
            this.put("type", type);
            return this;
        }

        public Builder setDescription(String description) {
            this.put("description", description);
            return this;
        }

        public Builder put(String key, String value) {
            jx.i(key);
            if (value != null) {
                this.DJ.putString(key, value);
            }
            return this;
        }

        public Builder put(String key, Thing value) {
            jx.i(key);
            if (value != null) {
                this.DJ.putParcelable(key, (Parcelable)value.DI);
            }
            return this;
        }

        public Thing build() {
            return new Thing(this.DJ);
        }
    }
}

