/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.ae;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler yN;
    private final Tracker yO;
    private final Context mContext;
    private ExceptionParser yP;
    private GoogleAnalytics yQ;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler originalHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.yN = originalHandler;
        this.yO = tracker;
        this.yP = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        ae.V("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.yP;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.yP = exceptionParser;
    }

    GoogleAnalytics es() {
        if (this.yQ == null) {
            this.yQ = GoogleAnalytics.getInstance(this.mContext);
        }
        return this.yQ;
    }

    @Override
    public void uncaughtException(Thread t2, Throwable e2) {
        Object object;
        String string2 = "UncaughtException";
        if (this.yP != null) {
            object = t2 != null ? t2.getName() : null;
            string2 = this.yP.getDescription((String)object, e2);
        }
        ae.V("Tracking Exception: " + string2);
        this.yO.send(new HitBuilders.ExceptionBuilder().setDescription(string2).setFatal(true).build());
        object = this.es();
        ((GoogleAnalytics)object).dispatchLocalHits();
        ((GoogleAnalytics)object).dY();
        if (this.yN != null) {
            ae.V("Passing exception to original handler.");
            this.yN.uncaughtException(t2, e2);
        }
    }

    Thread.UncaughtExceptionHandler et() {
        return this.yN;
    }
}

