/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.search;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.search.SearchAdRequest;
import com.google.android.gms.internal.bh;

public final class SearchAdView
extends ViewGroup {
    private final bh ll;

    public SearchAdView(Context context) {
        super(context);
        this.ll = new bh(this);
    }

    public SearchAdView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.ll = new bh(this, attrs, false);
    }

    public SearchAdView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.ll = new bh(this, attrs, false);
    }

    public void destroy() {
        this.ll.destroy();
    }

    public AdListener getAdListener() {
        return this.ll.getAdListener();
    }

    public AdSize getAdSize() {
        return this.ll.getAdSize();
    }

    public String getAdUnitId() {
        return this.ll.getAdUnitId();
    }

    public void loadAd(SearchAdRequest searchAdRequest) {
        this.ll.a(searchAdRequest.Y());
    }

    public void pause() {
        this.ll.pause();
    }

    public void resume() {
        this.ll.resume();
    }

    public void setAdListener(AdListener adListener) {
        this.ll.setAdListener(adListener);
    }

    public void setAdSize(AdSize adSize) {
        this.ll.setAdSizes(adSize);
    }

    public void setAdUnitId(String adUnitId) {
        this.ll.setAdUnitId(adUnitId);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n2 = view.getMeasuredWidth();
            int n3 = view.getMeasuredHeight();
            int n4 = (right - left - n2) / 2;
            int n5 = (bottom - top - n3) / 2;
            view.layout(n4, n5, n4 + n2, n5 + n3);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n2 = 0;
        int n3 = 0;
        View view = this.getChildAt(0);
        AdSize adSize = this.getAdSize();
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
            n2 = view.getMeasuredWidth();
            n3 = view.getMeasuredHeight();
        } else if (adSize != null) {
            Context context = this.getContext();
            n2 = adSize.getWidthInPixels(context);
            n3 = adSize.getHeightInPixels(context);
        }
        n2 = Math.max(n2, this.getSuggestedMinimumWidth());
        n3 = Math.max(n3, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n2, (int)widthMeasureSpec), View.resolveSize((int)n3, (int)heightMeasureSpec));
    }
}

