/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.dynamic.e;
import com.google.android.gms.dynamic.f;
import com.google.android.gms.dynamic.h;
import com.google.android.gms.internal.or;
import com.google.android.gms.internal.os;
import com.google.android.gms.internal.oz;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private b atQ;
    private boolean mCreated = false;
    private final h atR = h.a(this);
    private final c atS = new c();
    private a atT = new a(this);
    private final Fragment Lt = this;
    private WalletFragmentOptions atU;
    private WalletFragmentInitParams atV;
    private MaskedWalletRequest atW;
    private MaskedWallet atX;
    private Boolean atY;

    public static SupportWalletFragment newInstance(WalletFragmentOptions options) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        supportWalletFragment.Lt.setArguments(bundle);
        return supportWalletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.atQ != null) {
            this.atQ.initialize(initParams);
            this.atV = null;
        } else if (this.atV == null) {
            this.atV = initParams;
            if (this.atW != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.atX != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.atQ != null) {
            this.atQ.updateMaskedWalletRequest(request);
            this.atW = null;
        } else {
            this.atW = request;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.atQ != null) {
            this.atQ.updateMaskedWallet(maskedWallet);
            this.atX = null;
        } else {
            this.atX = maskedWallet;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.atQ != null) {
            this.atQ.setEnabled(enabled);
            this.atY = null;
        } else {
            this.atY = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.atT.a(listener);
    }

    public int getState() {
        return this.atQ != null ? this.atQ.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.atU == null) {
            this.atU = WalletFragmentOptions.a((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.atU);
        this.atS.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.atV != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.atV = walletFragmentInitParams;
            }
            if (this.atW == null) {
                this.atW = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (this.atX == null) {
                this.atX = (MaskedWallet)savedInstanceState.getParcelable("maskedWallet");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.atU = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.atY = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.Lt.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.Lt.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.aa((Context)this.Lt.getActivity());
            this.atU = walletFragmentOptions;
        }
        this.mCreated = true;
        this.atS.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.atS.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.atS.onStart();
    }

    public void onResume() {
        super.onResume();
        this.atS.onResume();
        FragmentManager fragmentManager = this.Lt.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.Lt.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment(n2, (Activity)this.Lt.getActivity(), -1);
        }
    }

    public void onPause() {
        super.onPause();
        this.atS.onPause();
    }

    public void onStop() {
        super.onStop();
        this.atS.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.atS.onSaveInstanceState(outState);
        if (this.atV != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.atV);
            this.atV = null;
        }
        if (this.atW != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.atW);
            this.atW = null;
        }
        if (this.atX != null) {
            outState.putParcelable("maskedWallet", (Parcelable)this.atX);
            this.atX = null;
        }
        if (this.atU != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.atU);
            this.atU = null;
        }
        if (this.atY != null) {
            outState.putBoolean("enabled", this.atY.booleanValue());
            this.atY = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.atQ != null) {
            this.atQ.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class a
    extends os.a {
        private OnStateChangedListener atZ;
        private final SupportWalletFragment aua;

        a(SupportWalletFragment supportWalletFragment) {
            this.aua = supportWalletFragment;
        }

        @Override
        public void a(int n2, int n3, Bundle bundle) {
            if (this.atZ != null) {
                this.atZ.onStateChanged(this.aua, n2, n3, bundle);
            }
        }

        public void a(OnStateChangedListener onStateChangedListener) {
            this.atZ = onStateChangedListener;
        }
    }

    private static class b
    implements LifecycleDelegate {
        private final or aub;

        private b(or or2) {
            this.aub = or2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.aub.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.aub.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.aub.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.aub.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.aub.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.aub.a(e.k(activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onCreate(Bundle savedInstanceState) {
            try {
                this.aub.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                d d2 = this.aub.onCreateView(e.k(inflater), e.k(container), savedInstanceState);
                return (View)e.f(d2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onStart() {
            try {
                this.aub.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onResume() {
            try {
                this.aub.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onPause() {
            try {
                this.aub.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onStop() {
            try {
                this.aub.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onDestroyView() {
        }

        @Override
        public void onDestroy() {
        }

        @Override
        public void onLowMemory() {
        }

        @Override
        public void onSaveInstanceState(Bundle outState) {
            try {
                this.aub.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.aub.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class c
    extends com.google.android.gms.dynamic.a<b>
    implements View.OnClickListener {
        private c() {
        }

        @Override
        protected void a(f<b> f2) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.Lt.getActivity();
            if (SupportWalletFragment.this.atQ == null && SupportWalletFragment.this.mCreated && fragmentActivity != null) {
                try {
                    or or2 = oz.a((Activity)fragmentActivity, SupportWalletFragment.this.atR, SupportWalletFragment.this.atU, SupportWalletFragment.this.atT);
                    SupportWalletFragment.this.atQ = new b(or2);
                    SupportWalletFragment.this.atU = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                f2.a(SupportWalletFragment.this.atQ);
                if (SupportWalletFragment.this.atV != null) {
                    SupportWalletFragment.this.atQ.initialize(SupportWalletFragment.this.atV);
                    SupportWalletFragment.this.atV = null;
                }
                if (SupportWalletFragment.this.atW != null) {
                    SupportWalletFragment.this.atQ.updateMaskedWalletRequest(SupportWalletFragment.this.atW);
                    SupportWalletFragment.this.atW = null;
                }
                if (SupportWalletFragment.this.atX != null) {
                    SupportWalletFragment.this.atQ.updateMaskedWallet(SupportWalletFragment.this.atX);
                    SupportWalletFragment.this.atX = null;
                }
                if (SupportWalletFragment.this.atY != null) {
                    SupportWalletFragment.this.atQ.setEnabled(SupportWalletFragment.this.atY);
                    SupportWalletFragment.this.atY = null;
                }
            }
        }

        @Override
        protected void a(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)SupportWalletFragment.this.Lt.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n2 = -1;
            int n3 = -2;
            if (SupportWalletFragment.this.atU != null && (walletFragmentStyle = SupportWalletFragment.this.atU.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = SupportWalletFragment.this.Lt.getResources().getDisplayMetrics();
                n2 = walletFragmentStyle.a("buyButtonWidth", displayMetrics, n2);
                n3 = walletFragmentStyle.a("buyButtonHeight", displayMetrics, n3);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n2, n3));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.Lt.getActivity();
            int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity);
            GooglePlayServicesUtil.showErrorDialogFragment(n2, (Activity)fragmentActivity, -1);
        }
    }
}

