/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.a;
import com.google.android.gms.maps.b;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final a CREATOR = new a();
    private final int BR;
    private Boolean aiG;
    private Boolean aiH;
    private int aiI = -1;
    private CameraPosition aiJ;
    private Boolean aiK;
    private Boolean aiL;
    private Boolean aiM;
    private Boolean aiN;
    private Boolean aiO;
    private Boolean aiP;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.BR = versionCode;
        this.aiG = com.google.android.gms.maps.internal.a.a(zOrderOnTop);
        this.aiH = com.google.android.gms.maps.internal.a.a(useViewLifecycleInFragment);
        this.aiI = mapType;
        this.aiJ = camera;
        this.aiK = com.google.android.gms.maps.internal.a.a(zoomControlsEnabled);
        this.aiL = com.google.android.gms.maps.internal.a.a(compassEnabled);
        this.aiM = com.google.android.gms.maps.internal.a.a(scrollGesturesEnabled);
        this.aiN = com.google.android.gms.maps.internal.a.a(zoomGesturesEnabled);
        this.aiO = com.google.android.gms.maps.internal.a.a(tiltGesturesEnabled);
        this.aiP = com.google.android.gms.maps.internal.a.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.mM()) {
            b.a(this, out, flags);
        } else {
            a.a(this, out, flags);
        }
    }

    int getVersionCode() {
        return this.BR;
    }

    byte mr() {
        return com.google.android.gms.maps.internal.a.c(this.aiG);
    }

    byte ms() {
        return com.google.android.gms.maps.internal.a.c(this.aiH);
    }

    byte mt() {
        return com.google.android.gms.maps.internal.a.c(this.aiK);
    }

    byte mu() {
        return com.google.android.gms.maps.internal.a.c(this.aiL);
    }

    byte mv() {
        return com.google.android.gms.maps.internal.a.c(this.aiM);
    }

    byte mw() {
        return com.google.android.gms.maps.internal.a.c(this.aiN);
    }

    byte mx() {
        return com.google.android.gms.maps.internal.a.c(this.aiO);
    }

    byte my() {
        return com.google.android.gms.maps.internal.a.c(this.aiP);
    }

    public GoogleMapOptions() {
        this.BR = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.aiG = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.aiH = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.aiI = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.aiJ = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.aiK = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.aiL = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.aiM = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.aiN = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.aiO = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.aiP = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.aiG;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.aiH;
    }

    public int getMapType() {
        return this.aiI;
    }

    public CameraPosition getCamera() {
        return this.aiJ;
    }

    public Boolean getZoomControlsEnabled() {
        return this.aiK;
    }

    public Boolean getCompassEnabled() {
        return this.aiL;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.aiM;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.aiN;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.aiO;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.aiP;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

