/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.b;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int BR;
    int mPriority;
    long aes;
    long aet;
    boolean UK;
    long aei;
    int aeu;
    float aev;
    long aew;
    public static final b CREATOR = new b();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.BR = 1;
        this.mPriority = 102;
        this.aes = 3600000L;
        this.aet = 600000L;
        this.UK = false;
        this.aei = Long.MAX_VALUE;
        this.aeu = Integer.MAX_VALUE;
        this.aev = 0.0f;
        this.aew = 0L;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.eb(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.v(millis);
        this.aes = millis;
        if (!this.UK) {
            this.aet = (long)((double)this.aes / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.aes;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.v(millis);
        this.UK = true;
        this.aet = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.aet;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.aei = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.aei < 0L) {
            this.aei = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.aei = millis;
        if (this.aei < 0L) {
            this.aei = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.aei;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.aeu = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.aeu;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.aev = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.aev;
    }

    private static void v(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void eb(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement, long maxWaitTime) {
        this.BR = versionCode;
        this.mPriority = priority;
        this.aes = interval;
        this.aet = fastestInterval;
        this.UK = explicitFastestInterval;
        this.aei = expireAt;
        this.aeu = numUpdates;
        this.aev = smallestDisplacement;
        this.aew = maxWaitTime;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        b.a(this, parcel, flags);
    }

    public static String ec(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.ec(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.aes + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.aet + "ms");
        if (this.aei != Long.MAX_VALUE) {
            long l2 = this.aei - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.aeu != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.aeu);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return n.hashCode(this.mPriority, this.aes, this.aet, this.UK, this.aei, this.aeu, Float.valueOf(this.aev));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.aes == locationRequest.aes && this.aet == locationRequest.aet && this.UK == locationRequest.UK && this.aei == locationRequest.aei && this.aeu == locationRequest.aeu && this.aev == locationRequest.aev;
    }

    int getVersionCode() {
        return this.BR;
    }
}

