/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import com.google.android.gms.internal.mc;
import com.google.android.gms.location.Geofence;
import java.util.ArrayList;
import java.util.List;

public class GeofencingEvent {
    private final int tc;
    private final int aep;
    private final List<Geofence> aeq;
    private final Location aer;

    private GeofencingEvent(int errorCode, int transitionType, List<Geofence> triggeringGeofences, Location triggeringLocaton) {
        this.tc = errorCode;
        this.aep = transitionType;
        this.aeq = triggeringGeofences;
        this.aer = triggeringLocaton;
    }

    public static GeofencingEvent fromIntent(Intent intent) {
        if (intent == null) {
            return null;
        }
        int n2 = intent.getIntExtra("gms_error_code", -1);
        int n3 = GeofencingEvent.getGeofenceTransition(intent);
        List<Geofence> list = GeofencingEvent.getTriggeringGeofences(intent);
        Location location = (Location)intent.getParcelableExtra("com.google.android.location.intent.extra.triggering_location");
        return new GeofencingEvent(n2, n3, list, location);
    }

    private static int getGeofenceTransition(Intent intent) {
        int n2 = intent.getIntExtra("com.google.android.location.intent.extra.transition", -1);
        if (n2 == -1) {
            return -1;
        }
        if (n2 == 1 || n2 == 2 || n2 == 4) {
            return n2;
        }
        return -1;
    }

    private static List<Geofence> getTriggeringGeofences(Intent intent) {
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra("com.google.android.location.intent.extra.geofence_list");
        if (arrayList == null) {
            return null;
        }
        ArrayList<Geofence> arrayList2 = new ArrayList<Geofence>(arrayList.size());
        for (byte[] byArray : arrayList) {
            arrayList2.add(mc.h(byArray));
        }
        return arrayList2;
    }

    public boolean hasError() {
        return this.tc != -1;
    }

    public int getErrorCode() {
        return this.tc;
    }

    public int getGeofenceTransition() {
        return this.aep;
    }

    public List<Geofence> getTriggeringGeofences() {
        return this.aeq;
    }

    public Location getTriggeringLocation() {
        return this.aer;
    }
}

