/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.internal.ez;
import com.google.android.gms.internal.gb;
import com.google.android.gms.internal.gj;
import com.google.android.gms.internal.gs;
import com.google.android.gms.internal.gt;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;

@ez
public class ey
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler sR;
    private Thread.UncaughtExceptionHandler sS;
    private Context mContext;
    private gt sT;

    public static ey a(Context context, Thread thread, gt gt2) {
        if (context == null || thread == null || gt2 == null) {
            return null;
        }
        Bundle bundle = gb.bD();
        if (!ey.k(context)) {
            return null;
        }
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = thread.getUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler2 = thread.getDefaultUncaughtExceptionHandler();
        ey ey2 = new ey(context, gt2, uncaughtExceptionHandler, uncaughtExceptionHandler2);
        if (uncaughtExceptionHandler == null || !(uncaughtExceptionHandler instanceof ey)) {
            try {
                thread.setUncaughtExceptionHandler(ey2);
                return ey2;
            }
            catch (SecurityException securityException) {
                gs.c("Fail to set UncaughtExceptionHandler.", securityException);
            }
        } else {
            return (ey)uncaughtExceptionHandler;
        }
        return null;
    }

    private static boolean k(Context context) {
        Bundle bundle = gb.bD();
        if (bundle == null) {
            return false;
        }
        return bundle.getBoolean("gads:sdk_crash_report_enabled", false);
    }

    public ey(Context context, gt gt2, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Thread.UncaughtExceptionHandler uncaughtExceptionHandler2) {
        this.sR = uncaughtExceptionHandler;
        this.sS = uncaughtExceptionHandler2;
        this.mContext = context;
        this.sT = gt2;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        if (this.a(exception)) {
            this.b(exception);
            if (Looper.getMainLooper().getThread() != thread) {
                return;
            }
        }
        if (this.sR != null) {
            this.sR.uncaughtException(thread, exception);
        } else if (this.sS != null) {
            this.sS.uncaughtException(thread, exception);
        }
    }

    protected boolean a(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        while (throwable != null) {
            StackTraceElement[] stackTraceElementArray;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
                if (this.G(stackTraceElement.getClassName())) {
                    bl2 = true;
                }
                if (!this.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl3 = true;
            }
            throwable = throwable.getCause();
        }
        return bl2 && !bl3;
    }

    protected boolean G(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        if (string2.startsWith("com.google.android.gms.ads")) {
            return true;
        }
        if (string2.startsWith("com.google.ads")) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            return clazz.isAnnotationPresent(ez.class);
        }
        catch (Exception exception) {
            gs.a("Fail to check class type for class " + string2, exception);
            return false;
        }
    }

    protected boolean H(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.startsWith("android.") || string2.startsWith("java.");
    }

    public void b(Throwable throwable) {
        if (!ey.k(this.mContext)) {
            return;
        }
        Throwable throwable2 = this.d(throwable);
        if (throwable2 == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.c(throwable2));
        gj.a(this.mContext, this.sT.wD, arrayList, gb.de());
    }

    protected String c(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        Uri.Builder builder = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter("device", this.cw()).appendQueryParameter("js", this.sT.wD).appendQueryParameter("appid", this.mContext.getApplicationContext().getPackageName()).appendQueryParameter("stacktrace", stringWriter.toString());
        return builder.toString();
    }

    private Throwable d(Throwable throwable) {
        Throwable throwable2;
        Bundle bundle = gb.bD();
        if (bundle != null && bundle.getBoolean("gads:sdk_crash_report_full_stacktrace", false)) {
            return throwable;
        }
        LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            linkedList.push(throwable2);
        }
        Throwable throwable3 = null;
        while (!linkedList.isEmpty()) {
            throwable2 = (Throwable)linkedList.pop();
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            arrayList.add(new StackTraceElement(throwable2.getClass().getName(), "<filtered>", "<filtered>", 1));
            boolean bl2 = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (this.G(stackTraceElement.getClassName())) {
                    bl2 = true;
                    arrayList.add(stackTraceElement);
                    continue;
                }
                if (this.H(stackTraceElement.getClassName())) {
                    arrayList.add(stackTraceElement);
                    continue;
                }
                StackTraceElement stackTraceElement2 = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                arrayList.add(stackTraceElement2);
            }
            if (!bl2) continue;
            throwable3 = throwable3 == null ? new Throwable(throwable2.getMessage()) : new Throwable(throwable2.getMessage(), throwable3);
            throwable3.setStackTrace(arrayList.toArray(new StackTraceElement[0]));
        }
        return throwable3;
    }

    private String cw() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        if (string2.startsWith(string3)) {
            return string2;
        }
        return string3 + " " + string2;
    }
}

