/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntityCreator;
import com.google.android.gms.internal.jv;

public final class SnapshotMetadataEntity
implements SafeParcelable,
SnapshotMetadata {
    public static final SnapshotMetadataEntityCreator CREATOR = new SnapshotMetadataEntityCreator();
    private final int BR;
    private final GameEntity aay;
    private final PlayerEntity ado;
    private final String WI;
    private final Uri adk;
    private final String adp;
    private final String Nw;
    private final String Tr;
    private final long adq;
    private final long adr;
    private final float ads;
    private final String adt;

    public SnapshotMetadataEntity(SnapshotMetadata snapshotMetadata) {
        this.BR = 3;
        this.aay = new GameEntity(snapshotMetadata.getGame());
        this.ado = new PlayerEntity(snapshotMetadata.getOwner());
        this.WI = snapshotMetadata.getSnapshotId();
        this.adk = snapshotMetadata.getCoverImageUri();
        this.adp = snapshotMetadata.getCoverImageUrl();
        this.ads = snapshotMetadata.getCoverImageAspectRatio();
        this.Nw = snapshotMetadata.getTitle();
        this.Tr = snapshotMetadata.getDescription();
        this.adq = snapshotMetadata.getLastModifiedTimestamp();
        this.adr = snapshotMetadata.getPlayedTime();
        this.adt = snapshotMetadata.getUniqueName();
    }

    SnapshotMetadataEntity(int versionCode, GameEntity game, PlayerEntity owner, String snapshotId, Uri coverImageUri, String coverImageUrl, String title, String description, long lastModifiedTimestamp, long playedTime, float coverImageAspectRatio, String uniqueName) {
        this.BR = versionCode;
        this.aay = game;
        this.ado = owner;
        this.WI = snapshotId;
        this.adk = coverImageUri;
        this.adp = coverImageUrl;
        this.ads = coverImageAspectRatio;
        this.Nw = title;
        this.Tr = description;
        this.adq = lastModifiedTimestamp;
        this.adr = playedTime;
        this.adt = uniqueName;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public Game getGame() {
        return this.aay;
    }

    @Override
    public Player getOwner() {
        return this.ado;
    }

    @Override
    public String getSnapshotId() {
        return this.WI;
    }

    @Override
    public Uri getCoverImageUri() {
        return this.adk;
    }

    @Override
    public String getCoverImageUrl() {
        return this.adp;
    }

    @Override
    public float getCoverImageAspectRatio() {
        return this.ads;
    }

    @Override
    public String getUniqueName() {
        return this.adt;
    }

    @Override
    public String getTitle() {
        return this.Nw;
    }

    @Override
    public String getDescription() {
        return this.Tr;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        jv.b(this.Tr, dataOut);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.adq;
    }

    @Override
    public long getPlayedTime() {
        return this.adr;
    }

    @Override
    public SnapshotMetadata freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.a(this);
    }

    static int a(SnapshotMetadata snapshotMetadata) {
        return n.hashCode(snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.getTitle(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName());
    }

    public boolean equals(Object obj) {
        return SnapshotMetadataEntity.a(this, obj);
    }

    static boolean a(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        SnapshotMetadata snapshotMetadata2 = (SnapshotMetadata)object;
        return n.equal(snapshotMetadata2.getGame(), snapshotMetadata.getGame()) && n.equal(snapshotMetadata2.getOwner(), snapshotMetadata.getOwner()) && n.equal(snapshotMetadata2.getSnapshotId(), snapshotMetadata.getSnapshotId()) && n.equal(snapshotMetadata2.getCoverImageUri(), snapshotMetadata.getCoverImageUri()) && n.equal(Float.valueOf(snapshotMetadata2.getCoverImageAspectRatio()), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && n.equal(snapshotMetadata2.getTitle(), snapshotMetadata.getTitle()) && n.equal(snapshotMetadata2.getDescription(), snapshotMetadata.getDescription()) && n.equal(snapshotMetadata2.getLastModifiedTimestamp(), snapshotMetadata.getLastModifiedTimestamp()) && n.equal(snapshotMetadata2.getPlayedTime(), snapshotMetadata.getPlayedTime()) && n.equal(snapshotMetadata2.getUniqueName(), snapshotMetadata.getUniqueName());
    }

    public String toString() {
        return SnapshotMetadataEntity.b(this);
    }

    static String b(SnapshotMetadata snapshotMetadata) {
        return n.h(snapshotMetadata).a("Game", snapshotMetadata.getGame()).a("Owner", snapshotMetadata.getOwner()).a("SnapshotId", snapshotMetadata.getSnapshotId()).a("CoverImageUri", snapshotMetadata.getCoverImageUri()).a("CoverImageUrl", snapshotMetadata.getCoverImageUrl()).a("CoverImageAspectRatio", Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).a("Description", snapshotMetadata.getDescription()).a("LastModifiedTimestamp", snapshotMetadata.getLastModifiedTimestamp()).a("PlayedTime", snapshotMetadata.getPlayedTime()).a("UniqueName", snapshotMetadata.getUniqueName()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataEntityCreator.a(this, out, flags);
    }
}

