/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.snapshot.SnapshotContentsCreator;
import com.google.android.gms.internal.jy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public final class SnapshotContents
implements SafeParcelable {
    private static final Object adg = new Object();
    public static final SnapshotContentsCreator CREATOR = new SnapshotContentsCreator();
    private final int BR;
    private Contents Ox;

    public SnapshotContents(Contents contents) {
        this(1, contents);
    }

    SnapshotContents(int versionCode, Contents contents) {
        this.BR = versionCode;
        this.Ox = contents;
    }

    public int getVersionCode() {
        return this.BR;
    }

    public ParcelFileDescriptor getParcelFileDescriptor() {
        o.a(!this.isClosed(), "Cannot mutate closed contents!");
        return this.Ox.getParcelFileDescriptor();
    }

    public Contents getContents() {
        return this.Ox;
    }

    public void close() {
        this.Ox.hJ();
        this.Ox = null;
    }

    public boolean isClosed() {
        return this.Ox == null;
    }

    public byte[] readFully() throws IOException {
        o.a(!this.isClosed(), "Must provide a previously opened Snapshot");
        Object object = adg;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor = this.Ox.getParcelFileDescriptor();
            FileInputStream fileInputStream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            try {
                fileInputStream.getChannel().position(0L);
                byte[] byArray = jy.a(bufferedInputStream, false);
                fileInputStream.getChannel().position(0L);
                return byArray;
            }
            catch (IOException iOException) {
                GamesLog.b("SnapshotContents", "Failed to read snapshot data", iOException);
                throw iOException;
            }
        }
    }

    public boolean writeBytes(byte[] content) {
        return this.a(0, content, 0, content.length, true);
    }

    public boolean modifyBytes(int dstOffset, byte[] content, int srcOffset, int count) {
        return this.a(dstOffset, content, srcOffset, content.length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(int n2, byte[] byArray, int n3, int n4, boolean bl2) {
        o.a(!this.isClosed(), "Must provide a previously opened SnapshotContents");
        Object object = adg;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor = this.Ox.getParcelFileDescriptor();
            FileOutputStream fileOutputStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            try {
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.position(n2);
                ((OutputStream)bufferedOutputStream).write(byArray, n3, n4);
                if (bl2) {
                    fileChannel.truncate(byArray.length);
                }
                ((OutputStream)bufferedOutputStream).flush();
            }
            catch (IOException iOException) {
                GamesLog.a("SnapshotContents", "Failed to write snapshot data", iOException);
                return false;
            }
            return true;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotContentsCreator.a(this, out, flags);
    }
}

