/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
implements SafeParcelable,
GameRequest {
    public static final GameRequestEntityCreator CREATOR = new GameRequestEntityCreator();
    private final int BR;
    private final GameEntity aay;
    private final PlayerEntity adc;
    private final byte[] acH;
    private final String XC;
    private final ArrayList<PlayerEntity> add;
    private final int FD;
    private final long abZ;
    private final long ade;
    private final Bundle adf;
    private final int Fa;

    public GameRequestEntity(GameRequest request) {
        this.BR = 2;
        this.aay = new GameEntity(request.getGame());
        this.adc = new PlayerEntity(request.getSender());
        this.XC = request.getRequestId();
        this.FD = request.getType();
        this.abZ = request.getCreationTimestamp();
        this.ade = request.getExpirationTimestamp();
        this.Fa = request.getStatus();
        byte[] byArray = request.getData();
        if (byArray == null) {
            this.acH = null;
        } else {
            this.acH = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.acH, 0, byArray.length);
        }
        List<Player> list = request.getRecipients();
        int n2 = list.size();
        this.add = new ArrayList(n2);
        this.adf = new Bundle();
        for (int i2 = 0; i2 < n2; ++i2) {
            Player player = (Player)list.get(i2).freeze();
            String string2 = player.getPlayerId();
            this.add.add((PlayerEntity)player);
            this.adf.putInt(string2, request.getRecipientStatus(string2));
        }
    }

    GameRequestEntity(int versionCode, GameEntity game, PlayerEntity sender, byte[] data, String requestId, ArrayList<PlayerEntity> recipients, int type, long creationTimestamp, long expirationTimestamp, Bundle recipientStatuses, int status) {
        this.BR = versionCode;
        this.aay = game;
        this.adc = sender;
        this.acH = data;
        this.XC = requestId;
        this.add = recipients;
        this.FD = type;
        this.abZ = creationTimestamp;
        this.ade = expirationTimestamp;
        this.adf = recipientStatuses;
        this.Fa = status;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getRequestId() {
        return this.XC;
    }

    @Override
    public Game getGame() {
        return this.aay;
    }

    @Override
    public Player getSender() {
        return this.adc;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.add);
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.acH;
    }

    @Override
    public int getType() {
        return this.FD;
    }

    @Override
    public long getCreationTimestamp() {
        return this.abZ;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.ade;
    }

    @Override
    public int getRecipientStatus(String playerId) {
        return this.adf.getInt(playerId, 0);
    }

    @Override
    public int getStatus() {
        return this.Fa;
    }

    public Bundle lL() {
        return this.adf;
    }

    @Override
    public GameRequest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.a(this);
    }

    static int a(GameRequest gameRequest) {
        return n.hashCode(gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.b(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.a(this, obj);
    }

    static boolean a(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return n.equal(gameRequest2.getGame(), gameRequest.getGame()) && n.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && n.equal(gameRequest2.getRequestId(), gameRequest.getRequestId()) && n.equal(gameRequest2.getSender(), gameRequest.getSender()) && Arrays.equals(GameRequestEntity.b(gameRequest2), GameRequestEntity.b(gameRequest)) && n.equal(gameRequest2.getType(), gameRequest.getType()) && n.equal(gameRequest2.getCreationTimestamp(), gameRequest.getCreationTimestamp()) && n.equal(gameRequest2.getExpirationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    private static int[] b(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n2 = list.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = gameRequest.getRecipientStatus(list.get(i2).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.c(this);
    }

    static String c(GameRequest gameRequest) {
        return n.h(gameRequest).a("Game", gameRequest.getGame()).a("Sender", gameRequest.getSender()).a("Recipients", gameRequest.getRecipients()).a("Data", gameRequest.getData()).a("RequestId", gameRequest.getRequestId()).a("Type", gameRequest.getType()).a("CreationTimestamp", gameRequest.getCreationTimestamp()).a("ExpirationTimestamp", gameRequest.getExpirationTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntityCreator.a(this, dest, flags);
    }
}

