/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import com.google.android.gms.internal.jv;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
implements SafeParcelable,
Quest {
    public static final QuestEntityCreator CREATOR = new QuestEntityCreator();
    private final int BR;
    private final GameEntity aay;
    private final String acR;
    private final long acS;
    private final Uri acT;
    private final String acU;
    private final String Tr;
    private final long acV;
    private final long Wk;
    private final Uri acW;
    private final String acX;
    private final String mName;
    private final long acY;
    private final long acZ;
    private final int mState;
    private final int FD;
    private final ArrayList<MilestoneEntity> ada;

    public QuestEntity(Quest quest) {
        this.BR = 2;
        this.aay = new GameEntity(quest.getGame());
        this.acR = quest.getQuestId();
        this.acS = quest.getAcceptedTimestamp();
        this.Tr = quest.getDescription();
        this.acT = quest.getBannerImageUri();
        this.acU = quest.getBannerImageUrl();
        this.acV = quest.getEndTimestamp();
        this.acW = quest.getIconImageUri();
        this.acX = quest.getIconImageUrl();
        this.Wk = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.acY = quest.lK();
        this.acZ = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.FD = quest.getType();
        List<Milestone> list = quest.lJ();
        int n2 = list.size();
        this.ada = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.ada.add((MilestoneEntity)list.get(i2).freeze());
        }
    }

    QuestEntity(int versionCode, GameEntity game, String questId, long acceptedTimestamp, Uri bannerImageUri, String bannerImageUrl, String description, long endTimestamp, long lastUpdatedTimestamp, Uri iconImageUri, String iconImageUrl, String name, long notifyTimestamp, long startTimestamp, int state, int type, ArrayList<MilestoneEntity> milestones) {
        this.BR = versionCode;
        this.aay = game;
        this.acR = questId;
        this.acS = acceptedTimestamp;
        this.acT = bannerImageUri;
        this.acU = bannerImageUrl;
        this.Tr = description;
        this.acV = endTimestamp;
        this.Wk = lastUpdatedTimestamp;
        this.acW = iconImageUri;
        this.acX = iconImageUrl;
        this.mName = name;
        this.acY = notifyTimestamp;
        this.acZ = startTimestamp;
        this.mState = state;
        this.FD = type;
        this.ada = milestones;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getQuestId() {
        return this.acR;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        jv.b(this.mName, dataOut);
    }

    @Override
    public String getDescription() {
        return this.Tr;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        jv.b(this.Tr, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.acW;
    }

    @Override
    public String getIconImageUrl() {
        return this.acX;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.acT;
    }

    @Override
    public String getBannerImageUrl() {
        return this.acU;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.lJ().get(0);
    }

    @Override
    public List<Milestone> lJ() {
        return new ArrayList<Milestone>(this.ada);
    }

    @Override
    public Game getGame() {
        return this.aay;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.FD;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.acS;
    }

    @Override
    public long getEndTimestamp() {
        return this.acV;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Wk;
    }

    @Override
    public long lK() {
        return this.acY;
    }

    @Override
    public long getStartTimestamp() {
        return this.acZ;
    }

    @Override
    public boolean isEndingSoon() {
        return this.acY <= System.currentTimeMillis() + 1800000L;
    }

    @Override
    public Quest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.a(this);
    }

    static int a(Quest quest) {
        return n.hashCode(quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.lJ(), quest.getName(), quest.lK(), quest.getStartTimestamp(), quest.getState());
    }

    public boolean equals(Object obj) {
        return QuestEntity.a(this, obj);
    }

    static boolean a(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return n.equal(quest2.getGame(), quest.getGame()) && n.equal(quest2.getQuestId(), quest.getQuestId()) && n.equal(quest2.getAcceptedTimestamp(), quest.getAcceptedTimestamp()) && n.equal(quest2.getBannerImageUri(), quest.getBannerImageUri()) && n.equal(quest2.getDescription(), quest.getDescription()) && n.equal(quest2.getEndTimestamp(), quest.getEndTimestamp()) && n.equal(quest2.getIconImageUri(), quest.getIconImageUri()) && n.equal(quest2.getLastUpdatedTimestamp(), quest.getLastUpdatedTimestamp()) && n.equal(quest2.lJ(), quest.lJ()) && n.equal(quest2.getName(), quest.getName()) && n.equal(quest2.lK(), quest.lK()) && n.equal(quest2.getStartTimestamp(), quest.getStartTimestamp()) && n.equal(quest2.getState(), quest.getState());
    }

    public String toString() {
        return QuestEntity.b(this);
    }

    static String b(Quest quest) {
        return n.h(quest).a("Game", quest.getGame()).a("QuestId", quest.getQuestId()).a("AcceptedTimestamp", quest.getAcceptedTimestamp()).a("BannerImageUri", quest.getBannerImageUri()).a("BannerImageUrl", quest.getBannerImageUrl()).a("Description", quest.getDescription()).a("EndTimestamp", quest.getEndTimestamp()).a("IconImageUri", quest.getIconImageUri()).a("IconImageUrl", quest.getIconImageUrl()).a("LastUpdatedTimestamp", quest.getLastUpdatedTimestamp()).a("Milestones", quest.lJ()).a("Name", quest.getName()).a("NotifyTimestamp", quest.lK()).a("StartTimestamp", quest.getStartTimestamp()).a("State", quest.getState()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        QuestEntityCreator.a(this, out, flags);
    }
}

