/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer acz;
    private final TurnBasedMatchBuffer acA;
    private final TurnBasedMatchBuffer acB;
    private final TurnBasedMatchBuffer acC;

    public LoadMatchesResponse(Bundle matchData) {
        DataHolder dataHolder = LoadMatchesResponse.a(matchData, 0);
        this.acz = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.a(matchData, 1);
        this.acA = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.a(matchData, 2);
        this.acB = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.a(matchData, 3);
        this.acC = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder a(Bundle bundle, int n2) {
        String string2 = TurnBasedMatchTurnStatus.dH(n2);
        if (!bundle.containsKey(string2)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string2);
    }

    public InvitationBuffer getInvitations() {
        return this.acz;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.acA;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.acB;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.acC;
    }

    public void close() {
        if (this.acz != null) {
            this.acz.close();
        }
        if (this.acA != null) {
            this.acA.close();
        }
        if (this.acB != null) {
            this.acB.close();
        }
        if (this.acC != null) {
            this.acC.close();
        }
    }

    public boolean hasData() {
        if (this.acz != null && this.acz.getCount() > 0) {
            return true;
        }
        if (this.acA != null && this.acA.getCount() > 0) {
            return true;
        }
        if (this.acB != null && this.acB.getCount() > 0) {
            return true;
        }
        return this.acC != null && this.acC.getCount() > 0;
    }
}

