/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomEntityCreator;
import com.google.android.gms.internal.jv;
import java.util.ArrayList;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new RoomEntityCreatorCompat();
    private final int BR;
    private final String WQ;
    private final String acw;
    private final long abZ;
    private final int acx;
    private final String Tr;
    private final int acd;
    private final Bundle acs;
    private final ArrayList<ParticipantEntity> acc;
    private final int acy;

    public RoomEntity(Room room) {
        this.BR = 2;
        this.WQ = room.getRoomId();
        this.acw = room.getCreatorId();
        this.abZ = room.getCreationTimestamp();
        this.acx = room.getStatus();
        this.Tr = room.getDescription();
        this.acd = room.getVariant();
        this.acs = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        this.acc = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.acc.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
        this.acy = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants, int autoMatchWaitEstimateSeconds) {
        this.BR = versionCode;
        this.WQ = roomId;
        this.acw = creatorId;
        this.abZ = creationTimestamp;
        this.acx = roomStatus;
        this.Tr = description;
        this.acd = variant;
        this.acs = autoMatchCriteria;
        this.acc = participants;
        this.acy = autoMatchWaitEstimateSeconds;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getRoomId() {
        return this.WQ;
    }

    @Override
    public String getCreatorId() {
        return this.acw;
    }

    @Override
    public long getCreationTimestamp() {
        return this.abZ;
    }

    @Override
    public int getStatus() {
        return this.acx;
    }

    @Override
    public String getDescription() {
        return this.Tr;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        jv.b(this.Tr, dataOut);
    }

    @Override
    public int getVariant() {
        return this.acd;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.acs;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.acc);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.acy;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return RoomEntity.a((Room)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return RoomEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return RoomEntity.c(this, participantId);
    }

    @Override
    public Room freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.a(this);
    }

    static int a(Room room) {
        return n.hashCode(room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds());
    }

    public boolean equals(Object obj) {
        return RoomEntity.a((Room)this, obj);
    }

    static boolean a(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return n.equal(room2.getRoomId(), room.getRoomId()) && n.equal(room2.getCreatorId(), room.getCreatorId()) && n.equal(room2.getCreationTimestamp(), room.getCreationTimestamp()) && n.equal(room2.getStatus(), room.getStatus()) && n.equal(room2.getDescription(), room.getDescription()) && n.equal(room2.getVariant(), room.getVariant()) && n.equal(room2.getAutoMatchCriteria(), room.getAutoMatchCriteria()) && n.equal(room2.getParticipants(), room.getParticipants()) && n.equal(room2.getAutoMatchWaitEstimateSeconds(), room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.b(this);
    }

    static String b(Room room) {
        return n.h(room).a("RoomId", room.getRoomId()).a("CreatorId", room.getCreatorId()).a("CreationTimestamp", room.getCreationTimestamp()).a("RoomStatus", room.getStatus()).a("Description", room.getDescription()).a("Variant", room.getVariant()).a("AutoMatchCriteria", room.getAutoMatchCriteria()).a("Participants", room.getParticipants()).a("AutoMatchWaitEstimateSeconds", room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.gQ()) {
            RoomEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.WQ);
            dest.writeString(this.acw);
            dest.writeLong(this.abZ);
            dest.writeInt(this.acx);
            dest.writeString(this.Tr);
            dest.writeInt(this.acd);
            dest.writeBundle(this.acs);
            int n2 = this.acc.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.acc.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static int a(Room room, String string2) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string2 + " is not in room " + room.getRoomId());
    }

    static ArrayList<String> c(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(Room room, String string2) {
        String string3 = null;
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string2)) continue;
            string3 = participant.getParticipantId();
            break;
        }
        return string3;
    }

    static Participant c(Room room, String string2) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + room.getRoomId());
    }

    static final class RoomEntityCreatorCompat
    extends RoomEntityCreator {
        RoomEntityCreatorCompat() {
        }

        @Override
        public RoomEntity co(Parcel parcel) {
            int n2;
            boolean bl2 = RoomEntity.c(RoomEntity.gP());
            if (bl2 || RoomEntity.aV(RoomEntity.class.getCanonicalName())) {
                return super.co(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            String string4 = parcel.readString();
            int n4 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n5 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n5);
            for (n2 = 0; n2 < n5; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            return new RoomEntity(2, string2, string3, l2, n3, string4, n4, bundle, arrayList, n2);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.co(x0);
        }
    }
}

