/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomConfig {
    private final RoomUpdateListener aco;
    private final RoomStatusUpdateListener acp;
    private final RealTimeMessageReceivedListener acq;
    private final String WO;
    private final int acd;
    private final String[] acr;
    private final Bundle acs;
    private final boolean act;

    private RoomConfig(Builder builder) {
        this.aco = builder.aco;
        this.acp = builder.acp;
        this.acq = builder.acq;
        this.WO = builder.acu;
        this.acd = builder.acd;
        this.acs = builder.acs;
        this.act = builder.act;
        int n2 = builder.acv.size();
        this.acr = builder.acv.toArray(new String[n2]);
        if (this.acq == null) {
            o.a(this.act, "Must either enable sockets OR specify a message listener");
        }
    }

    public RoomUpdateListener getRoomUpdateListener() {
        return this.aco;
    }

    public String getInvitationId() {
        return this.WO;
    }

    public RoomStatusUpdateListener getRoomStatusUpdateListener() {
        return this.acp;
    }

    public RealTimeMessageReceivedListener getMessageReceivedListener() {
        return this.acq;
    }

    public int getVariant() {
        return this.acd;
    }

    public String[] getInvitedPlayerIds() {
        return this.acr;
    }

    public Bundle getAutoMatchCriteria() {
        return this.acs;
    }

    public boolean isSocketEnabled() {
        return this.act;
    }

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        final RoomUpdateListener aco;
        RoomStatusUpdateListener acp;
        RealTimeMessageReceivedListener acq;
        String acu = null;
        int acd = -1;
        ArrayList<String> acv = new ArrayList();
        Bundle acs;
        boolean act = false;

        private Builder(RoomUpdateListener updateListener) {
            this.aco = o.b(updateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            o.i(invitationId);
            this.acu = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.acp = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.acq = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            o.i(playerIds);
            this.acv.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            o.i(playerIds);
            this.acv.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            o.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.acd = variant;
            return this;
        }

        public Builder setSocketCommunicationEnabled(boolean enableSockets) {
            this.act = enableSockets;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.acs = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfig(this);
        }
    }
}

