/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.internal.jv;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int BR;
    private final String Xr;
    private final String NH;
    private final Uri Vh;
    private final Uri Vi;
    private final int Fa;
    private final String Wq;
    private final boolean acg;
    private final PlayerEntity Wh;
    private final int EZ;
    private final ParticipantResult ach;
    private final String Vs;
    private final String Vt;

    public ParticipantEntity(Participant participant) {
        this.BR = 3;
        this.Xr = participant.getParticipantId();
        this.NH = participant.getDisplayName();
        this.Vh = participant.getIconImageUri();
        this.Vi = participant.getHiResImageUri();
        this.Fa = participant.getStatus();
        this.Wq = participant.jX();
        this.acg = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.Wh = player == null ? null : new PlayerEntity(player);
        this.EZ = participant.getCapabilities();
        this.ach = participant.getResult();
        this.Vs = participant.getIconImageUrl();
        this.Vt = participant.getHiResImageUrl();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result, String iconImageUrl, String hiResImageUrl) {
        this.BR = versionCode;
        this.Xr = participantId;
        this.NH = displayName;
        this.Vh = iconImageUri;
        this.Vi = hiResImageUri;
        this.Fa = status;
        this.Wq = clientAddress;
        this.acg = connectedToRoom;
        this.Wh = player;
        this.EZ = capabilities;
        this.ach = result;
        this.Vs = iconImageUrl;
        this.Vt = hiResImageUrl;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public int getStatus() {
        return this.Fa;
    }

    @Override
    public String jX() {
        return this.Wq;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.acg;
    }

    @Override
    public String getDisplayName() {
        if (this.Wh == null) {
            return this.NH;
        }
        return this.Wh.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.Wh == null) {
            jv.b(this.NH, dataOut);
            return;
        }
        this.Wh.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.Wh == null) {
            return this.Vh;
        }
        return this.Wh.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.Wh == null) {
            return this.Vs;
        }
        return this.Wh.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.Wh == null) {
            return this.Vi;
        }
        return this.Wh.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.Wh == null) {
            return this.Vt;
        }
        return this.Wh.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.Xr;
    }

    @Override
    public Player getPlayer() {
        return this.Wh;
    }

    @Override
    public ParticipantResult getResult() {
        return this.ach;
    }

    @Override
    public int getCapabilities() {
        return this.EZ;
    }

    @Override
    public Participant freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    static int a(Participant participant) {
        return n.hashCode(participant.getPlayer(), participant.getStatus(), participant.jX(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    static boolean a(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return n.equal(participant2.getPlayer(), participant.getPlayer()) && n.equal(participant2.getStatus(), participant.getStatus()) && n.equal(participant2.jX(), participant.jX()) && n.equal(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && n.equal(participant2.getDisplayName(), participant.getDisplayName()) && n.equal(participant2.getIconImageUri(), participant.getIconImageUri()) && n.equal(participant2.getHiResImageUri(), participant.getHiResImageUri()) && n.equal(participant2.getCapabilities(), participant.getCapabilities()) && n.equal(participant2.getResult(), participant.getResult()) && n.equal(participant2.getParticipantId(), participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    static String b(Participant participant) {
        return n.h(participant).a("ParticipantId", participant.getParticipantId()).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.jX()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("IconImageUrl", participant.getIconImageUrl()).a("HiResImage", participant.getHiResImageUri()).a("HiResImageUrl", participant.getHiResImageUrl()).a("Capabilities", participant.getCapabilities()).a("Result", participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.gQ()) {
            ParticipantEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.Xr);
            dest.writeString(this.NH);
            dest.writeString(this.Vh == null ? null : this.Vh.toString());
            dest.writeString(this.Vi == null ? null : this.Vi.toString());
            dest.writeInt(this.Fa);
            dest.writeString(this.Wq);
            dest.writeInt(this.acg ? 1 : 0);
            dest.writeInt(this.Wh == null ? 0 : 1);
            if (this.Wh != null) {
                this.Wh.writeToParcel(dest, flags);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity cm(Parcel parcel) {
            boolean bl2 = ParticipantEntity.c(ParticipantEntity.gP());
            if (bl2 || ParticipantEntity.aV(ParticipantEntity.class.getCanonicalName())) {
                return super.cm(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            String string5 = parcel.readString();
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            int n2 = parcel.readInt();
            String string6 = parcel.readString();
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            int n3 = 7;
            ParticipantResult participantResult = null;
            String string7 = null;
            String string8 = null;
            PlayerEntity playerEntity = bl4 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string2, string3, uri, uri2, n2, string6, bl3, playerEntity, n3, participantResult, string7, string8);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cm(x0);
        }
    }
}

