/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntityCreator;

public final class GameBadgeEntity
extends GamesDowngradeableSafeParcel
implements GameBadge {
    public static final GameBadgeEntityCreator CREATOR = new GameBadgeEntityCreatorCompat();
    private final int BR;
    private int FD;
    private String Nw;
    private String Tr;
    private Uri Vh;

    public GameBadgeEntity(GameBadge gameBadge) {
        this.BR = 1;
        this.FD = gameBadge.getType();
        this.Nw = gameBadge.getTitle();
        this.Tr = gameBadge.getDescription();
        this.Vh = gameBadge.getIconImageUri();
    }

    GameBadgeEntity(int versionCode, int type, String title, String description, Uri iconImageUri) {
        this.BR = versionCode;
        this.FD = type;
        this.Nw = title;
        this.Tr = description;
        this.Vh = iconImageUri;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public int getType() {
        return this.FD;
    }

    @Override
    public String getTitle() {
        return this.Nw;
    }

    @Override
    public String getDescription() {
        return this.Tr;
    }

    @Override
    public Uri getIconImageUri() {
        return this.Vh;
    }

    public GameBadge ld() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameBadgeEntity.a(this);
    }

    static int a(GameBadge gameBadge) {
        return n.hashCode(gameBadge.getType(), gameBadge.getTitle(), gameBadge.getDescription(), gameBadge.getIconImageUri());
    }

    public boolean equals(Object obj) {
        return GameBadgeEntity.a(this, obj);
    }

    static boolean a(GameBadge gameBadge, Object object) {
        if (!(object instanceof GameBadge)) {
            return false;
        }
        if (gameBadge == object) {
            return true;
        }
        GameBadge gameBadge2 = (GameBadge)object;
        return n.equal(gameBadge2.getType(), gameBadge.getTitle()) && n.equal(gameBadge2.getDescription(), gameBadge.getIconImageUri());
    }

    public String toString() {
        return GameBadgeEntity.b(this);
    }

    static String b(GameBadge gameBadge) {
        return n.h(gameBadge).a("Type", gameBadge.getType()).a("Title", gameBadge.getTitle()).a("Description", gameBadge.getDescription()).a("IconImageUri", gameBadge.getIconImageUri()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.gQ()) {
            GameBadgeEntityCreator.a(this, dest, flags);
        } else {
            dest.writeInt(this.FD);
            dest.writeString(this.Nw);
            dest.writeString(this.Tr);
            dest.writeString(this.Vh == null ? null : this.Vh.toString());
        }
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.ld();
    }

    static final class GameBadgeEntityCreatorCompat
    extends GameBadgeEntityCreator {
        GameBadgeEntityCreatorCompat() {
        }

        @Override
        public GameBadgeEntity ch(Parcel parcel) {
            boolean bl2 = GameBadgeEntity.c(GameBadgeEntity.gP());
            if (bl2 || GameBadgeEntity.aV(GameBadgeEntity.class.getCanonicalName())) {
                return super.ch(parcel);
            }
            int n2 = parcel.readInt();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            return new GameBadgeEntity(1, n2, string2, string3, uri);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.ch(x0);
        }
    }
}

