/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;

public final class QuestsImpl
implements Quests {
    @Override
    public Intent getQuestsIntent(GoogleApiClient apiClient, int[] questSelectors) {
        return Games.c(apiClient).b(questSelectors);
    }

    @Override
    public Intent getQuestIntent(GoogleApiClient apiClient, String questId) {
        return Games.c(apiClient).bC(questId);
    }

    @Override
    public void registerQuestUpdateListener(GoogleApiClient apiClient, QuestUpdateListener listener) {
        Games.c(apiClient).a(listener);
    }

    @Override
    public void unregisterQuestUpdateListener(GoogleApiClient apiClient) {
        Games.c(apiClient).kk();
    }

    @Override
    public PendingResult<Quests.AcceptQuestResult> accept(GoogleApiClient apiClient, final String questId) {
        return apiClient.b(new AcceptImpl(){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.i(this, questId);
            }
        });
    }

    @Override
    public PendingResult<Quests.ClaimMilestoneResult> claim(GoogleApiClient apiClient, final String questId, final String milestoneId) {
        return apiClient.b(new ClaimImpl(){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.b(this, questId, milestoneId);
            }
        });
    }

    @Override
    public PendingResult<Quests.LoadQuestsResult> load(GoogleApiClient apiClient, final int[] questSelectors, final int sortOrder, final boolean forceReload) {
        return apiClient.a(new LoadsImpl(){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a(this, questSelectors, sortOrder, forceReload);
            }
        });
    }

    @Override
    public PendingResult<Quests.LoadQuestsResult> loadByIds(GoogleApiClient apiClient, final boolean forceReload, final String ... questIds) {
        return apiClient.a(new LoadsImpl(){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.b(this, forceReload, questIds);
            }
        });
    }

    @Override
    public void showStateChangedPopup(GoogleApiClient apiClient, String questId) {
        Games.c(apiClient).bD(questId);
    }

    private static abstract class LoadsImpl
    extends Games.BaseGamesApiMethodImpl<Quests.LoadQuestsResult> {
        private LoadsImpl() {
        }

        public Quests.LoadQuestsResult aj(final Status status) {
            return new Quests.LoadQuestsResult(){

                @Override
                public void release() {
                }

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public QuestBuffer getQuests() {
                    int n2 = status.getStatusCode();
                    return new QuestBuffer(DataHolder.as(n2));
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.aj(status);
        }
    }

    private static abstract class ClaimImpl
    extends Games.BaseGamesApiMethodImpl<Quests.ClaimMilestoneResult> {
        private ClaimImpl() {
        }

        public Quests.ClaimMilestoneResult ai(final Status status) {
            return new Quests.ClaimMilestoneResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public Milestone getMilestone() {
                    return null;
                }

                @Override
                public Quest getQuest() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.ai(status);
        }
    }

    private static abstract class AcceptImpl
    extends Games.BaseGamesApiMethodImpl<Quests.AcceptQuestResult> {
        private AcceptImpl() {
        }

        public Quests.AcceptQuestResult ah(final Status status) {
            return new Quests.AcceptQuestResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public Quest getQuest() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.ah(status);
        }
    }
}

