/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.a;
import com.google.android.gms.common.internal.e;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.LibjingleNativeSocket;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.RealTimeSocketImpl;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.internal.game.ExtendedGameBuffer;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.ParticipantUtils;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.internal.kc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GamesClientImpl
extends e<IGamesService>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    EventIncrementManager Ws = new EventIncrementManager(){

        @Override
        public EventIncrementCache ky() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String Wt;
    private final String Dd;
    private final Map<String, RealTimeSocket> Wu;
    private PlayerEntity Wv;
    private GameEntity Ww;
    private final PopupManager Wx;
    private boolean Wy = false;
    private final Binder Wz;
    private final long WA;
    private final Games.GamesOptions WB;

    public GamesClientImpl(Context context, Looper looper, String gamePackageName, String accountName, GoogleApiClient.ConnectionCallbacks connectedListener, GoogleApiClient.OnConnectionFailedListener connectionFailedListener, String[] scopes, int gravity, View gamesContentView, Games.GamesOptions options) {
        super(context, looper, connectedListener, connectionFailedListener, scopes);
        this.Wt = gamePackageName;
        this.Dd = o.i(accountName);
        this.Wz = new Binder();
        this.Wu = new HashMap<String, RealTimeSocket>();
        this.Wx = PopupManager.a(this, gravity);
        this.k(gamesContentView);
        this.WA = this.hashCode();
        this.WB = options;
        this.registerConnectionCallbacks(this);
        this.registerConnectionFailedListener(this);
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (this.Wy) {
            this.Wx.kM();
            this.Wy = false;
        }
    }

    @Override
    public void onConnectionSuspended(int cause) {
    }

    @Override
    public void onConnectionFailed(ConnectionResult result) {
        this.Wy = false;
    }

    public void dB(int n2) {
        this.Wx.setGravity(n2);
    }

    public void k(View view) {
        this.Wx.l(view);
    }

    @Override
    protected void c(String ... stringArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (string2.equals("https://www.googleapis.com/auth/games")) {
                bl2 = true;
                continue;
            }
            if (!string2.equals("https://www.googleapis.com/auth/games.firstparty")) continue;
            bl3 = true;
        }
        if (bl3) {
            o.a(!bl2, "Cannot have both %s and %s!", "https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty");
        } else {
            o.a(bl2, "Games APIs requires %s to function.", "https://www.googleapis.com/auth/games");
        }
    }

    @Override
    public void connect() {
        this.jZ();
        super.connect();
    }

    @Override
    public void disconnect() {
        this.Wy = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.gS();
                iGamesService.kx();
                this.Ws.flush();
                iGamesService.q(this.WA);
            }
            catch (RemoteException remoteException) {
                GamesLog.p("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        this.kw();
        super.disconnect();
    }

    @Override
    protected String getStartServiceAction() {
        return "com.google.android.gms.games.service.START";
    }

    @Override
    protected String getServiceDescriptor() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService az(IBinder iBinder) {
        return IGamesService.Stub.aB(iBinder);
    }

    @Override
    public Bundle fC() {
        try {
            Bundle bundle = ((IGamesService)this.gS()).fC();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            return null;
        }
    }

    private void jZ() {
        this.Wv = null;
    }

    @Override
    protected void a(l l2, e.e e2) throws RemoteException {
        String string2 = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.WB.VD);
        bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.WB.VE);
        bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.WB.VF);
        bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.WB.VG);
        bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.WB.VH);
        bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", this.WB.VI);
        bundle.putStringArrayList("com.google.android.gms.games.key.proxyApis", this.WB.VJ);
        l2.a(e2, 6171000, this.getContext().getPackageName(), this.Dd, this.gR(), this.Wt, this.Wx.kO(), string2, bundle);
    }

    public String ka() {
        try {
            return ((IGamesService)this.gS()).ka();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            return null;
        }
    }

    public String kb() {
        try {
            return ((IGamesService)this.gS()).kb();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player kc() {
        this.dJ();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.Wv == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.gS()).kz());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.Wv = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesLog.p("GamesClientImpl", "service died");
                }
            }
        }
        return this.Wv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game kd() {
        this.dJ();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.Ww == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.gS()).kB());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.Ww = (GameEntity)gameBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesLog.p("GamesClientImpl", "service died");
                }
            }
        }
        return this.Ww;
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, String string2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, String[] stringArray) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, String string2, int n2, boolean bl2, boolean bl3) {
        switch (string2) {
            case "played_with": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string2);
            }
        }
        try {
            ((IGamesService)this.gS()).d(new PlayersLoadedBinderCallback(b2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, String string2, String string3, int n2, boolean bl2, boolean bl3) {
        switch (string2) {
            case "circled": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string2);
            }
        }
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), string2, string3, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public Intent ke() {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).ke();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent bx(String string2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).bx(string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void b(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> b2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(b2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LoadPlayerScoreResult> b2, String string2, String string3, int n2, int n3) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(b2), string2, string3, n2, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, String string2, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(b2), string2, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, String string2, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(b2), string2, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n2, int n3) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(b2), leaderboardScoreBuffer.lA().lB(), n2, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.SubmitScoreResult> b2, String string2, long l2, String string3) {
        try {
            SubmitScoreBinderCallbacks submitScoreBinderCallbacks = b2 == null ? null : new SubmitScoreBinderCallbacks(b2);
            ((IGamesService)this.gS()).a((IGamesCallbacks)submitScoreBinderCallbacks, string2, l2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public Intent kf() {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).kf();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void c(BaseImplementation.b<Achievements.LoadAchievementsResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new AchievementsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Achievements.UpdateAchievementResult> b2, String string2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = b2 == null ? null : new AchievementUpdatedBinderCallback(b2);
            ((IGamesService)this.gS()).a((IGamesCallbacks)achievementUpdatedBinderCallback, string2, this.Wx.kO(), this.Wx.kN());
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Achievements.UpdateAchievementResult> b2, String string2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = b2 == null ? null : new AchievementUpdatedBinderCallback(b2);
            ((IGamesService)this.gS()).b((IGamesCallbacks)achievementUpdatedBinderCallback, string2, this.Wx.kO(), this.Wx.kN());
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Achievements.UpdateAchievementResult> b2, String string2, int n2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = b2 == null ? null : new AchievementUpdatedBinderCallback(b2);
            ((IGamesService)this.gS()).a((IGamesCallbacks)achievementUpdatedBinderCallback, string2, n2, this.Wx.kO(), this.Wx.kN());
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Achievements.UpdateAchievementResult> b2, String string2, int n2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = b2 == null ? null : new AchievementUpdatedBinderCallback(b2);
            ((IGamesService)this.gS()).b((IGamesCallbacks)achievementUpdatedBinderCallback, string2, n2, this.Wx.kO(), this.Wx.kN());
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<Events.LoadEventsResult> b2, boolean bl2) {
        try {
            this.Ws.flush();
            ((IGamesService)this.gS()).f((IGamesCallbacks)new EventsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Events.LoadEventsResult> b2, boolean bl2, String ... stringArray) {
        try {
            this.Ws.flush();
            ((IGamesService)this.gS()).a((IGamesCallbacks)new EventsLoadedBinderCallback(b2), bl2, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void n(String string2, int n2) {
        this.Ws.n(string2, n2);
    }

    public Intent kg() {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).kg();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent kh() {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).kh();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(OnInvitationReceivedListener onInvitationReceivedListener) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(onInvitationReceivedListener);
            ((IGamesService)this.gS()).a((IGamesCallbacks)invitationReceivedBinderCallback, this.WA);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void ki() {
        try {
            ((IGamesService)this.gS()).r(this.WA);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(onTurnBasedMatchUpdateReceivedListener);
            ((IGamesService)this.gS()).b((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.WA);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void kj() {
        try {
            ((IGamesService)this.gS()).s(this.WA);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(QuestUpdateListener questUpdateListener) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(questUpdateListener);
            ((IGamesService)this.gS()).d((IGamesCallbacks)questUpdateBinderCallback, this.WA);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void kk() {
        try {
            ((IGamesService)this.gS()).u(this.WA);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(OnRequestReceivedListener onRequestReceivedListener) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(onRequestReceivedListener);
            ((IGamesService)this.gS()).c((IGamesCallbacks)requestReceivedBinderCallback, this.WA);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void kl() {
        try {
            ((IGamesService)this.gS()).t(this.WA);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public Intent km() {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).km();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent a(Room room, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).a((RoomEntity)room.freeze(), n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent kn() {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).kn();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void f(BaseImplementation.b<GamesMetadata.LoadGamesResult> b2) {
        try {
            ((IGamesService)this.gS()).d(new GamesLoadedBinderCallback(b2));
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Status> b2) {
        try {
            this.Ws.flush();
            ((IGamesService)this.gS()).a(new SignOutCompleteBinderCallbacks(b2));
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public int ko() {
        int n2 = 4368;
        try {
            n2 = ((IGamesService)this.gS()).ko();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
        return n2;
    }

    public String kp() {
        try {
            return ((IGamesService)this.gS()).kp();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            return null;
        }
    }

    public void c(BaseImplementation.b<Invitations.LoadInvitationsResult> b2, int n2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new InvitationsLoadedBinderCallback(b2), n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void o(String string2, int n2) {
        try {
            ((IGamesService)this.gS()).o(string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void p(String string2, int n2) {
        try {
            ((IGamesService)this.gS()).p(string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public Intent a(int n2, int n3, boolean bl2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).a(n2, n3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, TurnBasedMatchConfig turnBasedMatchConfig) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(b2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.lH(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, String string2) {
        try {
            ((IGamesService)this.gS()).l(new TurnBasedMatchInitiatedBinderCallbacks(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void e(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, String string2) {
        try {
            ((IGamesService)this.gS()).m(new TurnBasedMatchInitiatedBinderCallbacks(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public int kq() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.gS()).kq();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.UpdateMatchResult> b2, String string2, byte[] byArray, String string3, ParticipantResult[] participantResultArray) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(b2), string2, byArray, string3, participantResultArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.UpdateMatchResult> b2, String string2, byte[] byArray, ParticipantResult[] participantResultArray) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(b2), string2, byArray, participantResultArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void f(BaseImplementation.b<TurnBasedMultiplayer.LeaveMatchResult> b2, String string2) {
        try {
            ((IGamesService)this.gS()).o(new TurnBasedMatchLeftBinderCallbacks(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.LeaveMatchResult> b2, String string2, String string3) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(b2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void g(BaseImplementation.b<TurnBasedMultiplayer.CancelMatchResult> b2, String string2) {
        try {
            ((IGamesService)this.gS()).n(new TurnBasedMatchCanceledBinderCallbacks(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void by(String string2) {
        try {
            ((IGamesService)this.gS()).bJ(string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchesResult> b2, int n2, int[] nArray) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(b2), n2, nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void h(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchResult> b2, String string2) {
        try {
            ((IGamesService)this.gS()).p(new TurnBasedMatchLoadedBinderCallbacks(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public Intent b(int n2, int n3, boolean bl2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).b(n2, n3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(RoomConfig roomConfig) {
        this.kw();
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(roomConfig.getRoomUpdateListener(), roomConfig.getRoomStatusUpdateListener(), roomConfig.getMessageReceivedListener());
            ((IGamesService)this.gS()).a((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.Wz, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), roomConfig.isSocketEnabled(), this.WA);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(RoomConfig roomConfig) {
        this.kw();
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(roomConfig.getRoomUpdateListener(), roomConfig.getRoomStatusUpdateListener(), roomConfig.getMessageReceivedListener());
            ((IGamesService)this.gS()).a((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.Wz, roomConfig.getInvitationId(), roomConfig.isSocketEnabled(), this.WA);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(RoomUpdateListener roomUpdateListener, String string2) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new RoomBinderCallbacks(roomUpdateListener), string2);
            this.kw();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public int a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback, byte[] byArray, String string2, String string3) {
        try {
            return ((IGamesService)this.gS()).a((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(reliableMessageSentCallback), byArray, string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int a(byte[] byArray, String string2, String[] stringArray) {
        o.b(stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.gS()).b(byArray, string2, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int d(byte[] byArray, String string2) {
        try {
            return ((IGamesService)this.gS()).b(byArray, string2, null);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            return -1;
        }
    }

    public RealTimeSocket t(String string2, String string3) {
        if (string3 == null || !ParticipantUtils.bV(string3)) {
            throw new IllegalArgumentException("Bad participant ID");
        }
        RealTimeSocket realTimeSocket = this.Wu.get(string3);
        if (realTimeSocket == null || realTimeSocket.isClosed()) {
            return this.bz(string3);
        }
        return realTimeSocket;
    }

    private RealTimeSocket bz(String string2) {
        RealTimeSocket realTimeSocket = kc.hD() ? this.bB(string2) : this.bA(string2);
        if (realTimeSocket != null) {
            this.Wu.put(string2, realTimeSocket);
        }
        return realTimeSocket;
    }

    private RealTimeSocket bA(String string2) {
        try {
            String string3 = ((IGamesService)this.gS()).bF(string2);
            if (string3 == null) {
                return null;
            }
            LocalSocket localSocket = new LocalSocket();
            localSocket.connect(new LocalSocketAddress(string3));
            return new RealTimeSocketImpl(localSocket, string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.q("GamesClientImpl", "Unable to create socket. Service died.");
        }
        catch (IOException iOException) {
            GamesLog.q("GamesClientImpl", "connect() call failed on socket: " + iOException.getMessage());
        }
        return null;
    }

    private RealTimeSocket bB(String string2) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = ((IGamesService)this.gS()).bK(string2);
            if (parcelFileDescriptor != null) {
                GamesLog.o("GamesClientImpl", "Created native libjingle socket.");
                return new LibjingleNativeSocket(parcelFileDescriptor);
            }
            GamesLog.q("GamesClientImpl", "Unable to create socket for " + string2);
            return null;
        }
        catch (RemoteException remoteException) {
            GamesLog.q("GamesClientImpl", "Unable to create socket. Service died.");
            return null;
        }
    }

    public void dC(int n2) {
        try {
            ((IGamesService)this.gS()).dC(n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public Intent kr() {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).kr();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent a(int n2, byte[] byArray, int n3, Bitmap bitmap, String string2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).a(n2, byArray, n3, string2);
            o.b(bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public int ks() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.gS()).ks();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
        return n2;
    }

    public int kt() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.gS()).kt();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void b(BaseImplementation.b<Requests.UpdateRequestsResult> b2, String[] stringArray) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(b2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Requests.UpdateRequestsResult> b2, String[] stringArray) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(b2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Requests.LoadRequestsResult> b2, int n2, int n3, int n4) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new RequestsLoadedBinderCallbacks(b2), n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public Intent b(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).b(nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent bC(String string2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).bC(string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void i(BaseImplementation.b<Quests.AcceptQuestResult> b2, String string2) {
        try {
            this.Ws.flush();
            ((IGamesService)this.gS()).u(new QuestAcceptedBinderCallbacks(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Quests.ClaimMilestoneResult> b2, String string2, String string3) {
        try {
            this.Ws.flush();
            ((IGamesService)this.gS()).f(new QuestMilestoneClaimBinderCallbacks(b2, string3), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Quests.LoadQuestsResult> b2, int[] nArray, int n2, boolean bl2) {
        try {
            this.Ws.flush();
            ((IGamesService)this.gS()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(b2), nArray, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Quests.LoadQuestsResult> b2, boolean bl2, String[] stringArray) {
        try {
            this.Ws.flush();
            ((IGamesService)this.gS()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(b2), stringArray, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void bD(String string2) {
        try {
            ((IGamesService)this.gS()).a(string2, this.Wx.kO(), this.Wx.kN());
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Quests.LoadQuestsResult> b2, String string2, String string3, int[] nArray, int n2, boolean bl2) {
        try {
            this.Ws.flush();
            ((IGamesService)this.gS()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(b2), string2, string3, nArray, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Quests.LoadQuestsResult> b2, String string2, String string3, boolean bl2, String[] stringArray) {
        try {
            this.Ws.flush();
            ((IGamesService)this.gS()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(b2), string2, string3, stringArray, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public int ku() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.gS()).ku();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
        return n2;
    }

    public int kv() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.gS()).kv();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
        return n2;
    }

    public Intent a(String string2, boolean bl2, boolean bl3, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).a(string2, bl2, bl3, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void e(BaseImplementation.b<Snapshots.LoadSnapshotsResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).d((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Snapshots.OpenSnapshotResult> b2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).e((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(b2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Snapshots.CommitSnapshotResult> b2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        o.a(!snapshotContents.isClosed(), "Snapshot already closed");
        a a2 = snapshotMetadataChange.lM();
        if (a2 != null) {
            a2.a(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.getContents();
        snapshotContents.close();
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(b2), snapshot.getMetadata().getSnapshotId(), snapshotMetadataChange, contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        o.a(!snapshotContents.isClosed(), "Snapshot already closed");
        Contents contents = snapshotContents.getContents();
        snapshotContents.close();
        try {
            ((IGamesService)this.gS()).a(contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void j(BaseImplementation.b<Snapshots.DeleteSnapshotResult> b2, String string2) {
        try {
            ((IGamesService)this.gS()).r(new SnapshotDeletedBinderCallbacks(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Snapshots.OpenSnapshotResult> b2, String string2, String string3, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) {
        o.a(!snapshotContents.isClosed(), "SnapshotContents already closed");
        a a2 = snapshotMetadataChange.lM();
        if (a2 != null) {
            a2.a(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.getContents();
        snapshotContents.close();
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(b2), string2, string3, snapshotMetadataChange, contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(b2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void k(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string2) {
        try {
            ((IGamesService)this.gS()).e((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void l(BaseImplementation.b<GamesMetadata.LoadGameInstancesResult> b2, String string2) {
        try {
            ((IGamesService)this.gS()).f((IGamesCallbacks)new GameInstancesLoadedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, int n2, int n3, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(b2), n2, n3, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string2, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(b2), string2, n2, bl2, bl3, bl4, bl5);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).e(new ExtendedGamesLoadedBinderCallback(b2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).f(new ExtendedGamesLoadedBinderCallback(b2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void e(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).c(new ExtendedGamesLoadedBinderCallback(b2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void m(BaseImplementation.b<GamesMetadata.LoadGameSearchSuggestionsResult> b2, String string2) {
        try {
            ((IGamesService)this.gS()).q(new GameSearchSuggestionsLoadedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> b2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).d((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(b2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> b2, String string2, String string3, boolean bl2) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(b2), string2, string3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, String string2, String string3, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(b2), string2, string3, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, String string2, String string3, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.gS()).b(new LeaderboardScoresLoadedBinderCallback(b2), string2, string3, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Players.LoadPlayersResult> b2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Players.LoadPlayersResult> b2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<Players.LoadPlayersResult> b2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).e(new PlayersLoadedBinderCallback(b2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, String string2, int n2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), string2, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void f(BaseImplementation.b<Players.LoadPlayersResult> b2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void e(BaseImplementation.b<Players.LoadPlayersResult> b2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).d(new PlayersLoadedBinderCallback(b2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void g(BaseImplementation.b<Players.LoadPlayersResult> b2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), string2, null, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void g(BaseImplementation.b<Players.LoadOwnerCoverPhotoUrisResult> b2) {
        try {
            ((IGamesService)this.gS()).j(new OwnerCoverPhotoUrisLoadedBinderCallback(b2));
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void n(BaseImplementation.b<Players.LoadXpForGameCategoriesResult> b2, String string2) {
        try {
            ((IGamesService)this.gS()).s(new PlayerXpForGameCategoriesLoadedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Players.LoadXpStreamResult> b2, String string2, int n2) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(b2), string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<Players.LoadXpStreamResult> b2, String string2, int n2) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(b2), string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void f(BaseImplementation.b<Players.LoadProfileSettingsResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).g((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void g(BaseImplementation.b<Status> b2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).h((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Achievements.LoadAchievementsResult> b2, String string2, String string3, boolean bl2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new AchievementsLoadedBinderCallback(b2), string2, string3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, String string2, String string3) {
        try {
            ((IGamesService)this.gS()).d((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(b2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, String string2, String string3) {
        try {
            ((IGamesService)this.gS()).e((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(b2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void e(BaseImplementation.b<Invitations.LoadInvitationsResult> b2, String string2, int n2) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new InvitationsLoadedBinderCallback(b2), string2, n2, false);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void o(BaseImplementation.b<Invitations.LoadInvitationsResult> b2, String string2) {
        try {
            ((IGamesService)this.gS()).k(new InvitationsLoadedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchesResult> b2, String string2, int n2, int[] nArray) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(b2), string2, n2, nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void h(BaseImplementation.b<Acls.LoadAclResult> b2) {
        try {
            ((IGamesService)this.gS()).h(new NotifyAclLoadedBinderCallback(b2));
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void p(BaseImplementation.b<Status> b2, String string2) {
        try {
            ((IGamesService)this.gS()).j(new NotifyAclUpdatedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<Notifications.GameMuteStatusChangeResult> b2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(b2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void q(BaseImplementation.b<Notifications.GameMuteStatusLoadResult> b2, String string2) {
        try {
            ((IGamesService)this.gS()).i(new GameMuteStatusLoadedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    @Deprecated
    public void i(BaseImplementation.b<Notifications.ContactSettingLoadResult> b2) {
        try {
            ((IGamesService)this.gS()).e((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(b2), false);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void h(BaseImplementation.b<Notifications.ContactSettingLoadResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).e((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Status> b2, boolean bl2, Bundle bundle) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(b2), bl2, bundle);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void j(BaseImplementation.b<Notifications.InboxCountResult> b2) {
        try {
            ((IGamesService)this.gS()).t(new InboxCountsLoadedBinderCallback(b2), null);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Requests.SendRequestResult> b2, String string2, String[] stringArray, int n2, byte[] byArray, int n3) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new RequestSentBinderCallbacks(b2), string2, stringArray, n2, byArray, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Requests.UpdateRequestsResult> b2, String string2, String string3, String[] stringArray) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(b2), string2, string3, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Requests.LoadRequestsResult> b2, String string2, String string3, int n2, int n3, int n4) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new RequestsLoadedBinderCallbacks(b2), string2, string3, n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void f(BaseImplementation.b<Requests.LoadRequestSummariesResult> b2, String string2, int n2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(b2), string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Snapshots.LoadSnapshotsResult> b2, String string2, String string3, boolean bl2) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(b2), string2, string3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    private void kw() {
        for (RealTimeSocket realTimeSocket : this.Wu.values()) {
            try {
                realTimeSocket.close();
            }
            catch (IOException iOException) {
                GamesLog.c("GamesClientImpl", "IOException:", iOException);
            }
        }
        this.Wu.clear();
    }

    public void a(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.gS()).a(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                GamesLog.p("GamesClientImpl", "service died");
            }
        }
    }

    public void kx() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.gS()).kx();
            }
            catch (RemoteException remoteException) {
                GamesLog.p("GamesClientImpl", "service died");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Room R(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 && bundle != null) {
            this.Wy = bundle.getBoolean("show_welcome_popup");
        }
        super.a(n2, iBinder, bundle);
    }

    @Override
    protected /* synthetic */ IInterface j(IBinder iBinder) {
        return this.az(iBinder);
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status CM;
        private final String WI;

        DeleteSnapshotResultImpl(int statusCode, String snapshotId) {
            this.CM = new Status(statusCode);
            this.WI = snapshotId;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public String getSnapshotId() {
            return this.WI;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends com.google.android.gms.common.api.a
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata WH;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.WH = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.WH;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends com.google.android.gms.common.api.a
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot Xm;
        private final String Xn;
        private final Snapshot Xo;
        private final Contents Xp;
        private final SnapshotContents Xq;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents currentContents) {
            this(dataHolder, null, currentContents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder metadataHolder, String conflictId, Contents currentContents, Contents conflictContents, Contents resolutionContents) {
            super(metadataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(metadataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.Xm = null;
                    this.Xo = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    com.google.android.gms.common.internal.a.I(metadataHolder.getStatusCode() != 4004);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.Xm = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContents(currentContents));
                    this.Xo = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.Xm = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContents(currentContents));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(1));
                    this.Xo = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContents(conflictContents));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.Xn = conflictId;
            this.Xp = resolutionContents;
            this.Xq = new SnapshotContents(resolutionContents);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.Xm;
        }

        @Override
        public String getConflictId() {
            return this.Xn;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.Xo;
        }

        @Override
        @Deprecated
        public Contents getResolutionContents() {
            return this.Xp;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.Xq;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends com.google.android.gms.common.api.a
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.II);
        }
    }

    private static final class LoadQuestsResultImpl
    extends com.google.android.gms.common.api.a
    implements Quests.LoadQuestsResult {
        private final DataHolder II;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.II = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.II);
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends com.google.android.gms.common.api.a
    implements Quests.ClaimMilestoneResult {
        private final Milestone WG;
        private final Quest WE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String milestoneId) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.WE = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.WE.lJ();
                    int n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (!list.get(i2).getMilestoneId().equals(milestoneId)) continue;
                        this.WG = list.get(i2);
                        return;
                    }
                    this.WG = null;
                } else {
                    this.WG = null;
                    this.WE = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.WG;
        }

        @Override
        public Quest getQuest() {
            return this.WE;
        }
    }

    private static final class AcceptQuestResultImpl
    extends com.google.android.gms.common.api.a
    implements Quests.AcceptQuestResult {
        private final Quest WE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.WE = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.WE;
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends com.google.android.gms.common.api.a
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status CM;
        private final Bundle Xb;

        LoadRequestsResultImpl(Status status, Bundle requestData) {
            this.CM = status;
            this.Xb = requestData;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public GameRequestBuffer getRequests(int requestType) {
            String string2 = RequestType.dH(requestType);
            if (!this.Xb.containsKey(string2)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.Xb.get(string2);
            return new GameRequestBuffer(dataHolder);
        }

        @Override
        public void release() {
            for (String string2 : this.Xb.keySet()) {
                DataHolder dataHolder = (DataHolder)this.Xb.getParcelable(string2);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends com.google.android.gms.common.api.a
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes XU;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.XU = RequestUpdateOutcomes.V(dataHolder);
        }

        @Override
        public int getRequestOutcome(String requestId) {
            return this.XU.getRequestOutcome(requestId);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.XU.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends com.google.android.gms.common.api.a
    implements Requests.SendRequestResult {
        private final GameRequest XB;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.XB = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status CM;
        private final Bundle WL;

        InboxCountResultImpl(Status status, Bundle inboxCounts) {
            this.CM = status;
            this.WL = inboxCounts;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends com.google.android.gms.common.api.a
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status CM;
        private final String WJ;
        private final boolean WK;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.CM = new Status(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.WJ = dataHolder.c("external_game_id", 0, 0);
                    this.WK = dataHolder.d("muted", 0, 0);
                } else {
                    this.WJ = null;
                    this.WK = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status CM;
        private final String WJ;
        private final boolean WK;

        public GameMuteStatusChangeResultImpl(int statusCode, String externalGameId, boolean isMuted) {
            this.CM = new Status(statusCode);
            this.WJ = externalGameId;
            this.WK = isMuted;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }
    }

    private static final class LoadAclResultImpl
    extends com.google.android.gms.common.api.a
    implements Acls.LoadAclResult {
        LoadAclResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status CM;
        private final String WF;

        CancelMatchResultImpl(Status status, String externalMatchId) {
            this.CM = status;
            this.WF = externalMatchId;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public String getMatchId() {
            return this.WF;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends com.google.android.gms.common.api.a {
        final TurnBasedMatch Xj;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.Xj = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.Xj;
        }
    }

    private static final class SubmitScoreResultImpl
    extends com.google.android.gms.common.api.a
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData XN;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.XN = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.XN;
        }
    }

    private static final class LoadOwnerCoverPhotoUrisResultImpl
    implements Players.LoadOwnerCoverPhotoUrisResult {
        private final Status CM;
        private final Bundle Nh;

        LoadOwnerCoverPhotoUrisResultImpl(int statusCode, Bundle bundle) {
            this.CM = new Status(statusCode);
            this.Nh = bundle;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }
    }

    private static final class LoadProfileSettingsResultImpl
    extends com.google.android.gms.common.api.a
    implements Players.LoadProfileSettingsResult {
        private final boolean Wp;
        private final boolean Xa;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadProfileSettingsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                if (dataHolder.getCount() > 0) {
                    int n2 = dataHolder.ar(0);
                    this.Wp = dataHolder.d("profile_visible", 0, n2);
                    this.Xa = dataHolder.d("profile_visibility_explicitly_set", 0, n2);
                } else {
                    this.Wp = true;
                    this.Xa = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public boolean isProfileVisible() {
            return this.Wp;
        }

        @Override
        public boolean isVisibilityExplicitlySet() {
            return this.Xa;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends com.google.android.gms.common.api.a
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer Xg;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Xg = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status CM;
        private final List<String> Xe;
        private final Bundle Xf;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle xpData) {
            this.CM = status;
            this.Xe = xpData.getStringArrayList("game_category_list");
            this.Xf = xpData;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }
    }

    private static final class LoadPlayersResultImpl
    extends com.google.android.gms.common.api.a
    implements Players.LoadPlayersResult {
        private final PlayerBuffer WZ;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WZ = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.WZ;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status CM;
        private final LoadMatchesResponse WX;

        LoadMatchesResultImpl(Status status, Bundle matchData) {
            this.CM = status;
            this.WX = new LoadMatchesResponse(matchData);
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.WX;
        }

        @Override
        public void release() {
            this.WX.close();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends com.google.android.gms.common.api.a
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer WW;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WW = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.WW;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends com.google.android.gms.common.api.a
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity WY;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadPlayerScoreResultImpl(DataHolder scoreHolder) {
            super(scoreHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(scoreHolder);
            try {
                this.WY = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)leaderboardScoreBuffer.get(0).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.WY;
        }
    }

    private static final class LoadScoresResultImpl
    extends com.google.android.gms.common.api.a
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity Xc;
        private final LeaderboardScoreBuffer Xd;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder leaderboard, DataHolder scores) {
            super(scores);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(leaderboard);
            try {
                this.Xc = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.Xd = new LeaderboardScoreBuffer(scores);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.Xc;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.Xd;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends com.google.android.gms.common.api.a
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer WP;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WP = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.WP;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends com.google.android.gms.common.api.a
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        LoadGameSearchSuggestionsResultImpl(DataHolder data) {
            super(data);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends com.google.android.gms.common.api.a
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer WU;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WU = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadExtendedGamesResultImpl
    extends com.google.android.gms.common.api.a
    implements GamesMetadata.LoadExtendedGamesResult {
        private final ExtendedGameBuffer WT;

        LoadExtendedGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WT = new ExtendedGameBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends com.google.android.gms.common.api.a
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer WV;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WV = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.WV;
        }
    }

    private static final class LoadEventResultImpl
    extends com.google.android.gms.common.api.a
    implements Events.LoadEventsResult {
        private final EventBuffer WS;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WS = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.WS;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status CM;
        private final String Wa;

        UpdateAchievementResultImpl(int statusCode, String achievementId) {
            this.CM = new Status(statusCode);
            this.Wa = achievementId;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public String getAchievementId() {
            return this.Wa;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends com.google.android.gms.common.api.a
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer WR;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WR = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.WR;
        }
    }

    private final class RealTimeMessageSentCallback
    extends e.b<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int HF;
        private final String Xx;
        private final int Xy;

        RealTimeMessageSentCallback(RealTimeMultiplayer.ReliableMessageSentCallback listener, int statusCode, int token, String recipientParticipantId) {
            super(GamesClientImpl.this, listener);
            this.HF = statusCode;
            this.Xy = token;
            this.Xx = recipientParticipantId;
        }

        public void a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.HF, this.Xy, this.Xx);
            }
        }

        @Override
        protected void gT() {
        }

        @Override
        public /* synthetic */ void g(Object object) {
            this.a((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private final class MessageReceivedCallback
    extends e.b<RealTimeMessageReceivedListener> {
        private final RealTimeMessage Xk;

        MessageReceivedCallback(RealTimeMessageReceivedListener listener, RealTimeMessage message) {
            super(GamesClientImpl.this, listener);
            this.Xk = message;
        }

        public void a(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            if (realTimeMessageReceivedListener != null) {
                realTimeMessageReceivedListener.onRealTimeMessageReceived(this.Xk);
            }
        }

        @Override
        protected void gT() {
        }

        @Override
        public /* synthetic */ void g(Object object) {
            this.a((RealTimeMessageReceivedListener)object);
        }
    }

    private final class P2PDisconnectedCallback
    extends e.b<RoomStatusUpdateListener> {
        private final String Xr;

        P2PDisconnectedCallback(RoomStatusUpdateListener listener, String participantId) {
            super(GamesClientImpl.this, listener);
            this.Xr = participantId;
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PDisconnected(this.Xr);
            }
        }

        @Override
        protected void gT() {
        }

        @Override
        public /* synthetic */ void g(Object object) {
            this.a((RoomStatusUpdateListener)object);
        }
    }

    private final class P2PConnectedCallback
    extends e.b<RoomStatusUpdateListener> {
        private final String Xr;

        P2PConnectedCallback(RoomStatusUpdateListener listener, String participantId) {
            super(GamesClientImpl.this, listener);
            this.Xr = participantId;
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PConnected(this.Xr);
            }
        }

        @Override
        protected void gT() {
        }

        @Override
        public /* synthetic */ void g(Object object) {
            this.a((RoomStatusUpdateListener)object);
        }
    }

    private final class PeerDisconnectedCallback
    extends AbstractPeerStatusCallback {
        PeerDisconnectedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private final class PeerConnectedCallback
    extends AbstractPeerStatusCallback {
        PeerConnectedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private final class PeerDeclinedCallback
    extends AbstractPeerStatusCallback {
        PeerDeclinedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private final class PeerLeftRoomCallback
    extends AbstractPeerStatusCallback {
        PeerLeftRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private final class PeerJoinedRoomCallback
    extends AbstractPeerStatusCallback {
        PeerJoinedRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private final class PeerInvitedToRoomCallback
    extends AbstractPeerStatusCallback {
        PeerInvitedToRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private final class DisconnectedFromRoomCallback
    extends AbstractRoomStatusCallback {
        DisconnectedFromRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private final class ConnectedToRoomCallback
    extends AbstractRoomStatusCallback {
        ConnectedToRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private final class RoomAutoMatchingCallback
    extends AbstractRoomStatusCallback {
        RoomAutoMatchingCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private final class RoomConnectingCallback
    extends AbstractRoomStatusCallback {
        RoomConnectingCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private final class RoomConnectedCallback
    extends AbstractRoomCallback {
        RoomConnectedCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomConnected(n2, room);
        }
    }

    private final class LeftRoomCallback
    extends e.b<RoomUpdateListener> {
        private final int HF;
        private final String WQ;

        LeftRoomCallback(RoomUpdateListener listener, int statusCode, String roomId) {
            super(GamesClientImpl.this, listener);
            this.HF = statusCode;
            this.WQ = roomId;
        }

        public void a(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.HF, this.WQ);
        }

        @Override
        protected void gT() {
        }

        @Override
        public /* synthetic */ void g(Object object) {
            this.a((RoomUpdateListener)object);
        }
    }

    private final class JoinedRoomCallback
    extends AbstractRoomCallback {
        public JoinedRoomCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onJoinedRoom(n2, room);
        }
    }

    private final class RoomCreatedCallback
    extends AbstractRoomCallback {
        public RoomCreatedCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomCreated(n2, room);
        }
    }

    private abstract class AbstractPeerStatusCallback
    extends AbstractRoomStatusCallback {
        private final ArrayList<String> WD;

        AbstractPeerStatusCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder);
            this.WD = new ArrayList();
            int n2 = participantIds.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.WD.add(participantIds[i2]);
            }
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.a(roomStatusUpdateListener, room, this.WD);
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private abstract class AbstractRoomStatusCallback
    extends e.d<RoomStatusUpdateListener> {
        AbstractRoomStatusCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(GamesClientImpl.this, listener, dataHolder);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.a(roomStatusUpdateListener, GamesClientImpl.this.R(dataHolder));
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2);
    }

    private abstract class AbstractRoomCallback
    extends e.d<RoomUpdateListener> {
        AbstractRoomCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(GamesClientImpl.this, listener, dataHolder);
        }

        @Override
        protected void a(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.a(roomUpdateListener, GamesClientImpl.this.R(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void a(RoomUpdateListener var1, Room var2, int var3);
    }

    private final class NearbyPlayerDetectedCallback
    extends e.b<OnNearbyPlayerDetectedListener> {
        private final Player Xl;

        protected void a(OnNearbyPlayerDetectedListener onNearbyPlayerDetectedListener) {
            onNearbyPlayerDetectedListener.a(this.Xl);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.a((OnNearbyPlayerDetectedListener)object);
        }
    }

    private final class RequestRemovedCallback
    extends e.b<OnRequestReceivedListener> {
        private final String XC;

        RequestRemovedCallback(OnRequestReceivedListener listener, String requestId) {
            super(GamesClientImpl.this, listener);
            this.XC = requestId;
        }

        protected void b(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.XC);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((OnRequestReceivedListener)object);
        }
    }

    private final class RequestReceivedCallback
    extends e.b<OnRequestReceivedListener> {
        private final GameRequest XB;

        RequestReceivedCallback(OnRequestReceivedListener listener, GameRequest request) {
            super(GamesClientImpl.this, listener);
            this.XB = request;
        }

        protected void b(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.XB);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((OnRequestReceivedListener)object);
        }
    }

    private final class QuestCompletedCallback
    extends e.b<QuestUpdateListener> {
        private final Quest WE;

        QuestCompletedCallback(QuestUpdateListener listener, Quest quest) {
            super(GamesClientImpl.this, listener);
            this.WE = quest;
        }

        protected void b(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.WE);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((QuestUpdateListener)object);
        }
    }

    private final class MatchRemovedCallback
    extends e.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final String Xh;

        MatchRemovedCallback(OnTurnBasedMatchUpdateReceivedListener listener, String matchId) {
            super(GamesClientImpl.this, listener);
            this.Xh = matchId;
        }

        protected void b(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.Xh);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private final class MatchUpdateReceivedCallback
    extends e.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch Xj;

        MatchUpdateReceivedCallback(OnTurnBasedMatchUpdateReceivedListener listener, TurnBasedMatch match) {
            super(GamesClientImpl.this, listener);
            this.Xj = match;
        }

        protected void b(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.Xj);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private final class InvitationRemovedCallback
    extends e.b<OnInvitationReceivedListener> {
        private final String WO;

        InvitationRemovedCallback(OnInvitationReceivedListener listener, String invitationId) {
            super(GamesClientImpl.this, listener);
            this.WO = invitationId;
        }

        protected void b(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.WO);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((OnInvitationReceivedListener)object);
        }
    }

    private final class InvitationReceivedCallback
    extends e.b<OnInvitationReceivedListener> {
        private final Invitation WN;

        InvitationReceivedCallback(OnInvitationReceivedListener listener, Invitation invitation) {
            super(GamesClientImpl.this, listener);
            this.WN = invitation;
        }

        protected void b(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.WN);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((OnInvitationReceivedListener)object);
        }
    }

    final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Snapshots.DeleteSnapshotResult> De;

        public SnapshotDeletedBinderCallbacks(BaseImplementation.b<Snapshots.DeleteSnapshotResult> resultHolder) {
            this.De = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void i(int n2, String string2) {
            this.De.b(new DeleteSnapshotResultImpl(n2, string2));
        }
    }

    private final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Snapshots.CommitSnapshotResult> XK;

        public SnapshotCommittedBinderCallbacks(BaseImplementation.b<Snapshots.CommitSnapshotResult> resultHolder) {
            this.XK = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void J(DataHolder dataHolder) {
            this.XK.b(new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Snapshots.OpenSnapshotResult> XL;

        public SnapshotOpenedBinderCallbacks(BaseImplementation.b<Snapshots.OpenSnapshotResult> resultHolder) {
            this.XL = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void a(DataHolder dataHolder, Contents contents) {
            this.XL.b(new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void a(DataHolder dataHolder, String string2, Contents contents, Contents contents2, Contents contents3) {
            this.XL.b(new OpenSnapshotResultImpl(dataHolder, string2, contents, contents2, contents3));
        }
    }

    private final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Snapshots.LoadSnapshotsResult> XM;

        public SnapshotsLoadedBinderCallbacks(BaseImplementation.b<Snapshots.LoadSnapshotsResult> resultHolder) {
            this.XM = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void I(DataHolder dataHolder) {
            this.XM.b(new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Quests.LoadQuestsResult> Xw;

        public QuestsLoadedBinderCallbacks(BaseImplementation.b<Quests.LoadQuestsResult> resultHolder) {
            this.Xw = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void O(DataHolder dataHolder) {
            this.Xw.b(new LoadQuestsResultImpl(dataHolder));
        }
    }

    private final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Quests.ClaimMilestoneResult> Xt;
        private final String Xu;

        public QuestMilestoneClaimBinderCallbacks(BaseImplementation.b<Quests.ClaimMilestoneResult> resultHolder, String milestoneId) {
            this.Xt = o.b(resultHolder, (Object)"Holder must not be null");
            this.Xu = o.b(milestoneId, (Object)"MilestoneId must not be null");
        }

        @Override
        public void K(DataHolder dataHolder) {
            this.Xt.b(new ClaimMilestoneResultImpl(dataHolder, this.Xu));
        }
    }

    private final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Quests.AcceptQuestResult> Xs;

        public QuestAcceptedBinderCallbacks(BaseImplementation.b<Quests.AcceptQuestResult> resultHolder) {
            this.Xs = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void L(DataHolder dataHolder) {
            this.Xs.b(new AcceptQuestResultImpl(dataHolder));
        }
    }

    private final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Requests.LoadRequestSummariesResult> XE;

        public RequestSummariesLoadedBinderCallbacks(BaseImplementation.b<Requests.LoadRequestSummariesResult> resultHolder) {
            this.XE = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void H(DataHolder dataHolder) {
            this.XE.b(new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Requests.LoadRequestsResult> XF;

        public RequestsLoadedBinderCallbacks(BaseImplementation.b<Requests.LoadRequestsResult> resultHolder) {
            this.XF = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void c(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.XF.b(new LoadRequestsResultImpl(status, bundle));
        }
    }

    private final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Requests.SendRequestResult> XD;

        public RequestSentBinderCallbacks(BaseImplementation.b<Requests.SendRequestResult> resultHolder) {
            this.XD = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void G(DataHolder dataHolder) {
            this.XD.b(new SendRequestResultImpl(dataHolder));
        }
    }

    private final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Requests.UpdateRequestsResult> XG;

        public RequestsUpdatedBinderCallbacks(BaseImplementation.b<Requests.UpdateRequestsResult> resultHolder) {
            this.XG = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void F(DataHolder dataHolder) {
            this.XG.b(new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Status> De;

        public SignOutCompleteBinderCallbacks(BaseImplementation.b<Status> resultHolder) {
            this.De = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void fp() {
            Status status = new Status(0);
            this.De.b(status);
        }
    }

    private final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Notifications.InboxCountResult> De;

        InboxCountsLoadedBinderCallback(BaseImplementation.b<Notifications.InboxCountResult> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void f(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.De.b(new InboxCountResultImpl(status, bundle));
        }
    }

    private final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Status> De;

        ContactSettingsUpdatedBinderCallback(BaseImplementation.b<Status> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void dy(int n2) {
            this.De.b(new Status(n2));
        }
    }

    private final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Notifications.ContactSettingLoadResult> De;

        ContactSettingsLoadedBinderCallback(BaseImplementation.b<Notifications.ContactSettingLoadResult> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void D(DataHolder dataHolder) {
            this.De.b(new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Notifications.GameMuteStatusLoadResult> De;

        GameMuteStatusLoadedBinderCallback(BaseImplementation.b<Notifications.GameMuteStatusLoadResult> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void B(DataHolder dataHolder) {
            this.De.b(new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Notifications.GameMuteStatusChangeResult> De;

        GameMuteStatusChangedBinderCallback(BaseImplementation.b<Notifications.GameMuteStatusChangeResult> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void a(int n2, String string2, boolean bl2) {
            this.De.b(new GameMuteStatusChangeResultImpl(n2, string2, bl2));
        }
    }

    private final class NotifyAclUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Status> De;

        NotifyAclUpdatedBinderCallback(BaseImplementation.b<Status> resultHolder) {
            this.De = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void dx(int n2) {
            this.De.b(new Status(n2));
        }
    }

    private final class NotifyAclLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Acls.LoadAclResult> De;

        NotifyAclLoadedBinderCallback(BaseImplementation.b<Acls.LoadAclResult> resultHolder) {
            this.De = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void C(DataHolder dataHolder) {
            this.De.b(new LoadAclResultImpl(dataHolder));
        }
    }

    private final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final RealTimeMultiplayer.ReliableMessageSentCallback Xz;

        public RealTimeReliableMessageBinderCallbacks(RealTimeMultiplayer.ReliableMessageSentCallback messageSentCallbacks) {
            this.Xz = messageSentCallbacks;
        }

        @Override
        public void b(int n2, int n3, String string2) {
            GamesClientImpl.this.a(new RealTimeMessageSentCallback(this.Xz, n2, n3, string2));
        }
    }

    private final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final RoomUpdateListener XH;
        private final RoomStatusUpdateListener XI;
        private final RealTimeMessageReceivedListener XJ;

        public RoomBinderCallbacks(RoomUpdateListener roomCallbacks) {
            this.XH = o.b(roomCallbacks, (Object)"Callbacks must not be null");
            this.XI = null;
            this.XJ = null;
        }

        public RoomBinderCallbacks(RoomUpdateListener roomCallbacks, RoomStatusUpdateListener roomStatusCallbacks, RealTimeMessageReceivedListener realTimeMessageReceivedCallbacks) {
            this.XH = o.b(roomCallbacks, (Object)"Callbacks must not be null");
            this.XI = roomStatusCallbacks;
            this.XJ = realTimeMessageReceivedCallbacks;
        }

        @Override
        public void u(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomCreatedCallback(this.XH, dataHolder));
        }

        @Override
        public void v(DataHolder dataHolder) {
            GamesClientImpl.this.a(new JoinedRoomCallback(this.XH, dataHolder));
        }

        @Override
        public void onLeftRoom(int statusCode, String externalRoomId) {
            GamesClientImpl.this.a(new LeftRoomCallback(this.XH, statusCode, externalRoomId));
        }

        @Override
        public void y(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomConnectedCallback(this.XH, dataHolder));
        }

        @Override
        public void w(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomConnectingCallback(this.XI, dataHolder));
        }

        @Override
        public void x(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomAutoMatchingCallback(this.XI, dataHolder));
        }

        @Override
        public void z(DataHolder dataHolder) {
            GamesClientImpl.this.a(new ConnectedToRoomCallback(this.XI, dataHolder));
        }

        @Override
        public void A(DataHolder dataHolder) {
            GamesClientImpl.this.a(new DisconnectedFromRoomCallback(this.XI, dataHolder));
        }

        @Override
        public void e(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerConnectedCallback(this.XI, dataHolder, stringArray));
        }

        @Override
        public void f(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerDisconnectedCallback(this.XI, dataHolder, stringArray));
        }

        @Override
        public void a(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerInvitedToRoomCallback(this.XI, dataHolder, stringArray));
        }

        @Override
        public void b(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerJoinedRoomCallback(this.XI, dataHolder, stringArray));
        }

        @Override
        public void c(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerLeftRoomCallback(this.XI, dataHolder, stringArray));
        }

        @Override
        public void d(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerDeclinedCallback(this.XI, dataHolder, stringArray));
        }

        @Override
        public void onP2PConnected(String participantId) {
            GamesClientImpl.this.a(new P2PConnectedCallback(this.XI, participantId));
        }

        @Override
        public void onP2PDisconnected(String participantId) {
            GamesClientImpl.this.a(new P2PDisconnectedCallback(this.XI, participantId));
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage message) {
            GamesClientImpl.this.a(new MessageReceivedCallback(this.XJ, message));
        }
    }

    private final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.CancelMatchResult> XO;

        public TurnBasedMatchCanceledBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.CancelMatchResult> resultHolder) {
            this.XO = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void h(int n2, String string2) {
            Status status = new Status(n2);
            this.XO.b(new CancelMatchResultImpl(status, string2));
        }
    }

    private final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.LeaveMatchResult> XQ;

        public TurnBasedMatchLeftBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.LeaveMatchResult> resultHolder) {
            this.XQ = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void s(DataHolder dataHolder) {
            this.XQ.b(new LeaveMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.UpdateMatchResult> XS;

        public TurnBasedMatchUpdatedBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.UpdateMatchResult> resultHolder) {
            this.XS = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void r(DataHolder dataHolder) {
            this.XS.b(new UpdateMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> XP;

        public TurnBasedMatchInitiatedBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> resultHolder) {
            this.XP = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void q(DataHolder dataHolder) {
            this.XP.b(new InitiateMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.LoadMatchResult> XR;

        public TurnBasedMatchLoadedBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchResult> resultHolder) {
            this.XR = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void p(DataHolder dataHolder) {
            this.XR.b(new LoadMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.LoadMatchesResult> XT;

        public TurnBasedMatchesLoadedBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchesResult> resultHolder) {
            this.XT = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void b(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.XT.b(new LoadMatchesResultImpl(status, bundle));
        }
    }

    private final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Leaderboards.SubmitScoreResult> De;

        public SubmitScoreBinderCallbacks(BaseImplementation.b<Leaderboards.SubmitScoreResult> resultHolder) {
            this.De = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void f(DataHolder dataHolder) {
            this.De.b(new SubmitScoreResultImpl(dataHolder));
        }
    }

    private final class OwnerCoverPhotoUrisLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadOwnerCoverPhotoUrisResult> De;

        OwnerCoverPhotoUrisLoadedBinderCallback(BaseImplementation.b<Players.LoadOwnerCoverPhotoUrisResult> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void d(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            this.De.b(new LoadOwnerCoverPhotoUrisResultImpl(n2, bundle));
        }
    }

    private final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Status> De;

        ProfileSettingsUpdatedBinderCallback(BaseImplementation.b<Status> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void dz(int n2) {
            this.De.b(new Status(n2));
        }
    }

    final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadProfileSettingsResult> De;

        ProfileSettingsLoadedBinderCallback(BaseImplementation.b<Players.LoadProfileSettingsResult> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void Q(DataHolder dataHolder) {
            this.De.b(new LoadProfileSettingsResultImpl(dataHolder));
        }
    }

    final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadXpStreamResult> De;

        PlayerXpStreamLoadedBinderCallback(BaseImplementation.b<Players.LoadXpStreamResult> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void P(DataHolder dataHolder) {
            this.De.b(new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadXpForGameCategoriesResult> De;

        PlayerXpForGameCategoriesLoadedBinderCallback(BaseImplementation.b<Players.LoadXpForGameCategoriesResult> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void e(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.De.b(new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadPlayersResult> De;

        PlayersLoadedBinderCallback(BaseImplementation.b<Players.LoadPlayersResult> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void g(DataHolder dataHolder) {
            this.De.b(new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void h(DataHolder dataHolder) {
            this.De.b(new LoadPlayersResultImpl(dataHolder));
        }
    }

    private final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnRequestReceivedListener XA;

        RequestReceivedBinderCallback(OnRequestReceivedListener listener) {
            this.XA = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void o(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                GamesClientImpl.this.a(new RequestReceivedCallback(this.XA, gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String requestId) {
            GamesClientImpl.this.a(new RequestRemovedCallback(this.XA, requestId));
        }
    }

    private final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final QuestUpdateListener Xv;

        QuestUpdateBinderCallback(QuestUpdateListener listener) {
            this.Xv = listener;
        }

        @Override
        public void M(DataHolder dataHolder) {
            Quest quest = this.S(dataHolder);
            if (quest != null) {
                GamesClientImpl.this.a(new QuestCompletedCallback(this.Xv, quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest S(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnTurnBasedMatchUpdateReceivedListener Xi;

        MatchUpdateReceivedBinderCallback(OnTurnBasedMatchUpdateReceivedListener listener) {
            this.Xi = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void t(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                GamesClientImpl.this.a(new MatchUpdateReceivedCallback(this.Xi, turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String matchId) {
            GamesClientImpl.this.a(new MatchRemovedCallback(this.Xi, matchId));
        }
    }

    private final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnInvitationReceivedListener WM;

        InvitationReceivedBinderCallback(OnInvitationReceivedListener listener) {
            this.WM = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void n(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                GamesClientImpl.this.a(new InvitationReceivedCallback(this.WM, invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String invitationId) {
            GamesClientImpl.this.a(new InvitationRemovedCallback(this.WM, invitationId));
        }
    }

    private final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Invitations.LoadInvitationsResult> De;

        InvitationsLoadedBinderCallback(BaseImplementation.b<Invitations.LoadInvitationsResult> resultHolder) {
            this.De = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void m(DataHolder dataHolder) {
            this.De.b(new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Leaderboards.LoadPlayerScoreResult> De;

        PlayerLeaderboardScoreLoadedBinderCallback(BaseImplementation.b<Leaderboards.LoadPlayerScoreResult> resultHolder) {
            this.De = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void E(DataHolder dataHolder) {
            this.De.b(new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Leaderboards.LoadScoresResult> De;

        LeaderboardScoresLoadedBinderCallback(BaseImplementation.b<Leaderboards.LoadScoresResult> resultHolder) {
            this.De = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void a(DataHolder dataHolder, DataHolder dataHolder2) {
            this.De.b(new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> De;

        LeaderboardsLoadedBinderCallback(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> resultHolder) {
            this.De = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void e(DataHolder dataHolder) {
            this.De.b(new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<GamesMetadata.LoadGameSearchSuggestionsResult> De;

        GameSearchSuggestionsLoadedBinderCallback(BaseImplementation.b<GamesMetadata.LoadGameSearchSuggestionsResult> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void l(DataHolder dataHolder) {
            this.De.b(new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<GamesMetadata.LoadGameInstancesResult> De;

        GameInstancesLoadedBinderCallback(BaseImplementation.b<GamesMetadata.LoadGameInstancesResult> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void k(DataHolder dataHolder) {
            this.De.b(new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private final class ExtendedGamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> De;

        ExtendedGamesLoadedBinderCallback(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void j(DataHolder dataHolder) {
            this.De.b(new LoadExtendedGamesResultImpl(dataHolder));
        }
    }

    private final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Events.LoadEventsResult> De;

        EventsLoadedBinderCallback(BaseImplementation.b<Events.LoadEventsResult> resultHolder) {
            this.De = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void d(DataHolder dataHolder) {
            this.De.b(new LoadEventResultImpl(dataHolder));
        }
    }

    private final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<GamesMetadata.LoadGamesResult> De;

        GamesLoadedBinderCallback(BaseImplementation.b<GamesMetadata.LoadGamesResult> holder) {
            this.De = o.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void i(DataHolder dataHolder) {
            this.De.b(new LoadGamesResultImpl(dataHolder));
        }
    }

    private final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Achievements.UpdateAchievementResult> De;

        AchievementUpdatedBinderCallback(BaseImplementation.b<Achievements.UpdateAchievementResult> resultHolder) {
            this.De = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void g(int n2, String string2) {
            this.De.b(new UpdateAchievementResultImpl(n2, string2));
        }
    }

    private final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Achievements.LoadAchievementsResult> De;

        AchievementsLoadedBinderCallback(BaseImplementation.b<Achievements.LoadAchievementsResult> resultHolder) {
            this.De = o.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void c(DataHolder dataHolder) {
            this.De.b(new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void q(String string2, int n2) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.gS()).n(string2, n2);
                } else {
                    GamesLog.q("GamesClientImpl", "Unable to increment event " + string2 + " by " + n2 + " because the games client is no longer connected");
                }
            }
            catch (RemoteException remoteException) {
                GamesLog.p("GamesClientImpl", "service died");
            }
        }
    }
}

