/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.internal.jv;

public final class EventEntity
implements SafeParcelable,
Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int BR;
    private final String Wm;
    private final String mName;
    private final String Tr;
    private final Uri Vh;
    private final String Vs;
    private final PlayerEntity Wh;
    private final long Wn;
    private final String Wo;
    private final boolean Wp;

    public EventEntity(Event event) {
        this.BR = 1;
        this.Wm = event.getEventId();
        this.mName = event.getName();
        this.Tr = event.getDescription();
        this.Vh = event.getIconImageUri();
        this.Vs = event.getIconImageUrl();
        this.Wh = (PlayerEntity)event.getPlayer().freeze();
        this.Wn = event.getValue();
        this.Wo = event.getFormattedValue();
        this.Wp = event.isVisible();
    }

    EventEntity(int versionCode, String eventId, String name, String description, Uri iconImageUri, String iconImageUrl, Player player, long value, String formattedValue, boolean isVisible) {
        this.BR = versionCode;
        this.Wm = eventId;
        this.mName = name;
        this.Tr = description;
        this.Vh = iconImageUri;
        this.Vs = iconImageUrl;
        this.Wh = new PlayerEntity(player);
        this.Wn = value;
        this.Wo = formattedValue;
        this.Wp = isVisible;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getEventId() {
        return this.Wm;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        jv.b(this.mName, dataOut);
    }

    @Override
    public String getDescription() {
        return this.Tr;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        jv.b(this.Tr, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.Vh;
    }

    @Override
    public String getIconImageUrl() {
        return this.Vs;
    }

    @Override
    public Player getPlayer() {
        return this.Wh;
    }

    @Override
    public long getValue() {
        return this.Wn;
    }

    @Override
    public String getFormattedValue() {
        return this.Wo;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer dataOut) {
        jv.b(this.Wo, dataOut);
    }

    @Override
    public boolean isVisible() {
        return this.Wp;
    }

    @Override
    public Event freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.a(this);
    }

    static int a(Event event) {
        return n.hashCode(event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible());
    }

    public boolean equals(Object obj) {
        return EventEntity.a(this, obj);
    }

    static boolean a(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return n.equal(event2.getEventId(), event.getEventId()) && n.equal(event2.getName(), event.getName()) && n.equal(event2.getDescription(), event.getDescription()) && n.equal(event2.getIconImageUri(), event.getIconImageUri()) && n.equal(event2.getIconImageUrl(), event.getIconImageUrl()) && n.equal(event2.getPlayer(), event.getPlayer()) && n.equal(event2.getValue(), event.getValue()) && n.equal(event2.getFormattedValue(), event.getFormattedValue()) && n.equal(event2.isVisible(), event.isVisible());
    }

    public String toString() {
        return EventEntity.b(this);
    }

    static String b(Event event) {
        return n.h(event).a("Id", event.getEventId()).a("Name", event.getName()).a("Description", event.getDescription()).a("IconImageUri", event.getIconImageUri()).a("IconImageUrl", event.getIconImageUrl()).a("Player", event.getPlayer()).a("Value", event.getValue()).a("FormattedValue", event.getFormattedValue()).a("isVisible", event.isVisible()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        EventEntityCreator.a(this, out, flags);
    }
}

