/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.a;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;
import com.google.android.gms.internal.jv;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int BR;
    private final String VK;
    private final String NH;
    private final Uri Vh;
    private final Uri Vi;
    private final long VL;
    private final int VM;
    private final long VN;
    private final String Vs;
    private final String Vt;
    private final String Nw;
    private final MostRecentGameInfoEntity VO;
    private final PlayerLevelInfo VP;
    private final boolean VQ;

    public PlayerEntity(Player player) {
        this.BR = 11;
        this.VK = player.getPlayerId();
        this.NH = player.getDisplayName();
        this.Vh = player.getIconImageUri();
        this.Vs = player.getIconImageUrl();
        this.Vi = player.getHiResImageUri();
        this.Vt = player.getHiResImageUrl();
        this.VL = player.getRetrievedTimestamp();
        this.VM = player.jU();
        this.VN = player.getLastPlayedWithTimestamp();
        this.Nw = player.getTitle();
        this.VQ = player.isProfileVisible();
        MostRecentGameInfo mostRecentGameInfo = player.jV();
        this.VO = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.VP = player.getLevelInfo();
        a.f(this.VK);
        a.f(this.NH);
        a.I(this.VL > 0L);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp, String iconImageUrl, String hiResImageUrl, String title, MostRecentGameInfoEntity mostRecentGameInfo, PlayerLevelInfo playerLevelInfo, boolean isProfileVisible) {
        this.BR = versionCode;
        this.VK = playerId;
        this.NH = displayName;
        this.Vh = iconImageUri;
        this.Vs = iconImageUrl;
        this.Vi = hiResImageUri;
        this.Vt = hiResImageUrl;
        this.VL = retrievedTimestamp;
        this.VM = isInCircles;
        this.VN = lastPlayedWithTimestamp;
        this.Nw = title;
        this.VQ = isProfileVisible;
        this.VO = mostRecentGameInfo;
        this.VP = playerLevelInfo;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getPlayerId() {
        return this.VK;
    }

    @Override
    public String getDisplayName() {
        return this.NH;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        jv.b(this.NH, dataOut);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.Vh;
    }

    @Override
    public String getIconImageUrl() {
        return this.Vs;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.Vi;
    }

    @Override
    public String getHiResImageUrl() {
        return this.Vt;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.VL;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.VN;
    }

    @Override
    public int jU() {
        return this.VM;
    }

    @Override
    public boolean isProfileVisible() {
        return this.VQ;
    }

    @Override
    public String getTitle() {
        return this.Nw;
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        jv.b(this.Nw, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.VP;
    }

    @Override
    public MostRecentGameInfo jV() {
        return this.VO;
    }

    @Override
    public Player freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.b(this);
    }

    static int b(Player player) {
        return n.hashCode(player.getPlayerId(), player.getDisplayName(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo());
    }

    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    static boolean a(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return n.equal(player2.getPlayerId(), player.getPlayerId()) && n.equal(player2.getDisplayName(), player.getDisplayName()) && n.equal(player2.getIconImageUri(), player.getIconImageUri()) && n.equal(player2.getHiResImageUri(), player.getHiResImageUri()) && n.equal(player2.getRetrievedTimestamp(), player.getRetrievedTimestamp()) && n.equal(player2.getTitle(), player.getTitle()) && n.equal(player2.getLevelInfo(), player.getLevelInfo());
    }

    public String toString() {
        return PlayerEntity.c(this);
    }

    static String c(Player player) {
        return n.h(player).a("PlayerId", player.getPlayerId()).a("DisplayName", player.getDisplayName()).a("IconImageUri", player.getIconImageUri()).a("IconImageUrl", player.getIconImageUrl()).a("HiResImageUri", player.getHiResImageUri()).a("HiResImageUrl", player.getHiResImageUrl()).a("RetrievedTimestamp", player.getRetrievedTimestamp()).a("Title", player.getTitle()).a("LevelInfo", player.getLevelInfo()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.gQ()) {
            PlayerEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.VK);
            dest.writeString(this.NH);
            dest.writeString(this.Vh == null ? null : this.Vh.toString());
            dest.writeString(this.Vi == null ? null : this.Vi.toString());
            dest.writeLong(this.VL);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity ce(Parcel parcel) {
            boolean bl2 = PlayerEntity.c(PlayerEntity.gP());
            if (bl2 || PlayerEntity.aV(PlayerEntity.class.getCanonicalName())) {
                return super.ce(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            long l2 = parcel.readLong();
            int n2 = -1;
            long l3 = -1L;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            PlayerLevelInfo playerLevelInfo = null;
            MostRecentGameInfoEntity mostRecentGameInfoEntity = null;
            boolean bl3 = true;
            return new PlayerEntity(11, string2, string3, uri, uri2, l2, n2, l3, string6, string7, string8, mostRecentGameInfoEntity, playerLevelInfo, bl3);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.ce(x0);
        }
    }
}

