/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.view.View;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.api.AchievementsImpl;
import com.google.android.gms.games.internal.api.AclsImpl;
import com.google.android.gms.games.internal.api.EventsImpl;
import com.google.android.gms.games.internal.api.GamesMetadataImpl;
import com.google.android.gms.games.internal.api.InvitationsImpl;
import com.google.android.gms.games.internal.api.LeaderboardsImpl;
import com.google.android.gms.games.internal.api.MultiplayerImpl;
import com.google.android.gms.games.internal.api.NotificationsImpl;
import com.google.android.gms.games.internal.api.PlayersImpl;
import com.google.android.gms.games.internal.api.QuestsImpl;
import com.google.android.gms.games.internal.api.RealTimeMultiplayerImpl;
import com.google.android.gms.games.internal.api.RequestsImpl;
import com.google.android.gms.games.internal.api.SnapshotsImpl;
import com.google.android.gms.games.internal.api.TurnBasedMultiplayerImpl;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshots;
import java.util.ArrayList;

public final class Games {
    public static final String EXTRA_PLAYER_IDS = "players";
    static final Api.c<GamesClientImpl> CU = new Api.c();
    private static final Api.b<GamesClientImpl, GamesOptions> CV = new Api.b<GamesClientImpl, GamesOptions>(){

        @Override
        public GamesClientImpl a(Context context, Looper looper, ClientSettings clientSettings, GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (gamesOptions == null) {
                gamesOptions = new GamesOptions();
            }
            return new GamesClientImpl(context, looper, clientSettings.getRealClientPackageName(), clientSettings.getAccountNameOrDefault(), connectionCallbacks, onConnectionFailedListener, clientSettings.getScopesArray(), clientSettings.getGravityForPopups(), clientSettings.getViewForPopups(), gamesOptions);
        }

        @Override
        public int getPriority() {
            return 1;
        }
    };
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final Api<GamesOptions> API = new Api<GamesOptions>(CV, CU, SCOPE_GAMES);
    public static final Scope Vz = new Scope("https://www.googleapis.com/auth/games.firstparty");
    public static final Api<GamesOptions> VA = new Api<GamesOptions>(CV, CU, Vz);
    public static final GamesMetadata GamesMetadata = new GamesMetadataImpl();
    public static final Achievements Achievements = new AchievementsImpl();
    public static final Events Events = new EventsImpl();
    public static final Leaderboards Leaderboards = new LeaderboardsImpl();
    public static final Invitations Invitations = new InvitationsImpl();
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new TurnBasedMultiplayerImpl();
    public static final RealTimeMultiplayer RealTimeMultiplayer = new RealTimeMultiplayerImpl();
    public static final Multiplayer VB = new MultiplayerImpl();
    public static final Players Players = new PlayersImpl();
    public static final Notifications Notifications = new NotificationsImpl();
    public static final Quests Quests = new QuestsImpl();
    public static final Requests Requests = new RequestsImpl();
    public static final Snapshots Snapshots = new SnapshotsImpl();
    public static final Acls VC = new AclsImpl();

    private Games() {
    }

    public static GamesClientImpl c(GoogleApiClient googleApiClient) {
        o.b(googleApiClient != null, (Object)"GoogleApiClient parameter is required.");
        o.a(googleApiClient.isConnected(), "GoogleApiClient must be connected.");
        return Games.d(googleApiClient);
    }

    public static GamesClientImpl d(GoogleApiClient googleApiClient) {
        GamesClientImpl gamesClientImpl = googleApiClient.a(CU);
        o.a(gamesClientImpl != null, "GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        return gamesClientImpl;
    }

    public static void setGravityForPopups(GoogleApiClient apiClient, int gravity) {
        Games.c(apiClient).dB(gravity);
    }

    public static void setViewForPopups(GoogleApiClient apiClient, View gamesContentView) {
        o.i(gamesContentView);
        Games.c(apiClient).k(gamesContentView);
    }

    public static String getCurrentAccountName(GoogleApiClient apiClient) {
        return Games.c(apiClient).ka();
    }

    public static String getAppId(GoogleApiClient apiClient) {
        return Games.c(apiClient).kp();
    }

    public static Intent getSettingsIntent(GoogleApiClient apiClient) {
        return Games.c(apiClient).kn();
    }

    public static PendingResult<Status> signOut(GoogleApiClient apiClient) {
        return apiClient.b(new SignOutImpl(){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.b(this);
            }
        });
    }

    public static int getSdkVariant(GoogleApiClient apiClient) {
        return Games.c(apiClient).ko();
    }

    private static abstract class SignOutImpl
    extends BaseGamesApiMethodImpl<Status> {
        private SignOutImpl() {
        }

        public Status d(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.d(status);
        }
    }

    public static abstract class BaseGamesApiMethodImpl<R extends Result>
    extends BaseImplementation.a<R, GamesClientImpl> {
        public BaseGamesApiMethodImpl() {
            super(CU);
        }
    }

    public static final class GamesOptions
    implements Api.ApiOptions.Optional {
        public final boolean VD;
        public final boolean VE;
        public final int VF;
        public final boolean VG;
        public final int VH;
        public final String VI;
        public final ArrayList<String> VJ;

        private GamesOptions() {
            this.VD = false;
            this.VE = true;
            this.VF = 17;
            this.VG = false;
            this.VH = 4368;
            this.VI = null;
            this.VJ = new ArrayList();
        }

        private GamesOptions(Builder builder) {
            this.VD = builder.VD;
            this.VE = builder.VE;
            this.VF = builder.VF;
            this.VG = builder.VG;
            this.VH = builder.VH;
            this.VI = builder.VI;
            this.VJ = builder.VJ;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            boolean VD = false;
            boolean VE = true;
            int VF = 17;
            boolean VG = false;
            int VH = 4368;
            String VI = null;
            ArrayList<String> VJ = new ArrayList();

            private Builder() {
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup) {
                this.VE = showConnectingPopup;
                this.VF = 17;
                return this;
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup, int gravity) {
                this.VE = showConnectingPopup;
                this.VF = gravity;
                return this;
            }

            public Builder setSdkVariant(int variant) {
                this.VH = variant;
                return this;
            }

            public GamesOptions build() {
                return new GamesOptions(this);
            }
        }
    }
}

