/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.jv;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int BR;
    private final String Ez;
    private final String NH;
    private final String Ve;
    private final String Vf;
    private final String Tr;
    private final String Vg;
    private final Uri Vh;
    private final Uri Vi;
    private final Uri Vj;
    private final boolean Vk;
    private final boolean Vl;
    private final String Vm;
    private final int Vn;
    private final int Vo;
    private final int Vp;
    private final boolean Vq;
    private final boolean Vr;
    private final String Vs;
    private final String Vt;
    private final String Vu;
    private final boolean Vv;
    private final boolean Vw;
    private final boolean Vx;
    private final String Vy;

    public GameEntity(Game game) {
        this.BR = 5;
        this.Ez = game.getApplicationId();
        this.Ve = game.getPrimaryCategory();
        this.Vf = game.getSecondaryCategory();
        this.Tr = game.getDescription();
        this.Vg = game.getDeveloperName();
        this.NH = game.getDisplayName();
        this.Vh = game.getIconImageUri();
        this.Vs = game.getIconImageUrl();
        this.Vi = game.getHiResImageUri();
        this.Vt = game.getHiResImageUrl();
        this.Vj = game.getFeaturedImageUri();
        this.Vu = game.getFeaturedImageUrl();
        this.Vk = game.jO();
        this.Vl = game.jQ();
        this.Vm = game.jR();
        this.Vn = game.jS();
        this.Vo = game.getAchievementTotalCount();
        this.Vp = game.getLeaderboardCount();
        this.Vq = game.isRealTimeMultiplayerEnabled();
        this.Vr = game.isTurnBasedMultiplayerEnabled();
        this.Vv = game.isMuted();
        this.Vw = game.jP();
        this.Vx = game.areSnapshotsEnabled();
        this.Vy = game.getThemeColor();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed, boolean snapshotsEnabled, String themeColor) {
        this.BR = versionCode;
        this.Ez = applicationId;
        this.NH = displayName;
        this.Ve = primaryCategory;
        this.Vf = secondaryCategory;
        this.Tr = description;
        this.Vg = developerName;
        this.Vh = iconImageUri;
        this.Vs = iconImageUrl;
        this.Vi = hiResImageUri;
        this.Vt = hiResImageUrl;
        this.Vj = featuredImageUri;
        this.Vu = featuredImageUrl;
        this.Vk = playEnabledGame;
        this.Vl = instanceInstalled;
        this.Vm = instancePackageName;
        this.Vn = gameplayAclStatus;
        this.Vo = achievementTotalCount;
        this.Vp = leaderboardCount;
        this.Vq = realTimeEnabled;
        this.Vr = turnBasedEnabled;
        this.Vv = muted;
        this.Vw = identitySharingConfirmed;
        this.Vx = snapshotsEnabled;
        this.Vy = themeColor;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getApplicationId() {
        return this.Ez;
    }

    @Override
    public String getDisplayName() {
        return this.NH;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        jv.b(this.NH, dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.Ve;
    }

    @Override
    public String getSecondaryCategory() {
        return this.Vf;
    }

    @Override
    public String getDescription() {
        return this.Tr;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        jv.b(this.Tr, dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.Vg;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        jv.b(this.Vg, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.Vh;
    }

    @Override
    public String getIconImageUrl() {
        return this.Vs;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.Vi;
    }

    @Override
    public String getHiResImageUrl() {
        return this.Vt;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.Vj;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.Vu;
    }

    @Override
    public boolean isMuted() {
        return this.Vv;
    }

    @Override
    public boolean jP() {
        return this.Vw;
    }

    @Override
    public boolean jO() {
        return this.Vk;
    }

    @Override
    public boolean jQ() {
        return this.Vl;
    }

    @Override
    public String jR() {
        return this.Vm;
    }

    @Override
    public int jS() {
        return this.Vn;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.Vo;
    }

    @Override
    public int getLeaderboardCount() {
        return this.Vp;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.Vq;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.Vr;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.Vx;
    }

    @Override
    public String getThemeColor() {
        return this.Vy;
    }

    @Override
    public Game freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.a(this);
    }

    static int a(Game game) {
        return n.hashCode(game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.jO(), game.jQ(), game.jR(), game.jS(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.jP(), game.areSnapshotsEnabled(), game.getThemeColor());
    }

    public boolean equals(Object obj) {
        return GameEntity.a(this, obj);
    }

    static boolean a(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return n.equal(game2.getApplicationId(), game.getApplicationId()) && n.equal(game2.getDisplayName(), game.getDisplayName()) && n.equal(game2.getPrimaryCategory(), game.getPrimaryCategory()) && n.equal(game2.getSecondaryCategory(), game.getSecondaryCategory()) && n.equal(game2.getDescription(), game.getDescription()) && n.equal(game2.getDeveloperName(), game.getDeveloperName()) && n.equal(game2.getIconImageUri(), game.getIconImageUri()) && n.equal(game2.getHiResImageUri(), game.getHiResImageUri()) && n.equal(game2.getFeaturedImageUri(), game.getFeaturedImageUri()) && n.equal(game2.jO(), game.jO()) && n.equal(game2.jQ(), game.jQ()) && n.equal(game2.jR(), game.jR()) && n.equal(game2.jS(), game.jS()) && n.equal(game2.getAchievementTotalCount(), game.getAchievementTotalCount()) && n.equal(game2.getLeaderboardCount(), game.getLeaderboardCount()) && n.equal(game2.isRealTimeMultiplayerEnabled(), game.isRealTimeMultiplayerEnabled()) && n.equal(game2.isTurnBasedMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled() && n.equal(game2.isMuted(), game.isMuted()) && n.equal(game2.jP(), game.jP())) && n.equal(game2.areSnapshotsEnabled(), game.areSnapshotsEnabled()) && n.equal(game2.getThemeColor(), game.getThemeColor());
    }

    public String toString() {
        return GameEntity.b(this);
    }

    static String b(Game game) {
        return n.h(game).a("ApplicationId", game.getApplicationId()).a("DisplayName", game.getDisplayName()).a("PrimaryCategory", game.getPrimaryCategory()).a("SecondaryCategory", game.getSecondaryCategory()).a("Description", game.getDescription()).a("DeveloperName", game.getDeveloperName()).a("IconImageUri", game.getIconImageUri()).a("IconImageUrl", game.getIconImageUrl()).a("HiResImageUri", game.getHiResImageUri()).a("HiResImageUrl", game.getHiResImageUrl()).a("FeaturedImageUri", game.getFeaturedImageUri()).a("FeaturedImageUrl", game.getFeaturedImageUrl()).a("PlayEnabledGame", game.jO()).a("InstanceInstalled", game.jQ()).a("InstancePackageName", game.jR()).a("AchievementTotalCount", game.getAchievementTotalCount()).a("LeaderboardCount", game.getLeaderboardCount()).a("RealTimeMultiplayerEnabled", game.isRealTimeMultiplayerEnabled()).a("TurnBasedMultiplayerEnabled", game.isTurnBasedMultiplayerEnabled()).a("AreSnapshotsEnabled", game.areSnapshotsEnabled()).a("ThemeColor", game.getThemeColor()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.gQ()) {
            GameEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.Ez);
            dest.writeString(this.NH);
            dest.writeString(this.Ve);
            dest.writeString(this.Vf);
            dest.writeString(this.Tr);
            dest.writeString(this.Vg);
            dest.writeString(this.Vh == null ? null : this.Vh.toString());
            dest.writeString(this.Vi == null ? null : this.Vi.toString());
            dest.writeString(this.Vj == null ? null : this.Vj.toString());
            dest.writeInt(this.Vk ? 1 : 0);
            dest.writeInt(this.Vl ? 1 : 0);
            dest.writeString(this.Vm);
            dest.writeInt(this.Vn);
            dest.writeInt(this.Vo);
            dest.writeInt(this.Vp);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity cd(Parcel parcel) {
            boolean bl2 = GameEntity.c(GameEntity.gP());
            if (bl2 || GameEntity.aV(GameEntity.class.getCanonicalName())) {
                return super.cd(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            String string8 = parcel.readString();
            Uri uri = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri2 = string9 == null ? null : Uri.parse((String)string9);
            String string10 = parcel.readString();
            Uri uri3 = string10 == null ? null : Uri.parse((String)string10);
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            String string11 = parcel.readString();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            boolean bl5 = false;
            boolean bl6 = false;
            String string12 = null;
            String string13 = null;
            String string14 = null;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            String string15 = null;
            return new GameEntity(5, string2, string3, string4, string5, string6, string7, uri, uri2, uri3, bl3, bl4, string11, n2, n3, n4, bl5, bl6, string12, string13, string14, bl7, bl8, bl9, string15);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cd(x0);
        }
    }
}

