/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.b;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
implements Result,
SafeParcelable {
    private final int BR;
    private final List<DataSet> SD;
    private final Status CM;
    private final List<Bucket> UV;
    private int UW;
    private final List<DataSource> SN;
    private final List<DataType> UX;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new b();

    DataReadResult(int versionCode, List<RawDataSet> dataSets, Status status, List<RawBucket> buckets, int batchCount, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.BR = versionCode;
        this.CM = status;
        this.UW = batchCount;
        this.SN = uniqueDataSources;
        this.UX = uniqueDataTypes;
        this.SD = new ArrayList<DataSet>(dataSets.size());
        for (RawDataSet safeParcelable : dataSets) {
            this.SD.add(new DataSet(safeParcelable, uniqueDataSources, uniqueDataTypes));
        }
        this.UV = new ArrayList<Bucket>(buckets.size());
        for (RawBucket rawBucket : buckets) {
            this.UV.add(new Bucket(rawBucket, uniqueDataSources, uniqueDataTypes));
        }
    }

    public DataReadResult(List<DataSet> dataSets, List<Bucket> buckets, Status status) {
        this.BR = 5;
        this.SD = dataSets;
        this.CM = status;
        this.UV = buckets;
        this.UW = 1;
        this.SN = new ArrayList<DataSource>();
        this.UX = new ArrayList<DataType>();
    }

    public static DataReadResult a(Status status, DataReadRequest dataReadRequest) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource safeParcelable : dataReadRequest.getDataSources()) {
            arrayList.add(DataSet.create(safeParcelable));
        }
        for (DataType dataType : dataReadRequest.getDataTypes()) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.SD) {
            if (!dataType.equals(dataSet.getDataType())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataType.getName()));
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.SD) {
            if (!dataSource.equals(dataSet.getDataSource())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataSource.getStreamIdentifier()));
    }

    public List<DataSet> getDataSets() {
        return this.SD;
    }

    public List<Bucket> getBuckets() {
        return this.UV;
    }

    public int jH() {
        return this.UW;
    }

    public void b(DataReadResult dataReadResult) {
        for (DataSet safeParcelable : dataReadResult.getDataSets()) {
            this.a(safeParcelable, this.SD);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.a(bucket, this.UV);
        }
    }

    private void a(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals(dataSet.getDataSource())) continue;
            dataSet2.a(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void a(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.b(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.a(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.UV.add(bucket);
    }

    @Override
    public Status getStatus() {
        return this.CM;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadResult && this.c((DataReadResult)that);
    }

    private boolean c(DataReadResult dataReadResult) {
        return this.CM.equals(dataReadResult.CM) && n.equal(this.SD, dataReadResult.SD) && n.equal(this.UV, dataReadResult.UV);
    }

    public int hashCode() {
        return n.hashCode(this.CM, this.SD, this.UV);
    }

    public String toString() {
        return n.h(this).a("status", this.CM).a("dataSets", this.SD.size() > 5 ? this.SD.size() + " data sets" : this.SD).a("buckets", this.UV.size() > 5 ? this.UV.size() + " buckets" : this.UV).toString();
    }

    int getVersionCode() {
        return this.BR;
    }

    List<RawBucket> jI() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.UV.size());
        for (Bucket bucket : this.UV) {
            arrayList.add(new RawBucket(bucket, this.SN, this.UX));
        }
        return arrayList;
    }

    List<RawDataSet> jJ() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.SD.size());
        for (DataSet dataSet : this.SD) {
            arrayList.add(new RawDataSet(dataSet, this.SN, this.UX));
        }
        return arrayList;
    }

    List<DataSource> iL() {
        return this.SN;
    }

    List<DataType> jK() {
        return this.UX;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        b.a(this, dest, flags);
    }
}

