/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.g;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
implements SafeParcelable {
    public static final int NO_LIMIT = 0;
    private final int BR;
    private final List<DataType> SB;
    private final List<DataSource> Uk;
    private final long KS;
    private final long Sr;
    private final List<DataType> Uo;
    private final List<DataSource> Up;
    private final int SE;
    private final long Uq;
    private final DataSource Ur;
    private final int Us;
    private final boolean Ut;
    private final boolean Uu;
    private final boolean Uv;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new g();

    DataReadRequest(int versionCode, List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean disableTransformations, boolean flushBeforeRead, boolean serverQueriesEnabled) {
        this.BR = versionCode;
        this.SB = Collections.unmodifiableList(dataTypes);
        this.Uk = Collections.unmodifiableList(dataSources);
        this.KS = startTimeMillis;
        this.Sr = endTimeMillis;
        this.Uo = Collections.unmodifiableList(aggregatedDataTypes);
        this.Up = Collections.unmodifiableList(aggregatedDataSources);
        this.SE = bucketType;
        this.Uq = bucketDurationMillis;
        this.Ur = activityDataSource;
        this.Us = limit;
        this.Ut = disableTransformations;
        this.Uu = flushBeforeRead;
        this.Uv = serverQueriesEnabled;
    }

    private DataReadRequest(Builder builder) {
        this.BR = 2;
        this.SB = Collections.unmodifiableList(builder.SB);
        this.Uk = Collections.unmodifiableList(builder.Uk);
        this.KS = builder.KS;
        this.Sr = builder.Sr;
        this.Uo = Collections.unmodifiableList(builder.Uo);
        this.Up = Collections.unmodifiableList(builder.Up);
        this.SE = builder.SE;
        this.Uq = builder.Uq;
        this.Ur = builder.Ur;
        this.Us = builder.Us;
        this.Ut = builder.Ut;
        this.Uu = builder.Uu;
        this.Uv = builder.Uv;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.KS, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.Sr, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.SB;
    }

    public List<DataSource> getDataSources() {
        return this.Uk;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.Uo;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.Up;
    }

    public int getBucketType() {
        return this.SE;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.Uq, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.Ur;
    }

    public int getLimit() {
        return this.Us;
    }

    public boolean jk() {
        return this.Ut;
    }

    public boolean jl() {
        return this.Uv;
    }

    public boolean jm() {
        return this.Uu;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadRequest && this.a((DataReadRequest)that);
    }

    private boolean a(DataReadRequest dataReadRequest) {
        return this.SB.equals(dataReadRequest.SB) && this.Uk.equals(dataReadRequest.Uk) && this.KS == dataReadRequest.KS && this.Sr == dataReadRequest.Sr && this.SE == dataReadRequest.SE && this.Up.equals(dataReadRequest.Up) && this.Uo.equals(dataReadRequest.Uo) && n.equal(this.Ur, dataReadRequest.Ur) && this.Uq == dataReadRequest.Uq && this.Uv == dataReadRequest.Uv;
    }

    public int hashCode() {
        return n.hashCode(this.SE, this.KS, this.Sr);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.SB.isEmpty()) {
            for (DataType safeParcelable : this.SB) {
                stringBuilder.append(safeParcelable.iQ()).append(" ");
            }
        }
        if (!this.Uk.isEmpty()) {
            for (DataSource dataSource : this.Uk) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.SE != 0) {
            stringBuilder.append("bucket by ").append(Bucket.cy(this.SE));
            if (this.Uq > 0L) {
                stringBuilder.append(" >").append(this.Uq).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.Uo.isEmpty()) {
            for (DataType dataType : this.Uo) {
                stringBuilder.append(dataType.iQ()).append(" ");
            }
        }
        if (!this.Up.isEmpty()) {
            for (DataSource dataSource : this.Up) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.KS, this.KS, this.Sr, this.Sr));
        if (this.Ur != null) {
            stringBuilder.append("activities: ").append(this.Ur.toDebugString());
        }
        if (this.Uv) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.BR;
    }

    public long iE() {
        return this.Sr;
    }

    public long iD() {
        return this.KS;
    }

    public long jn() {
        return this.Uq;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        g.a(this, dest, flags);
    }

    public static class Builder {
        private List<DataType> SB = new ArrayList<DataType>();
        private List<DataSource> Uk = new ArrayList<DataSource>();
        private List<DataType> Uo = new ArrayList<DataType>();
        private List<DataSource> Up = new ArrayList<DataSource>();
        private DataSource Ur;
        private long KS;
        private long Sr;
        private int SE = 0;
        private long Uq = 0L;
        private int Us = 0;
        private boolean Ut = false;
        private boolean Uu = false;
        private boolean Uv = false;

        public Builder read(DataSource dataSource) {
            o.b(dataSource, (Object)"Attempting to add a null data source");
            o.b(!this.Up.contains(dataSource), (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.Uk.contains(dataSource)) {
                this.Uk.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            o.b(dataType, (Object)"Attempting to use a null data type");
            o.a(!this.Uo.contains(dataType), "Cannot add the same data type as aggregated and detailed");
            if (!this.SB.contains(dataType)) {
                this.SB.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType outputDataType) {
            o.b(dataSource, (Object)"Attempting to add a null data source");
            o.a(!this.Uk.contains(dataSource), "Cannot add the same data source for aggregated and detailed");
            DataType dataType = dataSource.getDataType();
            o.b(DataType.AGGREGATE_INPUT_TYPES.contains(dataType), "Unsupported input data type specified for aggregation: %s", dataType);
            o.b(DataType.getAggregatesForInput(dataType).contains(outputDataType), "Invalid output aggregate data type specified: %s -> %s", dataType, outputDataType);
            if (!this.Up.contains(dataSource)) {
                this.Up.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType inputDataType, DataType outputDataType) {
            o.b(inputDataType, (Object)"Attempting to use a null data type");
            o.a(!this.SB.contains(inputDataType), "Cannot add the same data type as aggregated and detailed");
            o.b(DataType.AGGREGATE_INPUT_TYPES.contains(inputDataType), "Unsupported input data type specified for aggregation: %s", inputDataType);
            o.b(DataType.getAggregatesForInput(inputDataType).contains(outputDataType), "Invalid output aggregate data type specified: %s -> %s", inputDataType, outputDataType);
            if (!this.Uo.contains(inputDataType)) {
                this.Uo.add(inputDataType);
            }
            return this;
        }

        public Builder bucketByTime(int duration, TimeUnit timeUnit) {
            o.b(this.SE == 0, "Bucketing strategy already set to %s", this.SE);
            o.b(duration > 0, "Must specify a valid minimum duration for an activity segment: %d", duration);
            this.SE = 1;
            this.Uq = timeUnit.toMillis(duration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit) {
            o.b(this.SE == 0, "Bucketing strategy already set to %s", this.SE);
            o.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            this.SE = 3;
            this.Uq = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            o.b(this.SE == 0, "Bucketing strategy already set to %s", this.SE);
            o.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            o.b(activityDataSource != null, (Object)"Invalid activity data source specified");
            o.b(activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), "Invalid activity data source specified: %s", activityDataSource);
            this.Ur = activityDataSource;
            this.SE = 3;
            this.Uq = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit) {
            o.b(this.SE == 0, "Bucketing strategy already set to %s", this.SE);
            o.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            this.SE = 4;
            this.Uq = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            o.b(this.SE == 0, "Bucketing strategy already set to %s", this.SE);
            o.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            o.b(activityDataSource != null, (Object)"Invalid activity data source specified");
            o.b(activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), "Invalid activity data source specified: %s", activityDataSource);
            this.Ur = activityDataSource;
            this.SE = 4;
            this.Uq = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketBySession(int minDuration, TimeUnit timeUnit) {
            o.b(this.SE == 0, "Bucketing strategy already set to %s", this.SE);
            o.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            this.SE = 2;
            this.Uq = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder setTimeRange(long start, long end, TimeUnit timeUnit) {
            this.KS = timeUnit.toMillis(start);
            this.Sr = timeUnit.toMillis(end);
            return this;
        }

        public Builder enableServerQueries() {
            this.Uv = true;
            return this;
        }

        public Builder setLimit(int limit) {
            o.b(limit > 0, "Invalid limit %d is specified", limit);
            this.Us = limit;
            return this;
        }

        public DataReadRequest build() {
            o.a(!this.Uk.isEmpty() || !this.SB.isEmpty() || !this.Up.isEmpty() || !this.Uo.isEmpty(), "Must add at least one data source (aggregated or detailed)");
            o.a(this.KS > 0L, "Invalid start time: %s", this.KS);
            o.a(this.Sr > 0L && this.Sr > this.KS, "Invalid end time: %s", this.Sr);
            boolean bl2 = this.Up.isEmpty() && this.Uo.isEmpty();
            o.a(bl2 && this.SE == 0 || !bl2 && this.SE != 0, "Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }
    }
}

