/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
implements SafeParcelable {
    private final int BR;
    private final long KS;
    private final long Sr;
    private final List<DataSource> Uk;
    private final List<DataType> SB;
    private final List<Session> Ul;
    private final boolean Um;
    private final boolean Un;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new d();

    DataDeleteRequest(int versionCode, long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions) {
        this.BR = versionCode;
        this.KS = startTimeMillis;
        this.Sr = endTimeMillis;
        this.Uk = Collections.unmodifiableList(dataSources);
        this.SB = Collections.unmodifiableList(dataTypes);
        this.Ul = sessions;
        this.Um = deleteAllData;
        this.Un = deleteAllSessions;
    }

    private DataDeleteRequest(Builder builder) {
        this.BR = 1;
        this.KS = builder.KS;
        this.Sr = builder.Sr;
        this.Uk = Collections.unmodifiableList(builder.Uk);
        this.SB = Collections.unmodifiableList(builder.SB);
        this.Ul = Collections.unmodifiableList(builder.Ul);
        this.Um = builder.Um;
        this.Un = builder.Un;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.KS, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.Sr, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.Uk;
    }

    public List<DataType> getDataTypes() {
        return this.SB;
    }

    public List<Session> getSessions() {
        return this.Ul;
    }

    public boolean deleteAllData() {
        return this.Um;
    }

    public boolean deleteAllSessions() {
        return this.Un;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataDeleteRequest && this.a((DataDeleteRequest)o2);
    }

    private boolean a(DataDeleteRequest dataDeleteRequest) {
        return this.KS == dataDeleteRequest.KS && this.Sr == dataDeleteRequest.Sr && n.equal(this.Uk, dataDeleteRequest.Uk) && n.equal(this.SB, dataDeleteRequest.SB) && n.equal(this.Ul, dataDeleteRequest.Ul) && this.Um == dataDeleteRequest.Um && this.Un == dataDeleteRequest.Un;
    }

    public int hashCode() {
        return n.hashCode(this.KS, this.Sr);
    }

    public String toString() {
        return n.h(this).a("startTimeMillis", this.KS).a("endTimeMillis", this.Sr).a("dataSources", this.Uk).a("dateTypes", this.SB).a("sessions", this.Ul).a("deleteAllData", this.Um).a("deleteAllSessions", this.Un).toString();
    }

    int getVersionCode() {
        return this.BR;
    }

    public boolean jg() {
        return this.Um;
    }

    public boolean jh() {
        return this.Un;
    }

    public long iE() {
        return this.Sr;
    }

    public long iD() {
        return this.KS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        d.a(this, dest, flags);
    }

    public static class Builder {
        private long KS;
        private long Sr;
        private List<DataSource> Uk = new ArrayList<DataSource>();
        private List<DataType> SB = new ArrayList<DataType>();
        private List<Session> Ul = new ArrayList<Session>();
        private boolean Um = false;
        private boolean Un = false;

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            o.b(startTime > 0L, "Invalid start time :%d", startTime);
            o.b(endTime > startTime, "Invalid end time :%d", endTime);
            this.KS = timeUnit.toMillis(startTime);
            this.Sr = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder deleteAllData() {
            o.b(this.SB.isEmpty() && this.Uk.isEmpty(), "Specific data source/type already specified for deletion. DataSources: %s DataTypes: %s", this.Uk, this.SB);
            this.Um = true;
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            o.b(!this.Um, (Object)"All data is already marked for deletion");
            o.b(dataSource != null, (Object)"Must specify a valid data source");
            if (!this.Uk.contains(dataSource)) {
                this.Uk.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            o.b(!this.Un, (Object)"All sessions already marked for deletion");
            o.b(session != null, (Object)"Must specify a valid session");
            o.b(session.getEndTime(TimeUnit.MILLISECONDS) > 0L, (Object)"Must specify a session that has already ended");
            this.Ul.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            o.b(this.Ul.isEmpty(), "Specific sessions already added for deletion: %s", this.Ul);
            this.Un = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            o.b(!this.Um, (Object)"All data is already marked for deletion");
            o.b(dataType != null, (Object)"Must specify a valid data type");
            if (!this.SB.contains(dataType)) {
                this.SB.add(dataType);
            }
            return this;
        }

        public DataDeleteRequest build() {
            o.a(this.KS > 0L && this.Sr > this.KS, "Must specify a valid time interval");
            boolean bl2 = this.Um || !this.Uk.isEmpty() || !this.SB.isEmpty();
            boolean bl3 = this.Un || !this.Ul.isEmpty();
            o.a(bl2 || bl3, "No data or session marked for deletion");
            this.ji();
            return new DataDeleteRequest(this);
        }

        private void ji() {
            if (this.Ul.isEmpty()) {
                return;
            }
            for (Session session : this.Ul) {
                o.a(session.getStartTime(TimeUnit.MILLISECONDS) >= this.KS && session.getEndTime(TimeUnit.MILLISECONDS) <= this.Sr, "Session %s is outside the time interval [%d, %d]", session, this.KS, this.Sr);
            }
        }
    }
}

