/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.u;

public final class Value
implements SafeParcelable {
    private final int BR;
    private final int Th;
    private boolean Tv;
    private float Tw;
    public static final Parcelable.Creator<Value> CREATOR = new u();

    Value(int format) {
        this(1, format, false, 0.0f);
    }

    Value(int versionCode, int format, boolean isSet, float value) {
        this.BR = versionCode;
        this.Th = format;
        this.Tv = isSet;
        this.Tw = value;
    }

    public void setInt(int value) {
        o.a(this.Th == 1, "Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.Tv = true;
        this.Tw = Float.intBitsToFloat(value);
    }

    public void setFloat(float value) {
        o.a(this.Th == 2, "Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.Tv = true;
        this.Tw = value;
    }

    public boolean isSet() {
        return this.Tv;
    }

    public int getFormat() {
        return this.Th;
    }

    public int asInt() {
        o.a(this.Th == 1, "Value is not in int format");
        return Float.floatToRawIntBits(this.Tw);
    }

    public float asFloat() {
        o.a(this.Th == 2, "Value is not in float format");
        return this.Tw;
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof Value && this.a((Value)o2);
    }

    private boolean a(Value value) {
        if (this.Th == value.Th && this.Tv == value.Tv) {
            switch (this.Th) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.asFloat() == value.asFloat();
                }
            }
            return this.Tw == value.Tw;
        }
        return false;
    }

    public int hashCode() {
        return n.hashCode(Float.valueOf(this.Tw), this.Th, this.Tv);
    }

    public String toString() {
        if (!this.Tv) {
            return "unset";
        }
        switch (this.Th) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.asFloat());
            }
        }
        return "unknown";
    }

    int getVersionCode() {
        return this.BR;
    }

    float ja() {
        return this.Tw;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        u.a(this, dest, flags);
    }
}

