/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.n;
import com.google.android.gms.fitness.data.t;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RawDataPoint
implements SafeParcelable {
    final int BR;
    final long SG;
    final long SH;
    final Value[] SI;
    final int Tm;
    final int Tn;
    final long SK;
    final long SL;
    public static final Parcelable.Creator<RawDataPoint> CREATOR = new n();

    RawDataPoint(int versionCode, long timestampNanos, long startTimeNanos, Value[] values, int dataSourceIndex, int originalDataSourceIndex, long rawTimestamp, long insertionTimeMillis) {
        this.BR = versionCode;
        this.SG = timestampNanos;
        this.SH = startTimeNanos;
        this.Tm = dataSourceIndex;
        this.Tn = originalDataSourceIndex;
        this.SK = rawTimestamp;
        this.SL = insertionTimeMillis;
        this.SI = values;
    }

    RawDataPoint(DataPoint dataPoint, List<DataSource> dataSources) {
        this.BR = 4;
        this.SG = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
        this.SH = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
        this.SI = dataPoint.iG();
        this.Tm = t.a(dataPoint.getDataSource(), dataSources);
        this.Tn = t.a(dataPoint.getOriginalDataSource(), dataSources);
        this.SK = dataPoint.iH();
        this.SL = dataPoint.iI();
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof RawDataPoint && this.a((RawDataPoint)o2);
    }

    private boolean a(RawDataPoint rawDataPoint) {
        return this.SG == rawDataPoint.SG && this.SH == rawDataPoint.SH && Arrays.equals(this.SI, rawDataPoint.SI) && this.Tm == rawDataPoint.Tm && this.Tn == rawDataPoint.Tn && this.SK == rawDataPoint.SK;
    }

    public int hashCode() {
        return com.google.android.gms.common.internal.n.hashCode(this.SG, this.SH);
    }

    public String toString() {
        return String.format("RawDataPoint{%s@[%s, %s](%d,%d)}", Arrays.toString(this.SI), this.SH, this.SG, this.Tm, this.Tn);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        n.a(this, parcel, flags);
    }
}

