/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.m;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RawBucket
implements SafeParcelable {
    final int BR;
    final long KS;
    final long Sr;
    final Session St;
    final int Tl;
    final List<RawDataSet> SD;
    final int SE;
    final boolean SF;
    public static final Parcelable.Creator<RawBucket> CREATOR = new m();

    RawBucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activity, List<RawDataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.BR = versionCode;
        this.KS = startTimeMillis;
        this.Sr = endTimeMillis;
        this.St = session;
        this.Tl = activity;
        this.SD = dataSets;
        this.SE = bucketType;
        this.SF = serverHasMoreData;
    }

    public RawBucket(Bucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.BR = 2;
        this.KS = bucket.getStartTime(TimeUnit.MILLISECONDS);
        this.Sr = bucket.getEndTime(TimeUnit.MILLISECONDS);
        this.St = bucket.getSession();
        this.Tl = bucket.iB();
        this.SE = bucket.getBucketType();
        this.SF = bucket.iC();
        List<DataSet> list = bucket.getDataSets();
        this.SD = new ArrayList<RawDataSet>(list.size());
        for (DataSet dataSet : list) {
            this.SD.add(new RawDataSet(dataSet, uniqueDataSources, uniqueDataTypes));
        }
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof RawBucket && this.a((RawBucket)o2);
    }

    private boolean a(RawBucket rawBucket) {
        return this.KS == rawBucket.KS && this.Sr == rawBucket.Sr && this.Tl == rawBucket.Tl && n.equal(this.SD, rawBucket.SD) && this.SE == rawBucket.SE && this.SF == rawBucket.SF;
    }

    public int hashCode() {
        return n.hashCode(this.KS, this.Sr, this.SE);
    }

    public String toString() {
        return n.h(this).a("startTime", this.KS).a("endTime", this.Sr).a("activity", this.Tl).a("dataSets", this.SD).a("bucketType", this.SE).a("serverHasMoreData", this.SF).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        m.a(this, parcel, flags);
    }
}

