/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.e;
import com.google.android.gms.internal.kj;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
implements SafeParcelable {
    private final int BR;
    private final DataSource Sq;
    private long SG;
    private long SH;
    private final Value[] SI;
    private DataSource SJ;
    private long SK;
    private long SL;
    public static final Parcelable.Creator<DataPoint> CREATOR = new e();

    DataPoint(int versionCode, DataSource dataSource, long timestampNanos, long startTimeNanos, Value[] values, DataSource originalDataSource, long rawTimestamp, long insertionTimeMillis) {
        this.BR = versionCode;
        this.Sq = dataSource;
        this.SJ = originalDataSource;
        this.SG = timestampNanos;
        this.SH = startTimeNanos;
        this.SI = values;
        this.SK = rawTimestamp;
        this.SL = insertionTimeMillis;
    }

    DataPoint(List<DataSource> dataSources, RawDataPoint rawDataPoint) {
        this(4, DataPoint.a(dataSources, rawDataPoint.Tm), rawDataPoint.SG, rawDataPoint.SH, rawDataPoint.SI, DataPoint.a(dataSources, rawDataPoint.Tn), rawDataPoint.SK, rawDataPoint.SL);
    }

    private static DataSource a(List<DataSource> list, int n2) {
        return n2 >= 0 && n2 < list.size() ? list.get(n2) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.BR = 4;
        this.Sq = o.b(dataSource, (Object)"Data source cannot be null");
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.SI = new Value[list.size()];
        int n2 = 0;
        for (Field field : list) {
            this.SI[n2] = new Value(field.getFormat());
            ++n2;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return c.a(intent, "com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestamp(long timestamp, TimeUnit timeUnit) {
        this.SG = timeUnit.toNanos(timestamp);
        if (this.iF() && kj.a(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.SG = kj.a(this.SG, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    private boolean iF() {
        return this.getDataType() == DataType.TYPE_LOCATION_SAMPLE;
    }

    public DataPoint setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
        this.SH = timeUnit.toNanos(startTime);
        this.SG = timeUnit.toNanos(endTime);
        return this;
    }

    public Value getValue(Field field) {
        int n2 = this.getDataType().indexOf(field);
        return this.SI[n2];
    }

    public Value[] iG() {
        return this.SI;
    }

    public DataPoint setFloatValues(float ... values) {
        this.cA(values.length);
        for (int i2 = 0; i2 < values.length; ++i2) {
            this.SI[i2].setFloat(values[i2]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... values) {
        this.cA(values.length);
        for (int i2 = 0; i2 < values.length; ++i2) {
            this.SI[i2].setInt(values[i2]);
        }
        return this;
    }

    private void cA(int n2) {
        List<Field> list = this.getDataType().getFields();
        int n3 = list.size();
        o.b(n2 == n3, "Attempting to insert %s values, but needed %s: %s", n2, n3, list);
    }

    public DataType getDataType() {
        return this.Sq.getDataType();
    }

    public DataSource getDataSource() {
        return this.Sq;
    }

    public DataSource getOriginalDataSource() {
        return this.SJ;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.SG, TimeUnit.NANOSECONDS);
    }

    public long iH() {
        return this.SK;
    }

    public long iI() {
        return this.SL;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.SH, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.SG, TimeUnit.NANOSECONDS);
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof DataPoint && this.a((DataPoint)o2);
    }

    private boolean a(DataPoint dataPoint) {
        return n.equal(this.Sq, dataPoint.Sq) && this.SG == dataPoint.SG && this.SH == dataPoint.SH && Arrays.equals(this.SI, dataPoint.SI) && n.equal(this.SJ, dataPoint.SJ);
    }

    public int hashCode() {
        return n.hashCode(this.Sq, this.SG, this.SH);
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString(this.SI), this.SH, this.SG, this.SK, this.SL, this.Sq, this.SJ);
    }

    public int getVersionCode() {
        return this.BR;
    }

    public long getTimestampNanos() {
        return this.SG;
    }

    public long iJ() {
        return this.SH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        e.a(this, parcel, flags);
    }
}

