/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.query;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.SortOrder;
import com.google.android.gms.drive.query.a;
import com.google.android.gms.drive.query.internal.LogicalFilter;
import com.google.android.gms.drive.query.internal.MatchAllFilter;
import com.google.android.gms.drive.query.internal.Operator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Query
implements SafeParcelable {
    public static final Parcelable.Creator<Query> CREATOR = new a();
    final LogicalFilter QB;
    final String QC;
    final SortOrder QD;
    final List<String> QE;
    final int BR;

    Query(LogicalFilter clause, String pageToken, SortOrder sortOrder, List<String> requestedMetadataFields) {
        this(1, clause, pageToken, sortOrder, requestedMetadataFields);
    }

    Query(int versionCode, LogicalFilter clause, String pageToken, SortOrder sortOrder, List<String> requestedMetadataFields) {
        this.BR = versionCode;
        this.QB = clause;
        this.QC = pageToken;
        this.QD = sortOrder;
        this.QE = requestedMetadataFields;
    }

    public Filter getFilter() {
        return this.QB;
    }

    public String getPageToken() {
        return this.QC;
    }

    public SortOrder getSortOrder() {
        return this.QD;
    }

    public List<String> iq() {
        return this.QE;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        a.a(this, out, flags);
    }

    public String toString() {
        return String.format(Locale.US, "Query[%s,%s,PageToken=%s]", this.QB, this.QD, this.QC);
    }

    public static class Builder {
        private final List<Filter> QF = new ArrayList<Filter>();
        private String QC;
        private SortOrder QD;
        private List<String> QE;

        public Builder() {
        }

        public Builder(Query query) {
            this.QF.add(query.getFilter());
            this.QC = query.getPageToken();
            this.QD = query.getSortOrder();
            this.QE = query.iq();
        }

        public Builder addFilter(Filter filter) {
            if (!(filter instanceof MatchAllFilter)) {
                this.QF.add(filter);
            }
            return this;
        }

        public Builder setSortOrder(SortOrder sortOrder) {
            this.QD = sortOrder;
            return this;
        }

        public Builder setPageToken(String token) {
            this.QC = token;
            return this;
        }

        public Query build() {
            return new Query(new LogicalFilter(Operator.Re, this.QF), this.QC, this.QD, this.QE);
        }
    }
}

