/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.e;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.c;
import com.google.android.gms.drive.events.d;
import com.google.android.gms.drive.internal.AddEventListenerRequest;
import com.google.android.gms.drive.internal.DisconnectRequest;
import com.google.android.gms.drive.internal.RemoveEventListenerRequest;
import com.google.android.gms.drive.internal.ab;
import com.google.android.gms.drive.internal.ac;
import com.google.android.gms.drive.internal.ad;
import com.google.android.gms.drive.internal.bb;
import com.google.android.gms.drive.internal.o;
import com.google.android.gms.drive.internal.p;
import com.google.android.gms.drive.internal.y;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class q
extends e<ab> {
    private final String Dd;
    private final String IM;
    private final Bundle OA;
    private final boolean OB;
    private DriveId OC;
    private DriveId OD;
    final GoogleApiClient.ConnectionCallbacks OE;
    final Map<DriveId, Map<c, y>> OF = new HashMap<DriveId, Map<c, y>>();

    public q(Context context, Looper looper, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String[] stringArray, Bundle bundle) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, stringArray);
        this.Dd = o.b(clientSettings.getAccountNameOrDefault(), (Object)"Must call Api.ClientBuilder.setAccountName()");
        this.IM = clientSettings.getRealClientPackageName();
        this.OE = connectionCallbacks;
        this.OA = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.OB = false;
                break;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    throw new IllegalStateException("Drive event service " + serviceInfo.name + " must be exported in AndroidManifest.xml");
                }
                this.OB = true;
                break;
            }
            default: {
                throw new IllegalStateException("AndroidManifest.xml can only define one service that handles the " + intent.getAction() + " action");
            }
        }
    }

    protected ab T(IBinder iBinder) {
        return ab.a.U(iBinder);
    }

    @Override
    protected String getServiceDescriptor() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    @Override
    protected void a(l l2, e.e e2) throws RemoteException {
        String string2 = this.getContext().getPackageName();
        o.i(e2);
        o.i(string2);
        o.i(this.gR());
        Bundle bundle = new Bundle();
        if (!string2.equals(this.IM)) {
            bundle.putString("proxy_package_name", this.IM);
        }
        bundle.putAll(this.OA);
        l2.a((k)e2, 6171000, string2, this.gR(), this.Dd, bundle);
    }

    @Override
    protected String getStartServiceAction() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public ab hY() {
        return (ab)this.gS();
    }

    public DriveId hZ() {
        return this.OC;
    }

    public DriveId ia() {
        return this.OD;
    }

    @Override
    public void disconnect() {
        ab ab2 = (ab)this.gS();
        if (ab2 != null) {
            try {
                ab2.a(new DisconnectRequest());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        super.disconnect();
        this.OF.clear();
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            this.OC = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.OD = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
        }
        super.a(n2, iBinder, bundle);
    }

    public boolean ib() {
        return this.OB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> a(GoogleApiClient googleApiClient, final DriveId driveId, final int n2, c c2) {
        o.b(d.a(n2, driveId), (Object)"id");
        o.b(c2, (Object)"listener");
        o.a(this.isConnected(), "Client must be connected");
        Map<DriveId, Map<c, y>> map = this.OF;
        synchronized (map) {
            y y2;
            Map<c, y> map2 = this.OF.get(driveId);
            if (map2 == null) {
                map2 = new HashMap<c, y>();
                this.OF.put(driveId, map2);
            }
            if ((y2 = map2.get(c2)) == null) {
                y2 = new y(this.getLooper(), this.getContext(), n2, c2);
                map2.put(c2, y2);
            } else if (y2.br(n2)) {
                return new o.m(googleApiClient, Status.Jv);
            }
            y2.bq(n2);
            final y y3 = y2;
            return googleApiClient.b(new p.a(){

                @Override
                protected void a(q q2) throws RemoteException {
                    q2.hY().a(new AddEventListenerRequest(driveId, n2), (ad)y3, null, (ac)new bb(this));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> b(GoogleApiClient googleApiClient, final DriveId driveId, final int n2, c c2) {
        o.b(d.a(n2, driveId), (Object)"id");
        o.a(this.isConnected(), "Client must be connected");
        o.b(c2, (Object)"listener");
        Map<DriveId, Map<c, y>> map = this.OF;
        synchronized (map) {
            Map<c, y> map2 = this.OF.get(driveId);
            if (map2 == null) {
                return new o.m(googleApiClient, Status.Jv);
            }
            final y y2 = map2.remove(c2);
            if (y2 == null) {
                return new o.m(googleApiClient, Status.Jv);
            }
            if (map2.isEmpty()) {
                this.OF.remove(driveId);
            }
            return googleApiClient.b(new p.a(){

                @Override
                protected void a(q q2) throws RemoteException {
                    q2.hY().a(new RemoveEventListenerRequest(driveId, n2), (ad)y2, null, (ac)new bb(this));
                }
            });
        }
    }

    PendingResult<Status> a(GoogleApiClient googleApiClient, final DriveId driveId, final int n2) {
        o.b(d.a(n2, driveId), (Object)"id");
        o.i("eventService");
        o.a(this.isConnected(), "Client must be connected");
        if (!this.OB) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient.b(new p.a(){

            @Override
            protected void a(q q2) throws RemoteException {
                q2.hY().a(new AddEventListenerRequest(driveId, n2), null, null, (ac)new bb(this));
            }
        });
    }

    PendingResult<Status> b(GoogleApiClient googleApiClient, final DriveId driveId, final int n2) {
        o.b(d.a(n2, driveId), (Object)"id");
        o.i("eventService");
        o.a(this.isConnected(), "Client must be connected");
        return googleApiClient.b(new p.a(){

            @Override
            protected void a(q q2) throws RemoteException {
                q2.hY().a(new RemoveEventListenerRequest(driveId, n2), null, null, (ac)new bb(this));
            }
        });
    }

    @Override
    protected /* synthetic */ IInterface j(IBinder iBinder) {
        return this.T(iBinder);
    }
}

