/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.internal.OnEventResponse;
import com.google.android.gms.drive.internal.ad;
import com.google.android.gms.drive.internal.v;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class DriveEventService
extends Service
implements ChangeListener,
CompletionListener {
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String mName;
    private CountDownLatch NV;
    a NW;
    int NX = -1;

    protected DriveEventService(String name) {
        this.mName = name;
    }

    protected DriveEventService() {
        this("DriveEventService");
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.NW == null) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                this.NV = new CountDownLatch(1);
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Looper.prepare();
                            DriveEventService.this.NW = new a();
                            countDownLatch.countDown();
                            v.n("DriveEventService", "Bound and starting loop");
                            Looper.loop();
                            v.n("DriveEventService", "Finished loop");
                        }
                        finally {
                            DriveEventService.this.NV.countDown();
                        }
                    }
                }.start();
                try {
                    countDownLatch.await(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new b().asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        v.n("DriveEventService", "onDestroy");
        if (this.NW != null) {
            Message message = this.NW.hW();
            this.NW.sendMessage(message);
            this.NW = null;
            try {
                this.NV.await(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.NV = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent event) {
        v.p(this.mName, "Unhandled change event: " + event);
    }

    @Override
    public void onCompletion(CompletionEvent event) {
        v.p(this.mName, "Unhandled completion event: " + event);
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private void a(OnEventResponse onEventResponse) {
        DriveEvent driveEvent = onEventResponse.ih();
        v.n("DriveEventService", "handleEventMessage: " + driveEvent);
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    break;
                }
                case 2: {
                    CompletionEvent completionEvent = (CompletionEvent)driveEvent;
                    this.onCompletion(completionEvent);
                    break;
                }
                default: {
                    v.p(this.mName, "Unhandled event: " + driveEvent);
                    break;
                }
            }
        }
        catch (Exception exception) {
            v.a(this.mName, exception, "Error handling event: " + driveEvent);
        }
    }

    private void hV() throws SecurityException {
        int n2 = this.getCallingUid();
        if (n2 == this.NX) {
            return;
        }
        boolean bl2 = GooglePlayServicesUtil.b(this.getPackageManager(), "com.google.android.gms");
        if (bl2 && this.bc(n2)) {
            this.NX = n2;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    private boolean bc(int n2) {
        String string2 = "com.google.android.gms";
        PackageManager packageManager = this.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n2);
        if (stringArray != null) {
            for (String string3 : stringArray) {
                if (!string2.equals(string3)) continue;
                return true;
            }
        }
        return false;
    }

    final class b
    extends ad.a {
        b() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void c(OnEventResponse onEventResponse) throws RemoteException {
            DriveEventService driveEventService = DriveEventService.this;
            synchronized (driveEventService) {
                v.n("DriveEventService", "onEvent: " + onEventResponse);
                o.i(DriveEventService.this.NW);
                DriveEventService.this.hV();
                Message message = DriveEventService.this.NW.b(onEventResponse);
                DriveEventService.this.NW.sendMessage(message);
            }
        }
    }

    final class a
    extends Handler {
        a() {
        }

        private Message b(OnEventResponse onEventResponse) {
            return this.obtainMessage(1, onEventResponse);
        }

        private Message hW() {
            return this.obtainMessage(2);
        }

        public void handleMessage(Message msg) {
            v.n("DriveEventService", "handleMessage message type:" + msg.what);
            switch (msg.what) {
                case 1: {
                    DriveEventService.this.a((OnEventResponse)msg.obj);
                    break;
                }
                case 2: {
                    this.getLooper().quit();
                    break;
                }
                default: {
                    v.p("DriveEventService", "Unexpected message type:" + msg.what);
                }
            }
        }
    }
}

