/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.f;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.o;
import java.util.ArrayList;

public abstract class e<T extends IInterface>
implements Api.a,
f.b {
    private final Context mContext;
    private final Looper IH;
    final Handler mHandler;
    private T Lz;
    private final ArrayList<b<?>> LA = new ArrayList();
    private f LB;
    private volatile int LC = 1;
    private final String[] Ds;
    boolean LD = false;
    private final com.google.android.gms.common.internal.f IX;
    public static final String[] LE = new String[]{"service_esmobile", "service_googleme"};

    protected e(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = o.i(context);
        this.IH = o.b(looper, (Object)"Looper must not be null");
        this.IX = new com.google.android.gms.common.internal.f(context, looper, this);
        this.mHandler = new a(looper);
        this.c(stringArray);
        this.Ds = stringArray;
        this.registerConnectionCallbacks(o.i(connectionCallbacks));
        this.registerConnectionFailedListener(o.i(onConnectionFailedListener));
    }

    @Deprecated
    protected e(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this(context, context.getMainLooper(), new c(connectionCallbacks), new g(onConnectionFailedListener), stringArray);
    }

    protected void c(String ... stringArray) {
    }

    protected abstract String getStartServiceAction();

    protected abstract String getServiceDescriptor();

    protected abstract T j(IBinder var1);

    private void az(int n2) {
        int n3 = this.LC;
        this.LC = n2;
        if (n3 != n2) {
            if (n2 == 3) {
                this.onConnected();
            } else if (n3 == 3 && n2 == 1) {
                this.onDisconnected();
            }
        }
    }

    protected void onConnected() {
    }

    protected void onDisconnected() {
    }

    @Override
    public void connect() {
        this.LD = true;
        this.az(2);
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.az(1);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.LB != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.Lz = null;
            com.google.android.gms.common.internal.g.J(this.mContext).b(this.getStartServiceAction(), this.LB);
        }
        this.LB = new f();
        boolean bl2 = com.google.android.gms.common.internal.g.J(this.mContext).a(this.getStartServiceAction(), this.LB);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.getStartServiceAction()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.LC == 3;
    }

    public boolean isConnecting() {
        return this.LC == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.LD = false;
        ArrayList<b<?>> arrayList = this.LA;
        synchronized (arrayList) {
            int n2 = this.LA.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.LA.get(i2).gV();
            }
            this.LA.clear();
        }
        this.az(1);
        this.Lz = null;
        if (this.LB != null) {
            com.google.android.gms.common.internal.g.J(this.mContext).b(this.getStartServiceAction(), this.LB);
            this.LB = null;
        }
    }

    public void aA(int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)n2));
    }

    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.IH;
    }

    public final String[] gR() {
        return this.Ds;
    }

    protected final void N(IBinder iBinder) {
        try {
            l l2 = l.a.Q(iBinder);
            this.a(l2, new e(this));
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(l var1, e var2) throws RemoteException;

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new h(n2, iBinder, bundle)));
    }

    protected final void dJ() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle fC() {
        return null;
    }

    public final T gS() {
        this.dJ();
        return this.Lz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.LA;
        synchronized (arrayList) {
            this.LA.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    @Override
    public boolean gq() {
        return this.LD;
    }

    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.IX.registerConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.IX.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.IX.registerConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.IX.isConnectionCallbacksRegistered(new c(listener));
    }

    @Deprecated
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.IX.unregisterConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.IX.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.IX.isConnectionFailedListenerRegistered(listener);
    }

    @Deprecated
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.IX.unregisterConnectionFailedListener(listener);
    }

    public static final class e
    extends k.a {
        private e LI;

        public e(e e2) {
            this.LI = e2;
        }

        @Override
        public void b(int n2, IBinder iBinder, Bundle bundle) {
            o.b("onPostInitComplete can be called only once per call to getServiceFromBroker", (Object)this.LI);
            this.LI.a(n2, iBinder, bundle);
            this.LI = null;
        }
    }

    protected final class h
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle LK;
        public final IBinder LL;

        public h(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.LL = iBinder;
            this.LK = bundle;
        }

        protected void b(Boolean bl2) {
            if (bl2 == null) {
                e.this.az(1);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.LL.getInterfaceDescriptor();
                        if (e.this.getServiceDescriptor().equals(string2)) {
                            e.this.Lz = e.this.j(this.LL);
                            if (e.this.Lz != null) {
                                e.this.az(3);
                                e.this.IX.dL();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    com.google.android.gms.common.internal.g.J(e.this.mContext).b(e.this.getStartServiceAction(), e.this.LB);
                    e.this.LB = null;
                    e.this.az(1);
                    e.this.Lz = null;
                    e.this.IX.b(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    e.this.az(1);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.LK != null) {
                        pendingIntent = (PendingIntent)this.LK.getParcelable("pendingIntent");
                    }
                    if (e.this.LB != null) {
                        com.google.android.gms.common.internal.g.J(e.this.mContext).b(e.this.getStartServiceAction(), e.this.LB);
                        e.this.LB = null;
                    }
                    e.this.az(1);
                    e.this.Lz = null;
                    e.this.IX.b(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((Boolean)object);
        }
    }

    public static final class g
    implements GoogleApiClient.OnConnectionFailedListener {
        private final GooglePlayServicesClient.OnConnectionFailedListener LJ;

        public g(GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.LJ = onConnectionFailedListener;
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.LJ.onConnectionFailed(result);
        }

        public boolean equals(Object other) {
            if (other instanceof g) {
                return this.LJ.equals(((g)other).LJ);
            }
            return this.LJ.equals(other);
        }
    }

    public static final class c
    implements GoogleApiClient.ConnectionCallbacks {
        private final GooglePlayServicesClient.ConnectionCallbacks LH;

        public c(GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks) {
            this.LH = connectionCallbacks;
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.LH.onConnected(connectionHint);
        }

        @Override
        public void onConnectionSuspended(int cause) {
            this.LH.onDisconnected();
        }

        public boolean equals(Object other) {
            if (other instanceof c) {
                return this.LH.equals(((c)other).LH);
            }
            return this.LH.equals(other);
        }
    }

    public abstract class d<TListener>
    extends b<TListener> {
        private final DataHolder II;

        public d(TListener TListener, DataHolder dataHolder) {
            super(TListener);
            this.II = dataHolder;
        }

        @Override
        protected final void g(TListener TListener) {
            this.a(TListener, this.II);
        }

        protected abstract void a(TListener var1, DataHolder var2);

        @Override
        protected void gT() {
            if (this.II != null) {
                this.II.close();
            }
        }
    }

    protected abstract class b<TListener> {
        private TListener mListener;
        private boolean LG;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.LG = false;
        }

        protected abstract void g(TListener var1);

        protected abstract void gT();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gU() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.LG) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.g(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.gT();
                    throw runtimeException;
                }
            } else {
                this.gT();
            }
            b2 = this;
            synchronized (b2) {
                this.LG = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.gV();
            ArrayList arrayList = e.this.LA;
            synchronized (arrayList) {
                e.this.LA.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gV() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 1 && !e.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.gT();
                b2.unregister();
                return;
            }
            if (msg.what == 3) {
                e.this.IX.b(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                e.this.az(1);
                e.this.Lz = null;
                e.this.IX.aB((Integer)msg.obj);
                return;
            }
            if (msg.what == 2 && !e.this.isConnected()) {
                b b3 = (b)msg.obj;
                b3.gT();
                b3.unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                b b4 = (b)msg.obj;
                b4.gU();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    final class f
    implements ServiceConnection {
        f() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            e.this.N(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            e.this.mHandler.sendMessage(e.this.mHandler.obtainMessage(4, (Object)1));
        }
    }
}

