/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Parcel;
import android.view.View;
import com.google.android.gms.common.internal.ParcelableClientSettingsCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ClientSettings {
    private final ParcelableClientSettings Ls;
    private final View IL;

    public ClientSettings(String accountName, Collection<String> scopes, int gravityForPopups, View viewForPopups, String realClientPackageName) {
        this.Ls = new ParcelableClientSettings(accountName, scopes, gravityForPopups, realClientPackageName);
        this.IL = viewForPopups;
    }

    public String getAccountName() {
        return this.Ls.getAccountName();
    }

    public String getAccountNameOrDefault() {
        return this.Ls.getAccountNameOrDefault();
    }

    public int getGravityForPopups() {
        return this.Ls.getGravityForPopups();
    }

    public List<String> getScopes() {
        return this.Ls.getScopes();
    }

    public String[] getScopesArray() {
        return this.Ls.getScopes().toArray(new String[0]);
    }

    public String getRealClientPackageName() {
        return this.Ls.getRealClientPackageName();
    }

    public View getViewForPopups() {
        return this.IL;
    }

    public ParcelableClientSettings getParcelableClientSettings() {
        return this.Ls;
    }

    public static final class ParcelableClientSettings
    implements SafeParcelable {
        public static final ParcelableClientSettingsCreator CREATOR = new ParcelableClientSettingsCreator();
        private final int BR;
        private final String Dd;
        private final List<String> Jk = new ArrayList<String>();
        private final int IK;
        private final String IM;

        ParcelableClientSettings(int versionCode, String accountName, List<String> scopes, int gravityForPopups, String realClientPackageName) {
            this.BR = versionCode;
            this.Dd = accountName;
            this.Jk.addAll(scopes);
            this.IK = gravityForPopups;
            this.IM = realClientPackageName;
        }

        public ParcelableClientSettings(String accountName, Collection<String> scopes, int gravityForPopups, String realClientPackageName) {
            this(3, accountName, new ArrayList<String>(scopes), gravityForPopups, realClientPackageName);
        }

        public String getAccountName() {
            return this.Dd;
        }

        public String getAccountNameOrDefault() {
            return this.Dd != null ? this.Dd : "<<default account>>";
        }

        public int getGravityForPopups() {
            return this.IK;
        }

        public String getRealClientPackageName() {
            return this.IM;
        }

        public List<String> getScopes() {
            return new ArrayList<String>(this.Jk);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            ParcelableClientSettingsCreator.a(this, out, flags);
        }

        public int getVersionCode() {
            return this.BR;
        }
    }
}

