/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.images.a;
import com.google.android.gms.internal.iz;
import com.google.android.gms.internal.ja;
import com.google.android.gms.internal.kc;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object Ks = new Object();
    private static HashSet<Uri> Kt = new HashSet();
    private static ImageManager Ku;
    private static ImageManager Kv;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService Kw;
    private final b Kx;
    private final iz Ky;
    private final Map<com.google.android.gms.common.images.a, ImageReceiver> Kz;
    private final Map<Uri, ImageReceiver> KA;
    private final Map<Uri, Long> KB;

    public static ImageManager create(Context context) {
        return ImageManager.c(context, false);
    }

    public static ImageManager c(Context context, boolean bl2) {
        if (bl2) {
            if (Kv == null) {
                Kv = new ImageManager(context, true);
            }
            return Kv;
        }
        if (Ku == null) {
            Ku = new ImageManager(context, false);
        }
        return Ku;
    }

    private ImageManager(Context context, boolean withMemoryCache) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.Kw = Executors.newFixedThreadPool(4);
        if (withMemoryCache) {
            this.Kx = new b(this.mContext);
            if (kc.hE()) {
                this.gG();
            }
        } else {
            this.Kx = null;
        }
        this.Ky = new iz();
        this.Kz = new HashMap<com.google.android.gms.common.images.a, ImageReceiver>();
        this.KA = new HashMap<Uri, ImageReceiver>();
        this.KB = new HashMap<Uri, Long>();
    }

    private void gG() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new e(this.Kx));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        a.b b2 = new a.b(imageView, uri);
        this.a(b2);
    }

    public void loadImage(ImageView imageView, int resId) {
        a.b b2 = new a.b(imageView, resId);
        this.a(b2);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        a.b b2 = new a.b(imageView, uri);
        b2.aw(defaultResId);
        this.a(b2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        a.c c2 = new a.c(listener, uri);
        this.a(c2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        a.c c2 = new a.c(listener, uri);
        c2.aw(defaultResId);
        this.a(c2);
    }

    public void a(com.google.android.gms.common.images.a a2) {
        com.google.android.gms.common.internal.a.aT("ImageManager.loadImage() must be called in the main thread");
        d d2 = new d(a2);
        d2.run();
    }

    private Bitmap a(a.a a2) {
        if (this.Kx == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.Kx.get(a2);
        return bitmap;
    }

    private static final class a {
        static int a(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    private static final class b
    extends ja<a.a, Bitmap> {
        public b(Context context) {
            super(b.I(context));
        }

        protected void a(boolean bl2, a.a a2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl2, a2, bitmap, bitmap2);
        }

        private static int I(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl2 = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n2 = bl2 && kc.hB() ? a.a(activityManager) : activityManager.getMemoryClass();
            int n3 = 0x100000 * n2;
            return (int)(0.33f * (float)n3);
        }

        protected int a(a.a a2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        @Override
        protected /* synthetic */ int sizeOf(Object x0, Object x1) {
            return this.a((a.a)x0, (Bitmap)x1);
        }

        @Override
        protected /* synthetic */ void entryRemoved(boolean x0, Object x1, Object x2, Object x3) {
            this.a(x0, (a.a)x1, (Bitmap)x2, (Bitmap)x3);
        }
    }

    private static final class e
    implements ComponentCallbacks2 {
        private final b Kx;

        public e(b b2) {
            this.Kx = b2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.Kx.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.Kx.evictAll();
            } else if (level >= 20) {
                this.Kx.trimToSize(this.Kx.size() / 2);
            }
        }
    }

    private final class f
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch mg;
        private boolean KG;

        public f(Uri uri, Bitmap bitmap, boolean bl2, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.KG = bl2;
            this.mg = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl2;
            com.google.android.gms.common.internal.a.aT("OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl3 = bl2 = this.mBitmap != null;
            if (ImageManager.this.Kx != null) {
                if (this.KG) {
                    ImageManager.this.Kx.evictAll();
                    System.gc();
                    this.KG = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl2) {
                    ImageManager.this.Kx.put(new a.a(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.KA.remove(this.mUri))) != null) {
                this.a(imageReceiver, bl2);
            }
            this.mg.countDown();
            Object object = Ks;
            synchronized (object) {
                Kt.remove(this.mUri);
            }
        }

        private void a(ImageReceiver imageReceiver, boolean bl2) {
            ArrayList arrayList = imageReceiver.KC;
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                com.google.android.gms.common.images.a a2 = (com.google.android.gms.common.images.a)arrayList.get(i2);
                if (bl2) {
                    a2.a(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    ImageManager.this.KB.put(this.mUri, SystemClock.elapsedRealtime());
                    a2.a(ImageManager.this.mContext, ImageManager.this.Ky, false);
                }
                if (a2 instanceof a.c) continue;
                ImageManager.this.Kz.remove(a2);
            }
        }
    }

    private final class c
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor KE;

        public c(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.KE = parcelFileDescriptor;
        }

        @Override
        public void run() {
            com.google.android.gms.common.internal.a.aU("LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl2 = false;
            Bitmap bitmap = null;
            if (this.KE != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.KE.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)"ImageManager", (String)("OOM while loading bitmap for uri: " + this.mUri), (Throwable)outOfMemoryError);
                    bl2 = true;
                }
                try {
                    this.KE.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new f(this.mUri, bitmap, bl2, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)"ImageManager", (String)("Latch interrupted while posting " + this.mUri));
            }
        }
    }

    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.a> KC;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.KC = new ArrayList();
        }

        public void b(com.google.android.gms.common.images.a a2) {
            com.google.android.gms.common.internal.a.aT("ImageReceiver.addImageRequest() must be called in the main thread");
            this.KC.add(a2);
        }

        public void c(com.google.android.gms.common.images.a a2) {
            com.google.android.gms.common.internal.a.aT("ImageReceiver.removeImageRequest() must be called in the main thread");
            this.KC.remove(a2);
        }

        public void gJ() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.Kw.execute(new c(this.mUri, parcelFileDescriptor));
        }
    }

    private final class d
    implements Runnable {
        private final com.google.android.gms.common.images.a KF;

        public d(com.google.android.gms.common.images.a a2) {
            this.KF = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            com.google.android.gms.common.internal.a.aT("LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.Kz.get(this.KF));
            if (imageReceiver != null) {
                ImageManager.this.Kz.remove(this.KF);
                imageReceiver.c(this.KF);
            }
            a.a a2 = this.KF.KH;
            if (a2.uri == null) {
                this.KF.a(ImageManager.this.mContext, ImageManager.this.Ky, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.a(a2);
            if (bitmap != null) {
                this.KF.a(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l2 = (Long)ImageManager.this.KB.get(a2.uri);
            if (l2 != null) {
                if (SystemClock.elapsedRealtime() - l2 < 3600000L) {
                    this.KF.a(ImageManager.this.mContext, ImageManager.this.Ky, true);
                    return;
                }
                ImageManager.this.KB.remove(a2.uri);
            }
            this.KF.a(ImageManager.this.mContext, ImageManager.this.Ky);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.KA.get(a2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(a2.uri);
                ImageManager.this.KA.put(a2.uri, imageReceiver);
            }
            imageReceiver.b(this.KF);
            if (!(this.KF instanceof a.c)) {
                ImageManager.this.Kz.put(this.KF, imageReceiver);
            }
            Object object = Ks;
            synchronized (object) {
                boolean bl2 = Kt.contains(a2.uri);
                if (!bl2) {
                    Kt.add(a2.uri);
                    imageReceiver.gJ();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

