/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.d;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.f;
import com.google.android.gms.common.internal.o;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class b
implements GoogleApiClient {
    final int IU;
    private final Lock IV = new ReentrantLock();
    private final Condition IW = this.IV.newCondition();
    private final f IX;
    private final int IY;
    private final Looper IH;
    final Queue<c<?>> IZ = new LinkedList();
    private ConnectionResult Ja;
    private int Jb;
    private volatile int Jc = 4;
    private volatile int Jd;
    private boolean Je = false;
    private int Jf;
    private long Jg = 5000L;
    final Handler Jh;
    private final Bundle Ji = new Bundle();
    private final Map<Api.c<?>, Api.a> Jj = new HashMap();
    private final List<String> Jk;
    private boolean Jl;
    private final Set<com.google.android.gms.common.api.c<?>> Jm = Collections.newSetFromMap(new WeakHashMap());
    final Set<c<?>> Jn = Collections.newSetFromMap(new ConcurrentHashMap());
    private final a Iz = new a(){

        @Override
        public void b(c<?> c2) {
            b.this.Jn.remove(c2);
        }
    };
    private final GoogleApiClient.ConnectionCallbacks Jo = new GoogleApiClient.ConnectionCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnected(Bundle connectionHint) {
            b.this.IV.lock();
            try {
                if (b.this.Jc == 1) {
                    if (connectionHint != null) {
                        b.this.Ji.putAll(connectionHint);
                    }
                    b.this.gm();
                }
            }
            finally {
                b.this.IV.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onConnectionSuspended(int cause) {
            b.this.IV.lock();
            try {
                b.this.aj(cause);
                switch (cause) {
                    case 2: {
                        b.this.connect();
                        return;
                    }
                    case 1: {
                        if (b.this.go()) {
                            return;
                        }
                        b.this.Jd = b.this.IU;
                        b.this.Jh.sendMessageDelayed(b.this.Jh.obtainMessage(1), b.this.Jg);
                        return;
                    }
                }
                return;
            }
            finally {
                b.this.IV.unlock();
            }
        }
    };
    private final f.b Jp = new f.b(){

        @Override
        public boolean gq() {
            return b.this.Jl;
        }

        @Override
        public boolean isConnected() {
            return b.this.isConnected();
        }

        @Override
        public Bundle fC() {
            return null;
        }
    };

    public b(Context context, Looper looper, ClientSettings clientSettings, Map<Api<?>, Api.ApiOptions> map, Set<GoogleApiClient.ConnectionCallbacks> set, Set<GoogleApiClient.OnConnectionFailedListener> set2, int n2, int n3) {
        this.IX = new f(context, looper, this.Jp);
        this.IH = looper;
        this.Jh = new b(looper);
        this.IY = n2;
        this.IU = n3;
        for (GoogleApiClient.ConnectionCallbacks object : set) {
            this.IX.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : set2) {
            this.IX.registerConnectionFailedListener(onConnectionFailedListener);
        }
        for (Api api : map.keySet()) {
            final Api.b b2 = api.gb();
            Api.ApiOptions apiOptions = map.get(api);
            this.Jj.put(api.ge(), (Api.a)b.a(b2, apiOptions, context, looper, clientSettings, this.Jo, new GoogleApiClient.OnConnectionFailedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onConnectionFailed(ConnectionResult result) {
                    b.this.IV.lock();
                    try {
                        if (b.this.Ja == null || b2.getPriority() < b.this.Jb) {
                            b.this.Ja = result;
                            b.this.Jb = b2.getPriority();
                        }
                        b.this.gm();
                    }
                    finally {
                        b.this.IV.unlock();
                    }
                }
            }));
        }
        this.Jk = Collections.unmodifiableList(clientSettings.getScopes());
    }

    private static <C extends Api.a, O> C a(Api.b<C, O> b2, Object object, Context context, Looper looper, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return b2.a(context, looper, clientSettings, object, connectionCallbacks, onConnectionFailedListener);
    }

    private void gm() {
        --this.Jf;
        if (this.Jf == 0) {
            if (this.Ja != null) {
                this.Je = false;
                this.aj(3);
                if (this.go()) {
                    this.Jh.sendMessageDelayed(this.Jh.obtainMessage(1), this.Jg);
                } else {
                    this.IX.b(this.Ja);
                }
                this.Jl = false;
            } else {
                this.Jc = 2;
                this.gp();
                this.IW.signalAll();
                this.gn();
                if (this.Je) {
                    this.Je = false;
                    this.aj(-1);
                } else {
                    Bundle bundle = this.Ji.isEmpty() ? null : this.Ji;
                    this.IX.d(bundle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.a, R extends Result, T extends BaseImplementation.a<R, A>> T a(T t2) {
        this.IV.lock();
        try {
            t2.a(new BaseImplementation.CallbackHandler(this.getLooper()));
            if (this.isConnected()) {
                this.b(t2);
            } else {
                this.IZ.add(t2);
            }
            T t3 = t2;
            return t3;
        }
        finally {
            this.IV.unlock();
        }
    }

    @Override
    public <A extends Api.a, T extends BaseImplementation.a<? extends Result, A>> T b(T t2) {
        o.a(this.isConnected() || this.go(), "GoogleApiClient is not connected yet.");
        this.gn();
        try {
            this.a((c<A>)t2);
        }
        catch (DeadObjectException deadObjectException) {
            this.aj(1);
        }
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A extends Api.a> void a(c<A> c2) throws DeadObjectException {
        this.IV.lock();
        try {
            o.b(c2.ge() != null, (Object)"This task can not be executed or enqueued (it's probably a Batch or malformed)");
            this.Jn.add(c2);
            c2.a(this.Iz);
            if (this.go()) {
                c2.m(new Status(8));
                return;
            }
            A a2 = this.a(c2.ge());
            c2.b(a2);
        }
        finally {
            this.IV.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gn() {
        this.IV.lock();
        try {
            o.a(this.isConnected() || this.go(), "GoogleApiClient is not connected yet.");
            while (!this.IZ.isEmpty()) {
                try {
                    this.a(this.IZ.remove());
                }
                catch (DeadObjectException deadObjectException) {
                    Log.w((String)"GoogleApiClientImpl", (String)"Service died while flushing queue", (Throwable)deadObjectException);
                }
            }
        }
        finally {
            this.IV.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> com.google.android.gms.common.api.c<L> c(L l2) {
        o.b(l2, (Object)"Listener must not be null");
        this.IV.lock();
        try {
            com.google.android.gms.common.api.c<L> c2 = new com.google.android.gms.common.api.c<L>(this.IH, l2);
            this.Jm.add(c2);
            com.google.android.gms.common.api.c<L> c3 = c2;
            return c3;
        }
        finally {
            this.IV.unlock();
        }
    }

    @Override
    public <C extends Api.a> C a(Api.c<C> c2) {
        Api.a a2 = this.Jj.get(c2);
        o.b(a2, (Object)"Appropriate Api was not requested.");
        return (C)a2;
    }

    @Override
    public boolean a(Scope scope) {
        return this.Jk.contains(scope.gs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.IV.lock();
        try {
            this.Je = false;
            if (this.isConnected() || this.isConnecting()) {
                return;
            }
            this.Jl = true;
            this.Ja = null;
            this.Jc = 1;
            this.Ji.clear();
            this.Jf = this.Jj.size();
            for (Api.a a2 : this.Jj.values()) {
                a2.connect();
            }
        }
        finally {
            this.IV.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect() {
        o.a(Looper.myLooper() != Looper.getMainLooper(), "blockingConnect must not be called on the UI thread");
        this.IV.lock();
        try {
            this.connect();
            while (this.isConnecting()) {
                try {
                    this.IW.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    this.IV.unlock();
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.HE;
                return connectionResult;
            }
            if (this.Ja != null) {
                ConnectionResult connectionResult = this.Ja;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.IV.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        o.a(Looper.myLooper() != Looper.getMainLooper(), "blockingConnect must not be called on the UI thread");
        this.IV.lock();
        try {
            this.connect();
            long l2 = unit.toNanos(timeout);
            while (this.isConnecting()) {
                try {
                    l2 = this.IW.awaitNanos(l2);
                    if (l2 > 0L) continue;
                    ConnectionResult connectionResult = new ConnectionResult(14, null);
                    return connectionResult;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.HE;
                return connectionResult;
            }
            if (this.Ja != null) {
                ConnectionResult connectionResult = this.Ja;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.IV.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.gp();
        this.aj(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aj(int n2) {
        this.IV.lock();
        try {
            if (this.Jc != 3) {
                if (n2 == -1) {
                    if (this.isConnecting()) {
                        Iterator<Object> iterator = this.IZ.iterator();
                        while (iterator.hasNext()) {
                            c object = (c)iterator.next();
                            if (object.gj() == 1) continue;
                            object.cancel();
                            iterator.remove();
                        }
                    } else {
                        this.IZ.clear();
                    }
                    for (c c2 : this.Jn) {
                        c2.cancel();
                    }
                    this.Jn.clear();
                    for (com.google.android.gms.common.api.c c3 : this.Jm) {
                        c3.clear();
                    }
                    this.Jm.clear();
                    if (this.Ja == null && !this.IZ.isEmpty()) {
                        this.Je = true;
                        return;
                    }
                }
                boolean bl2 = this.isConnecting();
                boolean bl3 = this.isConnected();
                this.Jc = 3;
                if (bl2) {
                    if (n2 == -1) {
                        this.Ja = null;
                    }
                    this.IW.signalAll();
                }
                this.Jl = false;
                for (Api.a a2 : this.Jj.values()) {
                    if (!a2.isConnected()) continue;
                    a2.disconnect();
                }
                this.Jl = true;
                this.Jc = 4;
                if (bl3) {
                    if (n2 != -1) {
                        this.IX.aB(n2);
                    }
                    this.Jl = false;
                }
            }
        }
        finally {
            this.IV.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public void stopAutoManage(FragmentActivity lifecycleActivity) {
        o.a(this.IY >= 0, "Called stopAutoManage but automatic lifecycle management is not enabled.");
        d.a(lifecycleActivity).al(this.IY);
    }

    @Override
    public boolean isConnected() {
        return this.Jc == 2;
    }

    @Override
    public boolean isConnecting() {
        return this.Jc == 1;
    }

    private boolean go() {
        return this.Jd != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gp() {
        this.IV.lock();
        try {
            this.Jd = 0;
            this.Jh.removeMessages(1);
        }
        finally {
            this.IV.unlock();
        }
    }

    @Override
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.IX.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        return this.IX.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.IX.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.IX.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        return this.IX.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.IX.unregisterConnectionFailedListener(listener);
    }

    @Override
    public Looper getLooper() {
        return this.IH;
    }

    class b
    extends Handler {
        b(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                b.this.IV.lock();
                try {
                    if (b.this.isConnected() || b.this.isConnecting() || !b.this.go()) {
                        return;
                    }
                    b.this.Jd--;
                    b.this.connect();
                    return;
                }
                finally {
                    b.this.IV.unlock();
                }
            }
            Log.wtf((String)"GoogleApiClientImpl", (String)"Don't know how to handle this message.");
        }
    }

    static interface c<A extends Api.a> {
        public void cancel();

        public Api.c<A> ge();

        public void b(A var1) throws DeadObjectException;

        public void m(Status var1);

        public void a(a var1);

        public int gj();
    }

    static interface a {
        public void b(c<?> var1);
    }
}

