/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.b;
import com.google.android.gms.common.api.c;
import com.google.android.gms.common.api.d;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.o;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface GoogleApiClient {
    public <A extends Api.a, R extends Result, T extends BaseImplementation.a<R, A>> T a(T var1);

    public <A extends Api.a, T extends BaseImplementation.a<? extends Result, A>> T b(T var1);

    public <L> c<L> c(L var1);

    public <C extends Api.a> C a(Api.c<C> var1);

    public boolean a(Scope var1);

    public Looper getLooper();

    public void connect();

    public ConnectionResult blockingConnect();

    public ConnectionResult blockingConnect(long var1, TimeUnit var3);

    public void disconnect();

    public void reconnect();

    public void stopAutoManage(FragmentActivity var1);

    public boolean isConnected();

    public boolean isConnecting();

    public void registerConnectionCallbacks(ConnectionCallbacks var1);

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks var1);

    public void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener var1);

    public void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public static final class Builder {
        private String Dd;
        private final Set<String> IJ = new HashSet<String>();
        private int IK;
        private View IL;
        private String IM;
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> IN = new HashMap();
        private FragmentActivity IO;
        private int IP = -1;
        private OnConnectionFailedListener IQ;
        private Looper IH;
        private int IR = 2;
        private final Set<ConnectionCallbacks> IS = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> IT = new HashSet<OnConnectionFailedListener>();

        public Builder(Context context) {
            this.mContext = context;
            this.IH = context.getMainLooper();
            this.IM = context.getPackageName();
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            o.b(connectedListener, (Object)"Must provide a connected listener");
            this.IS.add(connectedListener);
            o.b(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.IT.add(connectionFailedListener);
        }

        public Builder setHandler(Handler handler) {
            o.b(handler, (Object)"Handler must not be null");
            this.IH = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.IS.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.IT.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            this.IL = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            this.IJ.add(scope.gs());
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.IN.put(api, null);
            List<Scope> list = api.gd();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.IJ.add(list.get(i2).gs());
            }
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> api, O options) {
            o.b(options, (Object)"Null options are not permitted for this Api");
            this.IN.put(api, options);
            List<Scope> list = api.gd();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.IJ.add(list.get(i2).gs());
            }
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.Dd = accountName;
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.IK = gravityForPopups;
            return this;
        }

        public Builder enableAutoManage(FragmentActivity fragmentActivity, int clientId, OnConnectionFailedListener unresolvedConnectionFailedListener) {
            o.b(clientId >= 0, (Object)"clientId must be non-negative");
            this.IP = clientId;
            this.IO = o.b(fragmentActivity, (Object)"Null activity is not permitted.");
            this.IQ = unresolvedConnectionFailedListener;
            return this;
        }

        public ClientSettings gk() {
            return new ClientSettings(this.Dd, this.IJ, this.IK, this.IL, this.IM);
        }

        public GoogleApiClient build() {
            o.b(!this.IN.isEmpty(), (Object)"must call addApi() to add at least one API");
            if (this.IP >= 0) {
                return this.gl();
            }
            return new b(this.mContext, this.IH, this.gk(), this.IN, this.IS, this.IT, -1, this.IR);
        }

        private GoogleApiClient gl() {
            d d2 = d.a(this.IO);
            GoogleApiClient googleApiClient = d2.ak(this.IP);
            if (googleApiClient == null) {
                googleApiClient = new b(this.mContext.getApplicationContext(), this.IH, this.gk(), this.IN, this.IS, this.IT, this.IP, this.IR);
            }
            d2.a(this.IP, googleApiClient, this.IQ);
            return googleApiClient;
        }
    }

    public static interface OnConnectionFailedListener
    extends GooglePlayServicesClient.OnConnectionFailedListener {
        @Override
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

