/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.ij;
import com.google.android.gms.internal.iq;
import com.google.android.gms.internal.ir;
import com.google.android.gms.internal.is;
import java.io.IOException;
import org.json.JSONObject;

public class RemoteMediaPlayer
implements Cast.MessageReceivedCallback {
    private final Object mw = new Object();
    private final iq FG;
    private final a FH = new a();
    private OnMetadataUpdatedListener FI;
    private OnStatusUpdatedListener FJ;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_CANCELED = 2101;
    public static final int STATUS_TIMED_OUT = 2102;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaPlayer() {
        this.FG = new iq(){

            @Override
            protected void onStatusUpdated() {
                RemoteMediaPlayer.this.onStatusUpdated();
            }

            @Override
            protected void onMetadataUpdated() {
                RemoteMediaPlayer.this.onMetadataUpdated();
            }
        };
        this.FG.a(this.FH);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo) {
        return this.load(apiClient, mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay) {
        return this.load(apiClient, mediaInfo, autoplay, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition, JSONObject customData) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null, customData);
    }

    public PendingResult<MediaChannelResult> load(final GoogleApiClient apiClient, final MediaInfo mediaInfo, final boolean autoplay, final long playPosition, final long[] activeTrackIds, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(ij ij2) {
                Object object = RemoteMediaPlayer.this.mw;
                synchronized (object) {
                    RemoteMediaPlayer.this.FH.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.FG.a(this.Gb, mediaInfo, autoplay, playPosition, activeTrackIds, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.FH.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause(GoogleApiClient apiClient) {
        return this.pause(apiClient, null);
    }

    public PendingResult<MediaChannelResult> pause(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(ij ij2) {
                Object object = RemoteMediaPlayer.this.mw;
                synchronized (object) {
                    RemoteMediaPlayer.this.FH.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.FG.a(this.Gb, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.FH.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop(GoogleApiClient apiClient) {
        return this.stop(apiClient, null);
    }

    public PendingResult<MediaChannelResult> stop(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(ij ij2) {
                Object object = RemoteMediaPlayer.this.mw;
                synchronized (object) {
                    RemoteMediaPlayer.this.FH.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.FG.b(this.Gb, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.FH.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play(GoogleApiClient apiClient) {
        return this.play(apiClient, null);
    }

    public PendingResult<MediaChannelResult> play(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(ij ij2) {
                Object object = RemoteMediaPlayer.this.mw;
                synchronized (object) {
                    RemoteMediaPlayer.this.FH.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.FG.c(this.Gb, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.FH.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position) {
        return this.seek(apiClient, position, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position, int resumeState) {
        return this.seek(apiClient, position, resumeState, null);
    }

    public PendingResult<MediaChannelResult> seek(final GoogleApiClient apiClient, final long position, final int resumeState, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(ij ij2) {
                Object object = RemoteMediaPlayer.this.mw;
                synchronized (object) {
                    RemoteMediaPlayer.this.FH.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.FG.a(this.Gb, position, resumeState, customData);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.FH.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(GoogleApiClient apiClient, double volume) throws IllegalArgumentException {
        return this.setStreamVolume(apiClient, volume, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final GoogleApiClient apiClient, final double volume, final JSONObject customData) throws IllegalArgumentException {
        if (Double.isInfinite(volume) || Double.isNaN(volume)) {
            throw new IllegalArgumentException("Volume cannot be " + volume);
        }
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(ij ij2) {
                Object object = RemoteMediaPlayer.this.mw;
                synchronized (object) {
                    RemoteMediaPlayer.this.FH.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.FG.a(this.Gb, volume, customData);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.b(this.l(new Status(2100)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.b(this.l(new Status(2100)));
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.FH.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(GoogleApiClient apiClient, boolean muteState) {
        return this.setStreamMute(apiClient, muteState, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final GoogleApiClient apiClient, final boolean muteState, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(ij ij2) {
                Object object = RemoteMediaPlayer.this.mw;
                synchronized (object) {
                    RemoteMediaPlayer.this.FH.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.FG.a(this.Gb, muteState, customData);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.b(this.l(new Status(2100)));
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.FH.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus(final GoogleApiClient apiClient) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(ij ij2) {
                Object object = RemoteMediaPlayer.this.mw;
                synchronized (object) {
                    RemoteMediaPlayer.this.FH.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.FG.a(this.Gb);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.FH.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final GoogleApiClient apiClient, final long[] trackIds) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(ij ij2) {
                Object object = RemoteMediaPlayer.this.mw;
                synchronized (object) {
                    RemoteMediaPlayer.this.FH.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.FG.a(this.Gb, trackIds);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.FH.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final GoogleApiClient apiClient, final TextTrackStyle trackStyle) {
        if (trackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(ij ij2) {
                Object object = RemoteMediaPlayer.this.mw;
                synchronized (object) {
                    RemoteMediaPlayer.this.FH.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.FG.a(this.Gb, trackStyle);
                    }
                    catch (IOException iOException) {
                        this.b(this.l(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.FH.b(null);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.mw;
        synchronized (object) {
            return this.FG.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.mw;
        synchronized (object) {
            return this.FG.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.mw;
        synchronized (object) {
            return this.FG.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.mw;
        synchronized (object) {
            return this.FG.getMediaInfo();
        }
    }

    public void setOnStatusUpdatedListener(OnStatusUpdatedListener listener) {
        this.FJ = listener;
    }

    private void onStatusUpdated() {
        if (this.FJ != null) {
            this.FJ.onStatusUpdated();
        }
    }

    public void setOnMetadataUpdatedListener(OnMetadataUpdatedListener listener) {
        this.FI = listener;
    }

    private void onMetadataUpdated() {
        if (this.FI != null) {
            this.FI.onMetadataUpdated();
        }
    }

    public String getNamespace() {
        return this.FG.getNamespace();
    }

    @Override
    public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
        this.FG.aD(message);
    }

    private static abstract class b
    extends Cast.a<MediaChannelResult> {
        is Gb = new is(){

            @Override
            public void n(long l2) {
                b.this.b(b.this.l(new Status(2103)));
            }

            @Override
            public void a(long l2, int n2, JSONObject jSONObject) {
                b.this.b(new c(new Status(n2), jSONObject));
            }
        };

        b() {
        }

        public MediaChannelResult l(final Status status) {
            return new MediaChannelResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.l(status);
        }
    }

    private static final class c
    implements MediaChannelResult {
        private final Status CM;
        private final JSONObject Fl;

        c(Status status, JSONObject jSONObject) {
            this.CM = status;
            this.Fl = jSONObject;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public JSONObject getCustomData() {
            return this.Fl;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.RemoteMediaPlayer$a
    implements ir {
        private GoogleApiClient FX;
        private long FY = 0L;

        public void b(GoogleApiClient googleApiClient) {
            this.FX = googleApiClient;
        }

        @Override
        public long fx() {
            return ++this.FY;
        }

        @Override
        public void a(String string2, String string3, long l2, String string4) throws IOException {
            if (this.FX == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Cast.CastApi.sendMessage(this.FX, string2, string3).setResultCallback(new a(l2));
        }

        private final class a
        implements ResultCallback<Status> {
            private final long FZ;

            a(long l2) {
                this.FZ = l2;
            }

            public void k(Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaPlayer.this.FG.b(this.FZ, status.getStatusCode());
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.k((Status)x0);
            }
        }
    }

    public static interface OnMetadataUpdatedListener {
        public void onMetadataUpdated();
    }

    public static interface OnStatusUpdatedListener {
        public void onStatusUpdated();
    }
}

