/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.internal.ik;
import com.google.android.gms.internal.jz;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    private final String Fe;
    private int Ff;
    private String Fg;
    private MediaMetadata Fh;
    private long Fi;
    private List<MediaTrack> Fj;
    private TextTrackStyle Fk;
    private JSONObject Fl;

    MediaInfo(String contentId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentId)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.Fe = contentId;
        this.Ff = -1;
    }

    MediaInfo(JSONObject json) throws JSONException {
        int n2;
        JSONObject jSONObject;
        this.Fe = json.getString("contentId");
        String string2 = json.getString("streamType");
        this.Ff = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.Fg = json.getString("contentType");
        if (json.has("metadata")) {
            jSONObject = json.getJSONObject("metadata");
            n2 = jSONObject.getInt("metadataType");
            this.Fh = new MediaMetadata(n2);
            this.Fh.c(jSONObject);
        }
        this.Fi = ik.b(json.optDouble("duration", 0.0));
        if (json.has("tracks")) {
            this.Fj = new ArrayList<MediaTrack>();
            jSONObject = json.getJSONArray("tracks");
            for (n2 = 0; n2 < jSONObject.length(); ++n2) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(n2);
                MediaTrack mediaTrack = new MediaTrack(jSONObject2);
                this.Fj.add(mediaTrack);
            }
        } else {
            this.Fj = null;
        }
        if (json.has("textTrackStyle")) {
            jSONObject = json.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.c(jSONObject);
            this.Fk = textTrackStyle;
        } else {
            this.Fk = null;
        }
        this.Fl = json.optJSONObject("customData");
    }

    public String getContentId() {
        return this.Fe;
    }

    void setStreamType(int streamType) throws IllegalArgumentException {
        if (streamType < -1 || streamType > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.Ff = streamType;
    }

    public int getStreamType() {
        return this.Ff;
    }

    void setContentType(String contentType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.Fg = contentType;
    }

    public String getContentType() {
        return this.Fg;
    }

    void a(MediaMetadata mediaMetadata) {
        this.Fh = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.Fh;
    }

    void m(long l2) throws IllegalArgumentException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Stream duration cannot be negative");
        }
        this.Fi = l2;
    }

    public long getStreamDuration() {
        return this.Fi;
    }

    void c(List<MediaTrack> list) {
        this.Fj = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.Fj;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.Fk = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.Fk;
    }

    void setCustomData(JSONObject customData) {
        this.Fl = customData;
    }

    public JSONObject getCustomData() {
        return this.Fl;
    }

    void fv() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.Fe)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.Fg)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.Ff == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject bK() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.Fe);
            switch (this.Ff) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.Fg != null) {
                jSONObject.put("contentType", (Object)this.Fg);
            }
            if (this.Fh != null) {
                jSONObject.put("metadata", (Object)this.Fh.bK());
            }
            jSONObject.put("duration", ik.o(this.Fi));
            if (this.Fj != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.Fj) {
                    jSONArray.put((Object)mediaTrack.bK());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.Fk != null) {
                jSONObject.put("textTrackStyle", (Object)this.Fk.bK());
            }
            if (this.Fl != null) {
                jSONObject.put("customData", (Object)this.Fl);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)other;
        if (this.Fl == null != (mediaInfo.Fl == null)) {
            return false;
        }
        if (this.Fl != null && mediaInfo.Fl != null && !jz.d(this.Fl, mediaInfo.Fl)) {
            return false;
        }
        return ik.a(this.Fe, mediaInfo.Fe) && this.Ff == mediaInfo.Ff && ik.a(this.Fg, mediaInfo.Fg) && ik.a(this.Fh, mediaInfo.Fh) && this.Fi == mediaInfo.Fi;
    }

    public int hashCode() {
        return n.hashCode(this.Fe, this.Ff, this.Fg, this.Fh, this.Fi, String.valueOf(this.Fl));
    }

    public static class Builder {
        private final MediaInfo Fm;

        public Builder(String contentId) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)contentId)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.Fm = new MediaInfo(contentId);
        }

        public Builder setStreamType(int streamType) throws IllegalArgumentException {
            this.Fm.setStreamType(streamType);
            return this;
        }

        public Builder setContentType(String contentType) throws IllegalArgumentException {
            this.Fm.setContentType(contentType);
            return this;
        }

        public Builder setMetadata(MediaMetadata metadata) {
            this.Fm.a(metadata);
            return this;
        }

        public Builder setStreamDuration(long duration) throws IllegalArgumentException {
            this.Fm.m(duration);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.Fm.setCustomData(customData);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> mediaTracks) {
            this.Fm.c(mediaTracks);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.Fm.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.Fm.fv();
            return this.Fm;
        }
    }
}

