/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.b;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ik;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
implements SafeParcelable {
    public static final Parcelable.Creator<CastDevice> CREATOR = new b();
    private final int BR;
    private String ER;
    String ES;
    private Inet4Address ET;
    private String EU;
    private String EV;
    private String EW;
    private int EX;
    private List<WebImage> EY;
    private int EZ;
    private int Fa;

    CastDevice(int versionCode, String deviceId, String hostAddress, String friendlyName, String modelName, String deviceVersion, int servicePort, List<WebImage> icons, int capabilities, int status) {
        this.BR = versionCode;
        this.ER = deviceId;
        this.ES = hostAddress;
        if (this.ES != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.ES);
                if (inetAddress instanceof Inet4Address) {
                    this.ET = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.ET = null;
            }
        }
        this.EU = friendlyName;
        this.EV = modelName;
        this.EW = deviceVersion;
        this.EX = servicePort;
        this.EY = icons;
        this.EZ = capabilities;
        this.Fa = status;
    }

    private CastDevice() {
        this(3, null, null, null, null, null, -1, new ArrayList<WebImage>(), 0, -1);
    }

    int getVersionCode() {
        return this.BR;
    }

    public String getDeviceId() {
        return this.ER;
    }

    public Inet4Address getIpAddress() {
        return this.ET;
    }

    public String getFriendlyName() {
        return this.EU;
    }

    public String getModelName() {
        return this.EV;
    }

    public String getDeviceVersion() {
        return this.EW;
    }

    public int getServicePort() {
        return this.EX;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.EY);
    }

    public WebImage getIcon(int preferredWidth, int preferredHeight) {
        if (this.EY.isEmpty()) {
            return null;
        }
        if (preferredWidth <= 0 || preferredHeight <= 0) {
            return this.EY.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.EY) {
            int n2 = webImage3.getWidth();
            int n3 = webImage3.getHeight();
            if (n2 >= preferredWidth && n3 >= preferredHeight) {
                if (webImage != null && (webImage.getWidth() <= n2 || webImage.getHeight() <= n3)) continue;
                webImage = webImage3;
                continue;
            }
            if (n2 >= preferredWidth || n3 >= preferredHeight || webImage2 != null && (webImage2.getWidth() >= n2 || webImage2.getHeight() >= n3)) continue;
            webImage2 = webImage3;
        }
        Object object = null;
        object = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.EY.get(0));
        return object;
    }

    public boolean hasIcons() {
        return !this.EY.isEmpty();
    }

    public int getCapabilities() {
        return this.EZ;
    }

    public int getStatus() {
        return this.Fa;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.EU, this.ER);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)obj;
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return ik.a(this.ER, castDevice.ER) && ik.a(this.ET, castDevice.ET) && ik.a(this.EV, castDevice.EV) && ik.a(this.EU, castDevice.EU) && ik.a(this.EW, castDevice.EW) && this.EX == castDevice.EX && ik.a(this.EY, castDevice.EY) && this.EZ == castDevice.EZ && this.Fa == castDevice.Fa;
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return ik.a(this.getDeviceId(), castDevice.getDeviceId());
    }

    public int hashCode() {
        return this.ER == null ? 0 : this.ER.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle extras) {
        if (extras == null) {
            return null;
        }
        extras.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)extras.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }
}

