/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.AccountManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.AccountChangeEventsRequest;
import com.google.android.gms.auth.AccountChangeEventsResponse;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.UserRecoverableNotifiedException;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.internal.if;
import com.google.android.gms.internal.r;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;

public final class GoogleAuthUtil {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final String KEY_CALLER_UID = Build.VERSION.SDK_INT >= 11 ? "callerUid" : "callerUid";
    public static final String KEY_ANDROID_PACKAGE_NAME = Build.VERSION.SDK_INT >= 14 ? "androidPackageName" : "androidPackageName";
    public static final String KEY_REQUEST_ACTIONS = "request_visible_actions";
    @Deprecated
    public static final String KEY_REQUEST_VISIBLE_ACTIVITIES = "request_visible_actions";
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    private static final ComponentName Dn = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
    private static final ComponentName Do = new ComponentName("com.google.android.gms", "com.google.android.gms.recovery.RecoveryService");
    private static final Intent Dp = new Intent().setPackage("com.google.android.gms").setComponent(Dn);
    private static final Intent Dq = new Intent().setPackage("com.google.android.gms").setComponent(Do);

    public static String getToken(Context context, String accountName, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return GoogleAuthUtil.getToken(context, accountName, scope, new Bundle());
    }

    public static String getToken(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        com.google.android.gms.common.a a2;
        Context context2 = context.getApplicationContext();
        o.aU("Calling this from your main thread can lead to deadlock");
        GoogleAuthUtil.D(context2);
        extras = extras == null ? new Bundle() : new Bundle(extras);
        String string2 = context.getApplicationInfo().packageName;
        extras.putString("clientPackageName", string2);
        if (!extras.containsKey(KEY_ANDROID_PACKAGE_NAME)) {
            extras.putString(KEY_ANDROID_PACKAGE_NAME, string2);
        }
        if (context2.bindService(Dp, (ServiceConnection)(a2 = new com.google.android.gms.common.a()), 1)) {
            try {
                r r2 = r.a.a(a2.fW());
                Bundle bundle = r2.a(accountName, scope, extras);
                String string3 = bundle.getString("authtoken");
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    String string4 = string3;
                    return string4;
                }
                try {
                    String string5 = bundle.getString("Error");
                    Intent intent = (Intent)bundle.getParcelable("userRecoveryIntent");
                    if (GoogleAuthUtil.ax(string5)) {
                        throw new UserRecoverableAuthException(string5, intent);
                    }
                    if (GoogleAuthUtil.aw(string5)) {
                        throw new IOException(string5);
                    }
                    throw new GoogleAuthException(string5);
                }
                catch (RemoteException remoteException) {
                    Log.i((String)"GoogleAuthUtil", (String)"GMS remote exception ", (Throwable)remoteException);
                    throw new IOException("remote exception");
                }
                catch (InterruptedException interruptedException) {
                    throw new GoogleAuthException("Interrupted");
                }
            }
            finally {
                context2.unbindService((ServiceConnection)a2);
            }
        }
        throw new IOException("Could not bind to service with the given context.");
    }

    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (extras == null) {
            extras = new Bundle();
        }
        extras.putBoolean("handle_notification", true);
        return GoogleAuthUtil.a(context, accountName, scope, extras);
    }

    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras, Intent callback) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        GoogleAuthUtil.h(callback);
        extras = extras == null ? new Bundle() : extras;
        extras.putParcelable("callback_intent", (Parcelable)callback);
        extras.putBoolean("handle_notification", true);
        return GoogleAuthUtil.a(context, accountName, scope, extras);
    }

    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras, String authority, Bundle syncBundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (TextUtils.isEmpty((CharSequence)authority)) {
            throw new IllegalArgumentException("Authority cannot be empty or null.");
        }
        extras = extras == null ? new Bundle() : extras;
        syncBundle = syncBundle == null ? new Bundle() : syncBundle;
        ContentResolver.validateSyncExtrasBundle((Bundle)syncBundle);
        extras.putString("authority", authority);
        extras.putBundle("sync_extras", syncBundle);
        extras.putBoolean("handle_notification", true);
        return GoogleAuthUtil.a(context, accountName, scope, extras);
    }

    @Deprecated
    public static void invalidateToken(Context context, String token) {
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, token);
    }

    public static void clearToken(Context context, String token) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        block9: {
            com.google.android.gms.common.a a2;
            Context context2 = context.getApplicationContext();
            o.aU("Calling this from your main thread can lead to deadlock");
            GoogleAuthUtil.D(context2);
            Bundle bundle = new Bundle();
            String string2 = context.getApplicationInfo().packageName;
            bundle.putString("clientPackageName", string2);
            if (!bundle.containsKey(KEY_ANDROID_PACKAGE_NAME)) {
                bundle.putString(KEY_ANDROID_PACKAGE_NAME, string2);
            }
            if (context2.bindService(Dp, (ServiceConnection)(a2 = new com.google.android.gms.common.a()), 1)) {
                try {
                    r r2 = r.a.a(a2.fW());
                    Bundle bundle2 = r2.a(token, bundle);
                    String string3 = bundle2.getString(if.Ev);
                    if (!bundle2.getBoolean("booleanResult")) {
                        throw new GoogleAuthException(string3);
                    }
                    break block9;
                }
                catch (RemoteException remoteException) {
                    Log.i((String)"GoogleAuthUtil", (String)"GMS remote exception ", (Throwable)remoteException);
                    throw new IOException("remote exception");
                }
                catch (InterruptedException interruptedException) {
                    throw new GoogleAuthException("Interrupted");
                }
                finally {
                    context2.unbindService((ServiceConnection)a2);
                }
            }
            throw new IOException("Could not bind to service with the given context.");
        }
    }

    public static String getAppCert(Context context, String packageNameToCertify) {
        return "spatula";
    }

    public static List<AccountChangeEvent> getAccountChangeEvents(Context ctx, int eventIndex, String accountName) throws GoogleAuthException, IOException {
        o.b(accountName, (Object)"accountName must be provided");
        o.aU("Calling this from your main thread can lead to deadlock");
        Context context = ctx.getApplicationContext();
        GoogleAuthUtil.D(context);
        com.google.android.gms.common.a a2 = new com.google.android.gms.common.a();
        if (context.bindService(Dp, (ServiceConnection)a2, 1)) {
            try {
                r r2 = r.a.a(a2.fW());
                AccountChangeEventsRequest accountChangeEventsRequest = new AccountChangeEventsRequest().setAccountName(accountName).setEventIndex(eventIndex);
                AccountChangeEventsResponse accountChangeEventsResponse = r2.a(accountChangeEventsRequest);
                List<AccountChangeEvent> list = accountChangeEventsResponse.getEvents();
                return list;
            }
            catch (RemoteException remoteException) {
                Log.i((String)"GoogleAuthUtil", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("remote exception");
            }
            catch (InterruptedException interruptedException) {
                throw new GoogleAuthException("Interrupted");
            }
            finally {
                context.unbindService((ServiceConnection)a2);
            }
        }
        throw new IOException("Could not bind to service with the given context.");
    }

    public static String getAccountId(Context ctx, String accountName) throws GoogleAuthException, IOException {
        o.b(accountName, (Object)"accountName must be provided");
        o.aU("Calling this from your main thread can lead to deadlock");
        Context context = ctx.getApplicationContext();
        GoogleAuthUtil.D(context);
        return GoogleAuthUtil.getToken(ctx, accountName, "^^_account_id_^^", new Bundle());
    }

    private static void h(Intent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("Callback cannot be null.");
        }
        String string2 = intent.toUri(1);
        try {
            Intent.parseUri((String)string2, (int)1);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Parameter callback contains invalid data. It must be serializable using toUri() and parseUri().");
        }
    }

    private static String a(Context context, String string2, String string3, Bundle bundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (bundle == null) {
            bundle = new Bundle();
        }
        try {
            return GoogleAuthUtil.getToken(context, string2, string3, bundle);
        }
        catch (GooglePlayServicesAvailabilityException googlePlayServicesAvailabilityException) {
            int n2 = googlePlayServicesAvailabilityException.getConnectionStatusCode();
            if (GoogleAuthUtil.b(context, n2)) {
                a a2 = new a(context.getApplicationContext());
                a2.sendMessageDelayed(a2.obtainMessage(1), 30000L);
            } else {
                GooglePlayServicesUtil.showErrorNotification(n2, context);
            }
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
        catch (UserRecoverableAuthException userRecoverableAuthException) {
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
    }

    private static boolean b(Context context, int n2) {
        if (n2 == 1) {
            PackageManager packageManager = context.getPackageManager();
            try {
                if (packageManager.getApplicationInfo((String)"com.google.android.gms", (int)8192).enabled) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    private static void D(Context context) throws GoogleAuthException {
        try {
            GooglePlayServicesUtil.D(context);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            throw new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new GoogleAuthException(googlePlayServicesNotAvailableException.getMessage());
        }
    }

    private static boolean aw(String string2) {
        return "NetworkError".equals(string2) || "ServiceUnavailable".equals(string2) || "Timeout".equals(string2);
    }

    private static boolean ax(String string2) {
        return "BadAuthentication".equals(string2) || "CaptchaRequired".equals(string2) || "DeviceManagementRequiredOrSyncDisabled".equals(string2) || "NeedPermission".equals(string2) || "NeedsBrowser".equals(string2) || "UserCancel".equals(string2) || "AppDownloadRequired".equals(string2) || if.DT.ft().equals(string2) || if.DU.ft().equals(string2) || if.DV.ft().equals(string2) || if.DW.ft().equals(string2) || if.DX.ft().equals(string2) || if.DY.ft().equals(string2);
    }

    private GoogleAuthUtil() {
    }

    private static class a
    extends Handler {
        private final Context mD;

        a(Context context) {
            super(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
            this.mD = context;
        }

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mD);
                if (GooglePlayServicesUtil.isUserRecoverableError(n2)) {
                    GooglePlayServicesUtil.showErrorNotification(n2, this.mD);
                }
                return;
            }
            Log.wtf((String)"GoogleAuthUtil", (String)("Don't know how to handle this message: " + msg.what));
        }
    }
}

