/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.aa;
import com.google.android.gms.analytics.aj;
import com.google.android.gms.analytics.m;
import com.google.android.gms.analytics.p;
import com.google.android.gms.analytics.w;
import com.google.android.gms.analytics.x;
import com.google.android.gms.analytics.z;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;

class ag
implements m {
    private final String vW;
    private final HttpClient Bj;
    private final Context mContext;
    private GoogleAnalytics yu;
    private URL Bk;

    ag(HttpClient httpClient, GoogleAnalytics googleAnalytics, Context context) {
        this.mContext = context.getApplicationContext();
        this.vW = this.a("GoogleAnalytics", "3.0", Build.VERSION.RELEASE, aj.a(Locale.getDefault()), Build.MODEL, Build.ID);
        this.Bj = httpClient;
        this.yu = googleAnalytics;
    }

    ag(HttpClient httpClient, Context context) {
        this(httpClient, GoogleAnalytics.getInstance(context), context);
    }

    @Override
    public boolean dX() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            z.V("...no network connectivity");
            return false;
        }
        return true;
    }

    @Override
    public int a(List<w> list, aa aa2, boolean bl2) {
        int n2 = 0;
        int n3 = Math.min(list.size(), 40);
        aa2.e("_hr", list.size());
        int n4 = 0;
        URL uRL = null;
        boolean bl3 = true;
        for (int i2 = 0; i2 < n3; ++i2) {
            w w2 = list.get(i2);
            URL uRL2 = this.a(w2);
            if (uRL2 == null) {
                if (z.eK()) {
                    z.W("No destination: discarding hit: " + w2.eF());
                } else {
                    z.W("No destination: discarding hit.");
                }
                ++n2;
                ++n4;
                continue;
            }
            uRL = uRL2;
            HttpHost httpHost = new HttpHost(uRL2.getHost(), uRL2.getPort(), uRL2.getProtocol());
            String string2 = uRL2.getPath();
            String string3 = TextUtils.isEmpty((CharSequence)w2.eF()) ? "" : x.a(w2, System.currentTimeMillis());
            HttpEntityEnclosingRequest httpEntityEnclosingRequest = this.h(string3, string2);
            if (httpEntityEnclosingRequest == null) {
                ++n2;
                ++n4;
                continue;
            }
            httpEntityEnclosingRequest.addHeader("Host", httpHost.toHostString());
            if (z.eK()) {
                this.a(httpEntityEnclosingRequest);
            }
            if (string3.length() > 8192) {
                z.W("Hit too long (> 8192 bytes)--not sent");
                ++n4;
            } else if (this.yu.isDryRunEnabled()) {
                z.U("Dry run enabled. Hit not actually sent.");
            } else {
                try {
                    if (bl3) {
                        p.A(this.mContext);
                        bl3 = false;
                    }
                    HttpResponse httpResponse = this.Bj.execute(httpHost, (HttpRequest)httpEntityEnclosingRequest);
                    int n5 = httpResponse.getStatusLine().getStatusCode();
                    HttpEntity httpEntity = httpResponse.getEntity();
                    if (httpEntity != null) {
                        httpEntity.consumeContent();
                    }
                    if (n5 != 200) {
                        z.W("Bad response: " + httpResponse.getStatusLine().getStatusCode());
                    }
                }
                catch (ClientProtocolException clientProtocolException) {
                    z.W("ClientProtocolException sending hit; discarding hit...");
                    aa2.e("_hd", n4);
                }
                catch (IOException iOException) {
                    z.W("Exception sending hit: " + iOException.getClass().getSimpleName());
                    z.W(iOException.getMessage());
                    aa2.e("_de", 1);
                    aa2.e("_hd", n4);
                    aa2.e("_hs", n2);
                    this.a(aa2, uRL, bl3);
                    return n2;
                }
            }
            aa2.e("_td", string3.getBytes().length);
            ++n2;
        }
        aa2.e("_hd", n4);
        aa2.e("_hs", n2);
        if (bl2) {
            this.a(aa2, uRL, bl3);
        }
        return n2;
    }

    private void a(aa aa2, URL uRL, boolean bl2) {
        String string2 = aa2.eL();
        if (TextUtils.isEmpty((CharSequence)string2) || !this.eS()) {
            return;
        }
        if (uRL == null) {
            try {
                uRL = this.Bk != null ? this.Bk : new URL("https://ssl.google-analytics.com/collect");
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
        }
        HttpHost httpHost = new HttpHost(uRL.getHost(), uRL.getPort(), uRL.getProtocol());
        try {
            HttpEntityEnclosingRequest httpEntityEnclosingRequest = this.h(aa2.eL(), uRL.getPath());
            if (httpEntityEnclosingRequest == null) {
                return;
            }
            httpEntityEnclosingRequest.addHeader("Host", httpHost.toHostString());
            if (z.eK()) {
                this.a(httpEntityEnclosingRequest);
            }
            if (bl2) {
                p.A(this.mContext);
                bl2 = false;
            }
            HttpResponse httpResponse = this.Bj.execute(httpHost, (HttpRequest)httpEntityEnclosingRequest);
            int n2 = httpResponse.getStatusLine().getStatusCode();
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                httpEntity.consumeContent();
            }
            if (n2 != 200) {
                z.W("Bad response: " + httpResponse.getStatusLine().getStatusCode());
            }
        }
        catch (ClientProtocolException clientProtocolException) {
            z.W("ClientProtocolException sending monitoring hit.");
        }
        catch (IOException iOException) {
            z.W("Exception sending monitoring hit: " + iOException.getClass().getSimpleName());
            z.W(iOException.getMessage());
            return;
        }
    }

    boolean eS() {
        return Math.random() * 100.0 <= 1.0;
    }

    private HttpEntityEnclosingRequest h(String string2, String string3) {
        BasicHttpEntityEnclosingRequest basicHttpEntityEnclosingRequest;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            z.W("Empty hit, discarding.");
            return null;
        }
        String string4 = string3 + "?" + string2;
        if (string4.length() < 2036) {
            basicHttpEntityEnclosingRequest = new BasicHttpEntityEnclosingRequest("GET", string4);
        } else {
            basicHttpEntityEnclosingRequest = new BasicHttpEntityEnclosingRequest("POST", string3);
            try {
                basicHttpEntityEnclosingRequest.setEntity((HttpEntity)new StringEntity(string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                z.W("Encoding error, discarding hit");
                return null;
            }
        }
        basicHttpEntityEnclosingRequest.addHeader("User-Agent", this.vW);
        return basicHttpEntityEnclosingRequest;
    }

    private void a(HttpEntityEnclosingRequest httpEntityEnclosingRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Header header : httpEntityEnclosingRequest.getAllHeaders()) {
            stringBuffer.append(header.toString()).append("\n");
        }
        stringBuffer.append(httpEntityEnclosingRequest.getRequestLine().toString()).append("\n");
        if (httpEntityEnclosingRequest.getEntity() != null) {
            try {
                int n2;
                InputStream inputStream = httpEntityEnclosingRequest.getEntity().getContent();
                if (inputStream != null && (n2 = inputStream.available()) > 0) {
                    byte[] byArray = new byte[n2];
                    inputStream.read(byArray);
                    stringBuffer.append("POST:\n");
                    stringBuffer.append(new String(byArray)).append("\n");
                }
            }
            catch (IOException iOException) {
                z.V("Error Writing hit to log...");
            }
        }
        z.V(stringBuffer.toString());
    }

    String a(String string2, String string3, String string4, String string5, String string6, String string7) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string2, string3, string4, string5, string6, string7);
    }

    URL a(w w2) {
        if (this.Bk != null) {
            return this.Bk;
        }
        String string2 = w2.eI();
        try {
            return new URL("http:".equals(string2) ? "http://www.google-analytics.com/collect" : "https://ssl.google-analytics.com/collect");
        }
        catch (MalformedURLException malformedURLException) {
            z.T("Error trying to parse the hardcoded host url. This really shouldn't happen.");
            return null;
        }
    }

    @Override
    public void af(String string2) {
        try {
            this.Bk = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.Bk = null;
        }
    }
}

