/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.e;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class PutDataRequest
implements SafeParcelable {
    public static final String WEAR_URI_SCHEME = "wear";
    public static final Parcelable.Creator<PutDataRequest> CREATOR = new e();
    private static final Random auO = new SecureRandom();
    final int BR;
    private final Uri mUri;
    private final Bundle auP;
    private byte[] acw;

    PutDataRequest(int versionCode, Uri uri, Bundle assets, byte[] data) {
        this.BR = versionCode;
        this.mUri = uri;
        this.auP = assets;
        this.auP.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        this.acw = data;
    }

    private PutDataRequest(int versionCode, Uri uri) {
        this(versionCode, uri, new Bundle(), null);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        e.a(this, dest, flags);
    }

    public static PutDataRequest createFromDataItem(DataItem source) {
        PutDataRequest putDataRequest = PutDataRequest.k(source.getUri());
        for (Map.Entry<String, DataItemAsset> entry : source.getAssets().entrySet()) {
            if (entry.getValue().getId() == null) {
                throw new IllegalStateException("Cannot create an asset for a put request without a digest: " + entry.getKey());
            }
            putDataRequest.putAsset(entry.getKey(), Asset.createFromRef(entry.getValue().getId()));
        }
        putDataRequest.setData(source.getData());
        return putDataRequest;
    }

    public static PutDataRequest k(Uri uri) {
        return new PutDataRequest(1, uri);
    }

    public static PutDataRequest createWithAutoAppendedId(String pathPrefix) {
        StringBuilder stringBuilder = new StringBuilder(pathPrefix);
        if (!pathPrefix.endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("PN").append(auO.nextLong());
        Uri uri = PutDataRequest.dd(stringBuilder.toString());
        return new PutDataRequest(1, uri);
    }

    public static PutDataRequest create(String path) {
        Uri uri = PutDataRequest.dd(path);
        return PutDataRequest.k(uri);
    }

    private static Uri dd(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("An empty path was supplied.");
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        if (string.startsWith("//")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        return new Uri.Builder().scheme(WEAR_URI_SCHEME).path(string).build();
    }

    public Uri getUri() {
        return this.mUri;
    }

    public byte[] getData() {
        return this.acw;
    }

    public PutDataRequest setData(byte[] data) {
        this.acw = data;
        return this;
    }

    public Map<String, Asset> getAssets() {
        HashMap<String, Asset> hashMap = new HashMap<String, Asset>();
        for (String string : this.auP.keySet()) {
            hashMap.put(string, (Asset)this.auP.getParcelable(string));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Bundle pR() {
        return this.auP;
    }

    public Asset getAsset(String key) {
        return (Asset)this.auP.getParcelable(key);
    }

    public boolean hasAsset(String key) {
        return this.auP.containsKey(key);
    }

    public PutDataRequest putAsset(String key, Asset value) {
        n.i(key);
        n.i(value);
        this.auP.putParcelable(key, (Parcelable)value);
        return this;
    }

    public PutDataRequest removeAsset(String key) {
        this.auP.remove(key);
        return this;
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataMap", (int)3));
    }

    public String toString(boolean verbose) {
        StringBuilder stringBuilder = new StringBuilder("PutDataRequest[");
        stringBuilder.append("dataSz=" + (this.acw == null ? "null" : Integer.valueOf(this.acw.length)));
        stringBuilder.append(", numAssets=" + this.auP.size());
        stringBuilder.append(", uri=" + this.mUri);
        if (!verbose) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        Set set = this.auP.keySet();
        for (String string : set) {
            stringBuilder.append("\n    " + string + ": " + this.auP.getParcelable(string));
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }
}

